/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.render;

import com.jaquadro.minecraft.chameleon.render.ChamRenderAO;
import com.jaquadro.minecraft.chameleon.render.ChamRenderLL;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class ChamRender {
    public static final int YNEG = 0;
    public static final int YPOS = 1;
    public static final int ZNEG = 2;
    public static final int ZPOS = 3;
    public static final int XNEG = 4;
    public static final int XPOS = 5;
    public static final EnumFacing FACE_YNEG = EnumFacing.DOWN;
    public static final EnumFacing FACE_YPOS = EnumFacing.UP;
    public static final EnumFacing FACE_ZNEG = EnumFacing.NORTH;
    public static final EnumFacing FACE_ZPOS = EnumFacing.SOUTH;
    public static final EnumFacing FACE_XNEG = EnumFacing.WEST;
    public static final EnumFacing FACE_XPOS = EnumFacing.EAST;
    public static final int FULL_BRIGHTNESS = 0xF000F0;
    public static final float[] COLOR_WHITE = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[][] normMap = new float[][]{{0.0f, -1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}};
    private VertexBuffer tessellator;
    public ChamRenderState state = new ChamRenderState();
    private boolean drawToFaceGroup;
    private ChamRenderAO aoHelper = new ChamRenderAO(this.state);
    private ChamRenderLL llHelper = new ChamRenderLL(this.state);
    private float[] colorScratch = new float[3];
    @Deprecated
    public static ChamRender instance = new ChamRender();

    public static void calculateBaseColor(float[] target, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float gray = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float rg = (r * 30.0f + g * 70.0f) / 100.0f;
            float rb = (r * 30.0f + b * 70.0f) / 100.0f;
            r = gray;
            g = rg;
            b = rb;
        }
        target[0] = r;
        target[1] = g;
        target[2] = b;
    }

    public static void scaleColor(float[] target, float[] source, float scale) {
        target[0] = source[0] * scale;
        target[1] = source[1] * scale;
        target[2] = source[2] * scale;
    }

    void setVertexBuffer(VertexBuffer buffer) {
        this.tessellator = buffer;
        this.llHelper.setTessellator(buffer);
    }

    VertexBuffer getVertexBuffer() {
        return this.tessellator;
    }

    public void targetFaceGroup(boolean target) {
        this.drawToFaceGroup = target;
    }

    public void renderEmptyPlane(BlockPos pos) {
        this.state.setRenderBounds(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.llHelper.drawFace(FACE_YNEG, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getDefaultSprite());
    }

    public void setRenderBounds(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        this.state.setRenderBounds(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void setRenderBounds(double[] bound) {
        this.state.setRenderBounds(bound[0], bound[1], bound[2], bound[3], bound[4], bound[5]);
    }

    public void setRenderBounds(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos) {
        AxisAlignedBB bound = blockState.func_185900_c(blockAccess, pos);
        this.setRenderBounds(bound.field_72340_a, bound.field_72338_b, bound.field_72339_c, bound.field_72336_d, bound.field_72337_e, bound.field_72334_f);
    }

    public void renderFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, TextureAtlasSprite icon) {
        this.renderFaceColorMult(face, blockAccess, blockState, BlockPos.field_177992_a, icon, 1.0f, 1.0f, 1.0f);
    }

    public void renderFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, TextureAtlasSprite icon, float r, float g, float b) {
        this.renderFaceColorMult(face, blockAccess, blockState, BlockPos.field_177992_a, icon, r, g, b);
    }

    public void renderFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon) {
        this.renderFace(face, blockAccess, blockState, pos, icon, 1.0f, 1.0f, 1.0f);
    }

    public void renderFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, float r, float g, float b) {
        if (Minecraft.func_71379_u() && blockAccess != null && blockState.func_177230_c().getLightValue(blockState, blockAccess, pos) == 0) {
            this.renderFaceAOPartial(face, blockAccess, blockState, pos, icon, r, g, b);
        } else {
            this.renderFaceColorMult(face, blockAccess, blockState, pos, icon, r, g, b);
        }
    }

    public void renderFaceColorMult(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, float r, float g, float b) {
        this.setupColorMult(face, blockAccess, blockState, pos, r, g, b);
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        this.llHelper.drawFace(face, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), icon, this.drawToFaceGroup);
        if (blockAccess == null && !this.llHelper.isBaking()) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public void bakeFace(EnumFacing face, IBlockState blockState, TextureAtlasSprite icon, boolean isFaceGroup) {
        this.bakeFace(face, blockState, icon, isFaceGroup, 1.0f, 1.0f, 1.0f);
    }

    public void bakeFace(EnumFacing face, IBlockState blockState, TextureAtlasSprite icon, boolean isFaceGroup, float r, float g, float b) {
        float scale = this.state.getColorMult(face);
        this.state.setColor(r * scale, g * scale, b * scale);
        this.state.setNormal(normMap[face.func_176745_a()]);
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        this.llHelper.drawFace(face, 0.0, 0.0, 0.0, icon, isFaceGroup);
    }

    public void renderFaceAOPartial(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, float r, float g, float b) {
        this.state.enableAO = true;
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        switch (face.func_176745_a()) {
            case 0: {
                this.aoHelper.setupYNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 1: {
                this.aoHelper.setupYPosAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 2: {
                this.aoHelper.setupZNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 3: {
                this.aoHelper.setupZPosAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 4: {
                this.aoHelper.setupXNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 5: {
                this.aoHelper.setupXPosAOPartial(blockAccess, blockState, pos, r, g, b);
            }
        }
        this.llHelper.drawFace(face, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), icon);
        this.state.enableAO = false;
    }

    public void renderPartialFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax) {
        this.renderPartialFace(face, blockAccess, blockState, pos, icon, uMin, vMin, uMax, vMax, 1.0f, 1.0f, 1.0f);
    }

    public void renderPartialFace(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        if (Minecraft.func_71379_u() && blockAccess != null && blockState.func_177230_c().getLightValue(blockState, blockAccess, pos) == 0) {
            this.renderPartialFaceAOPartial(face, blockAccess, blockState, pos, icon, uMin, vMin, uMax, vMax, r, g, b);
        } else {
            this.renderPartialFaceColorMult(face, blockAccess, blockState, pos, icon, uMin, vMin, uMax, vMax, r, g, b);
        }
    }

    public void renderPartialFaceColorMult(EnumFacing face, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.setupColorMult(face, r, g, b);
        this.renderPartialFace(face, icon, uMin, vMin, uMax, vMax);
        if (!this.llHelper.isBaking()) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public void renderPartialFaceColorMult(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.setupColorMult(face, blockAccess, blockState, pos, r, g, b);
        this.renderPartialFace(face, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), icon, uMin, vMin, uMax, vMax);
        if (blockAccess == null && !this.llHelper.isBaking()) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public void bakePartialFace(EnumFacing face, IBlockState blockState, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, boolean isFaceGroup) {
        this.bakePartialFace(face, blockState, icon, uMin, vMin, uMax, vMax, isFaceGroup, 1.0f, 1.0f, 1.0f);
    }

    public void bakePartialFace(EnumFacing face, IBlockState blockState, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, boolean isFaceGroup, float r, float g, float b) {
        float scale = this.state.getColorMult(face);
        this.state.setColor(r * scale, g * scale, b * scale);
        this.state.setNormal(normMap[face.func_176745_a()]);
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        this.llHelper.drawPartialFace(face, 0.0, 0.0, 0.0, icon, uMin, vMin, uMax, vMax, isFaceGroup);
    }

    public void renderPartialFaceAOPartial(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.state.enableAO = true;
        switch (ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]) {
            case 0: {
                this.aoHelper.setupYNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 1: {
                this.aoHelper.setupYPosAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 2: {
                this.aoHelper.setupZNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 3: {
                this.aoHelper.setupZPosAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 4: {
                this.aoHelper.setupXNegAOPartial(blockAccess, blockState, pos, r, g, b);
                break;
            }
            case 5: {
                this.aoHelper.setupXPosAOPartial(blockAccess, blockState, pos, r, g, b);
            }
        }
        this.renderPartialFace(face, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), icon, uMin, vMin, uMax, vMax);
        this.state.enableAO = false;
    }

    public void renderPartialFace(EnumFacing face, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax) {
        this.state.enableAO = false;
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        this.llHelper.drawPartialFace(face, 0.0, 0.0, 0.0, icon, uMin, vMin, uMax, vMax, this.drawToFaceGroup);
    }

    public void renderPartialFace(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax) {
        face = EnumFacing.func_82600_a((int)ChamRenderState.FACE_BY_FACE_ROTATION[face.func_176745_a()][this.state.rotateTransform]);
        this.llHelper.drawPartialFace(face, x, y, z, icon, uMin, vMin, uMax, vMax, this.drawToFaceGroup);
    }

    public void renderCrossedSquares(IBlockState blockState, TextureAtlasSprite icon) {
        if (this.tessellator == null) {
            return;
        }
        this.state.setBrightness(0xF000F0);
        this.state.setColor(COLOR_WHITE);
        boolean lighting = GL11.glIsEnabled((int)2896);
        GL11.glDisable((int)2896);
        this.drawCrossedSquares(icon, 0.0, 0.0, 0.0, 1.0f);
        if (lighting) {
            GL11.glEnable((int)2896);
        }
    }

    public void renderCrossedSquares(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, TextureAtlasSprite icon) {
        if (this.tessellator == null) {
            return;
        }
        Block block = blockState.func_177230_c();
        this.state.setBrightness(blockState.func_185889_a(blockAccess, pos));
        this.state.setColor(COLOR_WHITE);
        this.drawCrossedSquares(icon, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0f);
    }

    public void drawCrossedSquares(TextureAtlasSprite icon, double x, double y, double z, float scale) {
        if (this.tessellator == null) {
            return;
        }
        x += this.state.renderOffsetX;
        y += this.state.renderOffsetY;
        z += this.state.renderOffsetZ;
        double uMin = icon.func_94214_a(this.state.renderMinX * 16.0);
        double uMax = icon.func_94214_a(this.state.renderMaxX * 16.0);
        double vMin = icon.func_94207_b(16.0 - this.state.renderMaxY * 16.0);
        double vMax = icon.func_94207_b(16.0 - this.state.renderMinY * 16.0);
        double d7 = 0.45 * (double)scale;
        double xMin = x + 0.5 - d7;
        double xMax = x + 0.5 + d7;
        double yMin = y + this.state.renderMinY * (double)scale;
        double yMax = y + this.state.renderMaxY * (double)scale;
        double zMin = z + 0.5 - d7;
        double zMax = z + 0.5 + d7;
        this.addBlockVertex(xMin, yMax, zMin, uMin, vMin);
        this.addBlockVertex(xMin, yMin, zMin, uMin, vMax);
        this.addBlockVertex(xMax, yMin, zMax, uMax, vMax);
        this.addBlockVertex(xMax, yMax, zMax, uMax, vMin);
        this.addBlockVertex(xMax, yMax, zMax, uMin, vMin);
        this.addBlockVertex(xMax, yMin, zMax, uMin, vMax);
        this.addBlockVertex(xMin, yMin, zMin, uMax, vMax);
        this.addBlockVertex(xMin, yMax, zMin, uMax, vMin);
        this.addBlockVertex(xMin, yMax, zMax, uMin, vMin);
        this.addBlockVertex(xMin, yMin, zMax, uMin, vMax);
        this.addBlockVertex(xMax, yMin, zMin, uMax, vMax);
        this.addBlockVertex(xMax, yMax, zMin, uMax, vMin);
        this.addBlockVertex(xMax, yMax, zMin, uMin, vMin);
        this.addBlockVertex(xMax, yMin, zMin, uMin, vMax);
        this.addBlockVertex(xMin, yMin, zMax, uMax, vMax);
        this.addBlockVertex(xMin, yMax, zMax, uMax, vMin);
    }

    public void drawCrossedSquaresBounded(TextureAtlasSprite icon, double x, double y, double z, float scale) {
        if (this.tessellator == null) {
            return;
        }
        x += this.state.renderOffsetX;
        y += this.state.renderOffsetY;
        z += this.state.renderOffsetZ;
        double vMin = icon.func_94207_b(16.0 - this.state.renderMaxY * 16.0);
        double vMax = icon.func_94207_b(16.0 - this.state.renderMinY * 16.0);
        double xzNN = Math.max(this.state.renderMinX, this.state.renderMinZ);
        double xzPP = Math.min(this.state.renderMaxX, this.state.renderMaxZ);
        double xNN = x + 0.5 - (0.5 - xzNN) * 0.9;
        double zNN = z + 0.5 - (0.5 - xzNN) * 0.9;
        double xNP = x + 0.5 - (0.5 - Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ)) * 0.9;
        double zNP = z + 0.5 - (0.5 - Math.min(1.0 - this.state.renderMinX, this.state.renderMaxZ)) * 0.9;
        double xPN = x + 0.5 - (0.5 - Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ)) * 0.9;
        double zPN = z + 0.5 - (0.5 - Math.max(1.0 - this.state.renderMaxX, this.state.renderMinZ)) * 0.9;
        double xPP = x + 0.5 - (0.5 - xzPP) * 0.9;
        double zPP = z + 0.5 - (0.5 - xzPP) * 0.9;
        double yMin = y + this.state.renderMinY * (double)scale;
        double yMax = y + this.state.renderMaxY * (double)scale;
        double uNN = icon.func_94214_a(xzNN * 16.0);
        double uPP = icon.func_94214_a(xzPP * 16.0);
        this.addBlockVertex(xNN, yMax, zNN, uNN, vMin);
        this.addBlockVertex(xNN, yMin, zNN, uNN, vMax);
        this.addBlockVertex(xPP, yMin, zPP, uPP, vMax);
        this.addBlockVertex(xPP, yMax, zPP, uPP, vMin);
        uNN = icon.func_94214_a(16.0 - xzNN * 16.0);
        uPP = icon.func_94214_a(16.0 - xzPP * 16.0);
        this.addBlockVertex(xPP, yMax, zPP, uPP, vMin);
        this.addBlockVertex(xPP, yMin, zPP, uPP, vMax);
        this.addBlockVertex(xNN, yMin, zNN, uNN, vMax);
        this.addBlockVertex(xNN, yMax, zNN, uNN, vMin);
        double uNP = icon.func_94214_a(Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ) * 16.0);
        double uPN = icon.func_94214_a(Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ) * 16.0);
        this.addBlockVertex(xNP, yMax, zNP, uNP, vMin);
        this.addBlockVertex(xNP, yMin, zNP, uNP, vMax);
        this.addBlockVertex(xPN, yMin, zPN, uPN, vMax);
        this.addBlockVertex(xPN, yMax, zPN, uPN, vMin);
        uNP = icon.func_94214_a(16.0 - Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ) * 16.0);
        uPN = icon.func_94214_a(16.0 - Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ) * 16.0);
        this.addBlockVertex(xPN, yMax, zPN, uPN, vMin);
        this.addBlockVertex(xPN, yMin, zPN, uPN, vMax);
        this.addBlockVertex(xNP, yMin, zNP, uNP, vMax);
        this.addBlockVertex(xNP, yMax, zNP, uNP, vMin);
    }

    public void startBaking(VertexFormat format) {
        this.llHelper.startBaking(format);
    }

    public void startBaking(VertexFormat format, int tintIndex) {
        this.llHelper.startBaking(format, tintIndex);
    }

    public void stopBaking() {
        this.llHelper.stopBaking();
    }

    public List<BakedQuad> takeBakedQuads(EnumFacing dir) {
        return this.llHelper.takeBakedQuads(dir);
    }

    private void setupColorMult(EnumFacing face, float r, float g, float b) {
        float[] norm = normMap[face.func_176745_a()];
        float scale = this.state.getColorMult(face);
        this.state.setColor(scale * r, scale * g, scale * b);
        this.state.setNormal(norm);
        if (!this.llHelper.isBaking() && this.tessellator != null) {
            this.tessellator.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        }
        this.state.enableAO = false;
    }

    private void setupColorMult(EnumFacing face, IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, float r, float g, float b) {
        float[] norm = normMap[face.func_176745_a()];
        float scale = this.state.getColorMult(face);
        if (blockAccess == null) {
            this.state.setColor(r * scale, g * scale, b * scale);
            this.state.setNormal(norm);
            if (!this.llHelper.isBaking() && this.tessellator != null) {
                this.tessellator.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            }
        } else {
            int brightX = pos.func_177958_n();
            int brightY = pos.func_177956_o();
            int brightZ = pos.func_177952_p();
            switch (face.func_176745_a()) {
                case 0: {
                    brightY = this.state.renderMinY > 0.0 ? brightY : brightY - 1;
                    break;
                }
                case 1: {
                    brightY = this.state.renderMaxY < 1.0 ? brightY : brightY + 1;
                    break;
                }
                case 2: {
                    brightZ = this.state.renderMinZ > 0.0 ? brightZ : brightZ - 1;
                    break;
                }
                case 3: {
                    brightZ = this.state.renderMaxZ < 1.0 ? brightZ : brightZ + 1;
                    break;
                }
                case 4: {
                    brightX = this.state.renderMinX > 0.0 ? brightX : brightX - 1;
                    break;
                }
                case 5: {
                    int n = brightX = this.state.renderMaxX < 1.0 ? brightX : brightX + 1;
                }
            }
            if (brightX != pos.func_177958_n() || brightY != pos.func_177956_o() || brightZ != pos.func_177952_p()) {
                pos = new BlockPos(brightX, brightY, brightZ);
            }
            this.state.setColor(scale * r, scale * g, scale * b);
            this.state.setBrightness(blockState.func_185889_a(blockAccess, pos));
        }
        this.state.enableAO = false;
    }

    private TextureAtlasSprite getDefaultSprite() {
        return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
    }

    private void addBlockVertex(double x, double y, double z, double u, double v) {
        if (this.tessellator.func_178973_g().func_177350_b()) {
            this.tessellator.func_181662_b(x, y, z).func_187315_a(u, v).func_181663_c(this.state.normal[0], this.state.normal[1], this.state.normal[2]).func_181666_a(this.state.color[0], this.state.color[1], this.state.color[2], 1.0f).func_181675_d();
        } else {
            int lsky = this.state.brightness >> 16 & 0xFF;
            int lblk = this.state.brightness & 0xFF;
            this.tessellator.func_181662_b(x, y, z).func_187315_a(u, v).func_187314_a(lsky, lblk).func_181666_a(this.state.color[0], this.state.color[1], this.state.color[2], 1.0f).func_181675_d();
        }
    }
}

