/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.data.role.IJobPuppet;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.util.ValueUtil;

public class JobPuppet
extends JobInterface
implements IJobPuppet {
    public PartConfig head = new PartConfig();
    public PartConfig larm = new PartConfig();
    public PartConfig rarm = new PartConfig();
    public PartConfig body = new PartConfig();
    public PartConfig lleg = new PartConfig();
    public PartConfig rleg = new PartConfig();
    public boolean whileStanding = true;
    public boolean whileAttacking = false;
    public boolean whileMoving = false;

    public JobPuppet(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public IJobPuppet.IJobPuppetPart getPart(int part) {
        if (part == 1) {
            return this.larm;
        }
        if (part == 2) {
            return this.rarm;
        }
        if (part == 3) {
            return this.body;
        }
        if (part == 4) {
            return this.lleg;
        }
        if (part == 5) {
            return this.rleg;
        }
        return this.head;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("PuppetHead", (NBTBase)this.head.writeNBT());
        compound.func_74782_a("PuppetLArm", (NBTBase)this.larm.writeNBT());
        compound.func_74782_a("PuppetRArm", (NBTBase)this.rarm.writeNBT());
        compound.func_74782_a("PuppetBody", (NBTBase)this.body.writeNBT());
        compound.func_74782_a("PuppetLLeg", (NBTBase)this.lleg.writeNBT());
        compound.func_74782_a("PuppetRLeg", (NBTBase)this.rleg.writeNBT());
        compound.func_74757_a("PuppetStanding", this.whileStanding);
        compound.func_74757_a("PuppetAttacking", this.whileAttacking);
        compound.func_74757_a("PuppetMoving", this.whileMoving);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.head.readNBT(compound.func_74775_l("PuppetHead"));
        this.larm.readNBT(compound.func_74775_l("PuppetLArm"));
        this.rarm.readNBT(compound.func_74775_l("PuppetRArm"));
        this.body.readNBT(compound.func_74775_l("PuppetBody"));
        this.lleg.readNBT(compound.func_74775_l("PuppetLLeg"));
        this.rleg.readNBT(compound.func_74775_l("PuppetRLeg"));
        this.whileStanding = compound.func_74767_n("PuppetStanding");
        this.whileAttacking = compound.func_74767_n("PuppetAttacking");
        this.whileMoving = compound.func_74767_n("PuppetMoving");
    }

    @Override
    public boolean aiShouldExecute() {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void delete() {
    }

    public boolean isActive() {
        if (!this.npc.func_70089_S()) {
            return false;
        }
        return this.whileAttacking && this.npc.isAttacking() || this.whileMoving && this.npc.isWalking() || this.whileStanding && !this.npc.isWalking();
    }

    public class PartConfig
    implements IJobPuppet.IJobPuppetPart {
        public float rotationX = 0.0f;
        public float rotationY = 0.0f;
        public float rotationZ = 0.0f;
        public boolean disabled = false;

        public NBTTagCompound writeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74776_a("RotationX", this.rotationX);
            compound.func_74776_a("RotationY", this.rotationY);
            compound.func_74776_a("RotationZ", this.rotationZ);
            compound.func_74757_a("Disabled", this.disabled);
            return compound;
        }

        public void readNBT(NBTTagCompound compound) {
            this.rotationX = ValueUtil.correctFloat(compound.func_74760_g("RotationX"), -1.0f, 1.0f);
            this.rotationY = ValueUtil.correctFloat(compound.func_74760_g("RotationY"), -1.0f, 1.0f);
            this.rotationZ = ValueUtil.correctFloat(compound.func_74760_g("RotationZ"), -1.0f, 1.0f);
            this.disabled = compound.func_74767_n("Disabled");
        }

        @Override
        public int getRotationX() {
            return (int)(this.rotationX + 180.0f);
        }

        @Override
        public int getRotationY() {
            return (int)(this.rotationY + 180.0f);
        }

        @Override
        public int getRotationZ() {
            return (int)(this.rotationZ + 180.0f);
        }

        @Override
        public void setRotation(int x, int y, int z) {
            this.disabled = false;
            this.rotationX = ValueUtil.correctFloat((float)x / 180.0f - 1.0f, -1.0f, 1.0f);
            this.rotationY = ValueUtil.correctFloat((float)y / 180.0f - 1.0f, -1.0f, 1.0f);
            this.rotationZ = ValueUtil.correctFloat((float)z / 180.0f - 1.0f, -1.0f, 1.0f);
            JobPuppet.this.npc.updateClient = true;
        }
    }
}

