/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.quests.QuestInterface;

public class QuestDialog
extends QuestInterface {
    public HashMap<Integer, Integer> dialogs = new HashMap();

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.dialogs = NBTTags.getIntegerIntegerMap(compound.func_150295_c("QuestDialogs", 10));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("QuestDialogs", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.dialogs));
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        for (int dialogId : this.dialogs.values()) {
            if (PlayerData.get((EntityPlayer)player).dialogData.dialogsRead.contains(dialogId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        for (int dialogId : this.dialogs.values()) {
            Dialog dialog = DialogController.instance.dialogs.get(dialogId);
            if (dialog == null) continue;
            String title = dialog.title;
            title = PlayerData.get((EntityPlayer)player).dialogData.dialogsRead.contains(dialogId) ? title + " (read)" : title + " (unread)";
            vec.add(title);
        }
        return vec;
    }
}

