/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IQuestHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockFluidContainerWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class WrapperNpcAPI
extends NpcAPI {
    public static final EventBus EVENT_BUS = new EventBus();
    private static NpcAPI instance = null;

    @Override
    public IEntity getIEntity(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        return WrapperEntityData.get(entity);
    }

    @Override
    public ICustomNpc createNPC(World world) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        return npc.wrappedNPC;
    }

    @Override
    public ICustomNpc spawnNPC(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(world);
        npc.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.ais.setStartPos(new BlockPos(x, y, z));
        npc.func_70606_j(npc.func_110138_aP());
        world.func_72838_d((Entity)npc);
        return npc.wrappedNPC;
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    @Override
    public EventBus events() {
        return EVENT_BUS;
    }

    @Override
    public IBlock getIBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null || block.isAir(state, (IBlockAccess)world, pos)) {
            return null;
        }
        if (block instanceof BlockScripted) {
            return new BlockScriptedWrapper(world, block, pos);
        }
        if (block instanceof BlockScriptedDoor) {
            return new BlockScriptedDoorWrapper(world, block, pos);
        }
        if (block instanceof BlockFluidBase) {
            return new BlockFluidContainerWrapper(world, block, pos);
        }
        return new BlockWrapper(world, block, pos);
    }

    @Override
    public IItemStack getIItemStack(ItemStack itemstack) {
        return ItemStackWrapper.create(itemstack);
    }

    @Override
    public IContainer getIContainer(IInventory inventory) {
        return new ContainerWrapper(inventory);
    }

    @Override
    public IContainer getIContainer(Container container) {
        return new ContainerWrapper(container);
    }

    @Override
    public IFactionHandler getFactions(MinecraftServer server) {
        this.checkWorld(server);
        return FactionController.getInstance();
    }

    private void checkWorld(MinecraftServer server) {
        if (server == null || server.func_71241_aa()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public IRecipeHandler getRecipes(MinecraftServer server) {
        this.checkWorld(server);
        return RecipeController.instance;
    }

    @Override
    public IQuestHandler getQuests(MinecraftServer server) {
        this.checkWorld(server);
        return QuestController.instance;
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public File getWorldDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }

    @Override
    public void registerCommand(CommandNoppesBase command) {
        CustomNpcs.NoppesCommand.registerCommand(command);
    }
}

