/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.util.BaseInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MyBlockPos {
    public int x;
    public int y;
    public int z;
    public String world;
    public int dim;

    public MyBlockPos(World world, BlockPos pos, int dim) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public MyBlockPos(World world, int x, int y, int z, int dim) {
        this(world.func_72912_H().func_76065_j(), x, y, z, dim);
    }

    public MyBlockPos(String world, BlockPos pos, int dim) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.world = world;
        this.dim = dim;
    }

    public MyBlockPos(String world, int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.dim = dim;
    }

    public Connection canConnectTo(BaseInfo inf) {
        if (inf == null) {
            return Connection.VALID;
        }
        if (ConfigHandler.deactivateTeleportation) {
            return Connection.VALID;
        }
        if (!(ConfigHandler.interdimensional || this.sameWorld(inf.pos) && this.sameDim(inf.pos))) {
            return Connection.WORLD;
        }
        if (ConfigHandler.maxDist > -1 && this.distance(inf.pos) > (double)ConfigHandler.maxDist) {
            return Connection.DIST;
        }
        return Connection.VALID;
    }

    public void writeToNBT(NBTTagCompound tC) {
        int[] arr = new int[]{this.x, this.y, this.z, this.dim};
        tC.func_74783_a("Position", arr);
        tC.func_74778_a("WorldName", this.world);
    }

    public static MyBlockPos readFromNBT(NBTTagCompound tC) {
        int[] arr = tC.func_74759_k("Position");
        return new MyBlockPos(tC.func_74779_i("WorldName"), arr[0], arr[1], arr[2], arr[3]);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.world);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dim);
    }

    public static MyBlockPos fromBytes(ByteBuf buf) {
        String world = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        int dim = buf.readInt();
        return new MyBlockPos(world, x, y, z, dim);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MyBlockPos)) {
            return false;
        }
        MyBlockPos other = (MyBlockPos)obj;
        if (other.x != this.x) {
            return false;
        }
        if (other.y != this.y) {
            return false;
        }
        if (other.z != this.z) {
            return false;
        }
        if (!this.sameWorld(other)) {
            return false;
        }
        return this.sameDim(other);
    }

    public boolean sameWorld(MyBlockPos other) {
        if (other.world.equals("")) {
            other.world = this.world;
        } else if (this.world.equals("")) {
            this.world = other.world;
        } else if (!this.world.equals(other.world)) {
            return false;
        }
        return true;
    }

    public boolean sameDim(MyBlockPos other) {
        if (other.dim == Integer.MIN_VALUE || this.dim == Integer.MIN_VALUE) {
            other.dim = this.dim = Math.max(other.dim, this.dim);
        } else if (other.dim != this.dim) {
            return false;
        }
        return true;
    }

    public MyBlockPos update(MyBlockPos newPos) {
        this.x = newPos.x;
        this.y = newPos.y;
        this.z = newPos.z;
        if (newPos.dim != Integer.MIN_VALUE) {
            this.dim = newPos.dim;
        } else {
            newPos.dim = this.dim;
        }
        if (!newPos.world.equals("")) {
            this.world = newPos.world;
        } else {
            newPos.world = this.world;
        }
        return this;
    }

    public double distance(MyBlockPos other) {
        int dx = this.x - other.x;
        int dy = this.y - other.y;
        int dz = this.z - other.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double toLength(Vec3i vec) {
        return Math.sqrt(vec.func_177958_n() * vec.func_177958_n() + vec.func_177956_o() * vec.func_177956_o() + vec.func_177952_p() * vec.func_177952_p());
    }

    public static Vec3i normalize(Vec3i vec) {
        double length = MyBlockPos.toLength(vec);
        return new Vec3i((double)vec.func_177958_n() / length, (double)vec.func_177956_o() / length, (double)vec.func_177952_p() / length);
    }

    public static double normalizedY(Vec3i vec) {
        return (double)vec.func_177956_o() / MyBlockPos.toLength(vec);
    }

    public static double toLength(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double normalizedY(double x, double y, double z) {
        return y / MyBlockPos.toLength(x, y, z);
    }

    public String toString() {
        return this.world + ": " + this.x + "|" + this.y + "|" + this.z + " in " + this.dim;
    }

    public static enum Connection {
        VALID,
        WORLD,
        DIST;

    }
}

