/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.util;

import gollorum.signpost.util.MyBlockPos;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BaseInfo {
    public String name;
    public MyBlockPos pos;
    public UUID owner;

    public BaseInfo(String name, MyBlockPos pos, UUID owner) {
        this.name = name;
        this.pos = pos;
        this.owner = owner;
    }

    public void writeToNBT(NBTTagCompound tC) {
        tC.func_74778_a("name", this.name);
        this.pos.writeToNBT(tC);
        tC.func_74778_a("UUID", this.owner.toString());
    }

    public static BaseInfo readFromNBT(NBTTagCompound tC) {
        String name = tC.func_74779_i("name");
        MyBlockPos pos = MyBlockPos.readFromNBT(tC);
        UUID owner = UUID.fromString(tC.func_74779_i("UUID"));
        return new BaseInfo(name, pos, owner);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        this.pos.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.owner.toString());
    }

    public static BaseInfo fromBytes(ByteBuf buf) {
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        MyBlockPos pos = MyBlockPos.fromBytes(buf);
        UUID owner = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        return new BaseInfo(name, pos, owner);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BaseInfo)) {
            return super.equals(other);
        }
        return ((BaseInfo)other).pos.equals(this.pos);
    }

    public void setAll(BaseInfo newWS) {
        this.name = newWS.name;
        this.pos.update(newWS.pos);
        this.owner = newWS.owner;
    }

    public boolean update(BaseInfo newWS) {
        if (this.equals(newWS)) {
            this.setAll(newWS);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

