/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.management;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.TeleportRequestMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.StonedHashSet;
import gollorum.signpost.util.StringSet;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.util.collections.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PostHandler {
    public static StonedHashSet allWaystones = new StonedHashSet();
    public static Lurchpaerchensauna<MyBlockPos, DoubleBaseInfo> posts = new Lurchpaerchensauna();
    public static Lurchpaerchensauna<MyBlockPos, BigBaseInfo> bigPosts = new Lurchpaerchensauna();
    public static Lurchpaerchensauna<UUID, TeleportInformation> awaiting = new Lurchpaerchensauna();
    public static Lurchpaerchensauna<UUID, Pair<StringSet, Pair<Integer, Integer>>> playerKnownWaystones = new Lurchpaerchensauna<UUID, Pair<StringSet, Pair<Integer, Integer>>>(){

        @Override
        public Pair<StringSet, Pair<Integer, Integer>> get(Object obj) {
            Pair pair = (Pair)super.get(obj);
            if (pair == null) {
                Pair p = new Pair();
                p.a = new StringSet();
                p.b = new Pair();
                ((Pair)p.b).a = ConfigHandler.maxWaystones;
                ((Pair)p.b).b = ConfigHandler.maxSignposts;
                return this.put((UUID)obj, p);
            }
            return pair;
        }
    };

    public static void init() {
        allWaystones = new StonedHashSet();
        playerKnownWaystones = new Lurchpaerchensauna<UUID, Pair<StringSet, Pair<Integer, Integer>>>(){

            @Override
            public Pair<StringSet, Pair<Integer, Integer>> get(Object obj) {
                Pair pair = (Pair)super.get(obj);
                if (pair == null) {
                    Pair p = new Pair();
                    p.a = new StringSet();
                    p.b = new Pair();
                    ((Pair)p.b).a = ConfigHandler.maxWaystones;
                    ((Pair)p.b).b = ConfigHandler.maxSignposts;
                    return this.put((UUID)obj, p);
                }
                return pair;
            }
        };
        posts = new Lurchpaerchensauna();
        bigPosts = new Lurchpaerchensauna();
    }

    public static BaseInfo getWSbyName(String name) {
        if (ConfigHandler.deactivateTeleportation) {
            return new BaseInfo(name, null, null);
        }
        for (BaseInfo now : allWaystones) {
            if (!name.equals(now.name)) continue;
            return now;
        }
        return null;
    }

    public static BaseInfo getForceWSbyName(String name) {
        if (name == null || name.equals("null")) {
            return null;
        }
        for (BaseInfo now : allWaystones) {
            if (!name.equals(now.name)) continue;
            return now;
        }
        return new BaseInfo(name, null, null);
    }

    public static boolean pay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (PostHandler.canPay(player, x1, y1, z1, x2, y2, z2)) {
            PostHandler.doPay(player, x1, y1, z1, x2, y2, z2);
            return true;
        }
        return false;
    }

    public static boolean canPay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ConfigHandler.cost == null) {
            return true;
        }
        int playerItemCount = 0;
        for (ItemStack now : player.field_71071_by.field_70462_a) {
            if (now == null || now.func_77973_b() == null || now.func_77973_b().getClass() != ConfigHandler.cost.getClass()) continue;
            playerItemCount += now.field_77994_a;
        }
        return playerItemCount >= PostHandler.getStackSize(x1, y1, z1, x2, y2, z2);
    }

    public static void doPay(EntityPlayer player, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ConfigHandler.cost == null) {
            return;
        }
        int stackSize = PostHandler.getStackSize(x1, y1, z1, x2, y2, z2);
        player.field_71071_by.func_174925_a(ConfigHandler.cost, 0, stackSize, null);
    }

    public static int getStackSize(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (ConfigHandler.costMult == 0) {
            return 1;
        }
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return (int)Math.sqrt(dx * dx + dy * dy + dz * dz) / ConfigHandler.costMult + 1;
    }

    public static int getStackSize(MyBlockPos pos1, MyBlockPos pos2) {
        return PostHandler.getStackSize(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static void confirm(EntityPlayerMP player) {
        TeleportInformation info = awaiting.get(player.func_110124_au());
        if (info == null) {
            NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.noConfirm"), player);
            return;
        }
        SPEventHandler.cancelTask(PostHandler.awaiting.remove((Object)player.func_110124_au()).boolRun);
        if (!player.field_70170_p.equals(info.world)) {
            player.func_70029_a(info.world);
        }
        if (player.field_71093_bK != info.destination.pos.dim) {
            player.func_184204_a(info.destination.pos.dim);
        }
        player.func_70634_a((double)info.destination.pos.x + 0.5, (double)(info.destination.pos.y + 1), (double)info.destination.pos.z + 0.5);
    }

    public static void teleportMe(BaseInfo destination, final EntityPlayerMP player, int stackSize) {
        if (ConfigHandler.deactivateTeleportation) {
            return;
        }
        if (PostHandler.canTeleport(player, destination)) {
            World world = PostHandler.getWorldByName(destination.pos.world);
            if (world == null) {
                NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.errorWorld", "<world>", destination.pos.world), player);
            } else {
                SPEventHandler.scheduleTask(PostHandler.awaiting.put((UUID)player.func_110124_au(), (TeleportInformation)new TeleportInformation((BaseInfo)destination, (int)stackSize, (World)world, (BoolRun)new BoolRun(){
                    private short ticksLeft = (short)2400;

                    @Override
                    public boolean run() {
                        short s = this.ticksLeft;
                        this.ticksLeft = (short)(s - 1);
                        if (s <= 0) {
                            awaiting.remove(player.func_110124_au());
                            return true;
                        }
                        return false;
                    }
                })).boolRun);
                NetworkHandler.netWrap.sendTo((IMessage)new TeleportRequestMessage(stackSize, destination.name), player);
            }
        } else {
            NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.notDiscovered", "<Waystone>", destination.name), player);
        }
    }

    public static StonedHashSet getByWorld(String world) {
        StonedHashSet ret = new StonedHashSet();
        for (BaseInfo now : allWaystones) {
            if (!now.pos.world.equals(world)) continue;
            ret.add(now);
        }
        return ret;
    }

    public static boolean updateWS(BaseInfo newWS, boolean destroyed) {
        if (destroyed) {
            if (allWaystones.remove(PostHandler.getWSbyName(newWS.name))) {
                for (Map.Entry<UUID, Pair<StringSet, Pair<Integer, Integer>>> now : playerKnownWaystones.entrySet()) {
                    ((StringSet)now.getValue().a).remove(newWS);
                }
                return true;
            }
            return false;
        }
        for (BaseInfo now : allWaystones) {
            if (!now.update(newWS)) continue;
            return true;
        }
        return allWaystones.add(newWS);
    }

    public static boolean addAllDiscoveredByName(UUID player, StringSet ws) {
        if (playerKnownWaystones.containsKey(player)) {
            return ((StringSet)PostHandler.playerKnownWaystones.get((Object)player).a).addAll(ws);
        }
        StringSet newSet = new StringSet();
        boolean ret = newSet.addAll(ws);
        Pair pair = new Pair();
        pair.a = newSet;
        pair.b = new Pair();
        ((Pair)pair.b).a = ConfigHandler.maxWaystones;
        ((Pair)pair.b).b = ConfigHandler.maxSignposts;
        playerKnownWaystones.put(player, pair);
        return ret;
    }

    public static boolean addDiscovered(UUID player, BaseInfo ws) {
        if (ws == null) {
            return false;
        }
        if (playerKnownWaystones.containsKey(player)) {
            return ((StringSet)PostHandler.playerKnownWaystones.get((Object)player).a).add(ws + "");
        }
        StringSet newSet = new StringSet();
        newSet.add("" + ws);
        Pair pair = new Pair();
        pair.a = newSet;
        pair.b = new Pair();
        ((Pair)pair.b).a = ConfigHandler.maxWaystones;
        ((Pair)pair.b).b = ConfigHandler.maxSignposts;
        playerKnownWaystones.put(player, pair);
        return true;
    }

    public static boolean canTeleport(EntityPlayerMP player, BaseInfo target) {
        StringSet playerKnows = (StringSet)PostHandler.playerKnownWaystones.get((Object)player.func_110124_au()).a;
        if (playerKnows == null) {
            return false;
        }
        return playerKnows.contains(target.name);
    }

    public static World getWorldByName(String world) {
        for (WorldServer now : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (!now.func_72912_H().func_76065_j().equals(world)) continue;
            return now;
        }
        return null;
    }

    public static boolean addRep(BaseInfo ws) {
        BaseInfo toDelete = allWaystones.getByPos(ws.pos);
        allWaystones.removeByPos(toDelete.pos);
        allWaystones.add(ws);
        return true;
    }

    public static EntityPlayer getPlayerByName(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public static boolean isHandEmpty(EntityPlayer player) {
        return player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150350_a));
    }

    public static class TeleportInformation {
        public BaseInfo destination;
        public int stackSize;
        public World world;
        public BoolRun boolRun;

        public TeleportInformation(BaseInfo destination, int stackSize, World world, BoolRun boolRun) {
            this.destination = destination;
            this.stackSize = stackSize;
            this.world = world;
            this.boolRun = boolRun;
        }
    }
}

