/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.gui;

import gollorum.signpost.blocks.PostPostTile;
import gollorum.signpost.gui.SignInputBox;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendPostBasesMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class SignGuiPost
extends GuiScreen {
    private SignInputBox base1InputBox;
    private SignInputBox base2InputBox;
    private String std1 = "";
    private int col1 = Color.black.getRGB();
    private boolean go1;
    private String std2 = "";
    private int col2 = Color.black.getRGB();
    private boolean go2;
    private PostPostTile tile;
    private boolean resetMouse;

    public SignGuiPost(PostPostTile tile) {
        this.tile = tile;
    }

    public void func_73866_w_() {
        DoubleBaseInfo tilebases = this.tile.getBases();
        this.base1InputBox = new SignInputBox(this.field_146289_q, this.field_146294_l / 2 - 68, this.field_146295_m / 2 - 46, 137);
        this.base1InputBox.setText(tilebases.sign1.base == null ? "" : tilebases.sign1.base.toString());
        this.go1 = true;
        this.base1InputBox.setFocused(true);
        this.base2InputBox = new SignInputBox(this.field_146289_q, this.field_146294_l / 2 - 68, this.field_146295_m / 2 + 40, 137);
        this.base2InputBox.setText(tilebases.sign2.base == null ? "" : tilebases.sign2.base.toString());
        this.go2 = true;
        this.resetMouse = true;
    }

    protected void func_73864_a(int x, int y, int bla) throws IOException {
        super.func_73864_a(x, y, bla);
        this.base1InputBox.mouseClicked(x, y, bla);
        this.base2InputBox.mouseClicked(x, y, bla);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.field_146297_k == null) {
            this.field_146297_k = FMLClientHandler.instance().getClient();
        }
        this.func_146276_q_();
        this.base1InputBox.drawSignBox(this.field_146289_q);
        this.func_73732_a(this.field_146289_q, this.std2, this.field_146294_l / 2, this.base1InputBox.y + this.base1InputBox.height + 10, this.col2);
        this.base2InputBox.drawSignBox(this.field_146289_q);
        this.func_73732_a(this.field_146289_q, this.std1, this.field_146294_l / 2, this.base2InputBox.y + this.base2InputBox.height + 10, this.col1);
        if (this.resetMouse) {
            this.resetMouse = false;
            Mouse.setGrabbed((boolean)false);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (par1 == '\r') {
            if (this.base1InputBox.isFocused()) {
                if (!this.go2) {
                    this.go2 = true;
                    this.base1InputBox.textColor = Color.orange.getRGB();
                }
                this.base1InputBox.setFocused(false);
                this.base2InputBox.setFocused(true);
            } else if (this.base2InputBox.isFocused()) {
                if (!this.go1) {
                    this.go1 = true;
                    this.base2InputBox.textColor = Color.orange.getRGB();
                }
                this.field_146297_k.func_147108_a(null);
            } else {
                this.base1InputBox.setFocused(true);
            }
            return;
        }
        if (par1 == '\t') {
            if (this.base1InputBox.isFocused()) {
                this.base1InputBox.setFocused(false);
                this.base2InputBox.setFocused(true);
            } else if (this.base2InputBox.isFocused()) {
                this.base2InputBox.setFocused(false);
                this.base1InputBox.setFocused(true);
            } else {
                this.base1InputBox.setFocused(true);
            }
            return;
        }
        this.baseType(par1, par2, false);
        this.baseType(par1, par2, true);
    }

    private void baseType(char par1, int par2, boolean base2) {
        SignInputBox tf = base2 ? this.base2InputBox : this.base1InputBox;
        String before = tf.getText();
        if (tf.textboxKeyTyped(par1, par2) && !tf.getText().equals(before)) {
            if (ConfigHandler.deactivateTeleportation) {
                return;
            }
            BaseInfo inf = PostHandler.getWSbyName(tf.getText());
            MyBlockPos.Connection connect = this.tile.toPos().canConnectTo(inf);
            if (inf == null || !connect.equals((Object)MyBlockPos.Connection.VALID)) {
                tf.textColor = Color.red.getRGB();
                if (connect.equals((Object)MyBlockPos.Connection.DIST)) {
                    String out = I18n.func_74838_a((String)"signpost.guiTooFar");
                    out = out.replaceAll("<distance>", "" + (int)this.tile.toPos().distance(inf.pos) + 1);
                    out = out.replaceAll("<maxDist>", "" + ConfigHandler.maxDist);
                    if (base2) {
                        this.std1 = out;
                        this.col1 = Color.red.getRGB();
                        this.go1 = false;
                    } else {
                        this.std2 = out;
                        this.col2 = Color.red.getRGB();
                        this.go2 = false;
                    }
                } else if (connect.equals((Object)MyBlockPos.Connection.WORLD)) {
                    String out = I18n.func_74838_a((String)"signpost.guiWorldDim");
                    if (base2) {
                        this.std1 = out;
                        this.col1 = Color.red.getRGB();
                        this.go1 = false;
                    } else {
                        this.std2 = out;
                        this.col2 = Color.red.getRGB();
                        this.go2 = false;
                    }
                } else if (base2) {
                    this.std1 = "";
                    this.col1 = Color.red.getRGB();
                    this.go1 = false;
                } else {
                    this.std2 = "";
                    this.col2 = Color.red.getRGB();
                    this.go2 = false;
                }
            } else {
                tf.textColor = Color.black.getRGB();
                if (base2) {
                    this.col1 = Color.white.getRGB();
                    this.go1 = true;
                } else {
                    this.col2 = Color.white.getRGB();
                    this.go2 = true;
                }
                if (!ConfigHandler.deactivateTeleportation && ConfigHandler.cost != null) {
                    String out = I18n.func_74838_a((String)"signpost.guiPrev");
                    int distance = (int)this.tile.toPos().distance(inf.pos) + 1;
                    out = out.replaceAll("<distance>", "" + distance);
                    out = out.replaceAll("<amount>", Integer.toString(PostHandler.getStackSize(this.tile.toPos(), inf.pos)));
                    out = out.replaceAll("<itemName>", ConfigHandler.costName());
                    if (base2) {
                        this.col1 = Color.white.getRGB();
                        this.std1 = out;
                    } else {
                        this.col2 = Color.white.getRGB();
                        this.std2 = out;
                    }
                }
            }
        }
    }

    public void func_146281_b() {
        DoubleBaseInfo tilebases = this.tile.getBases();
        tilebases.sign1.base = ConfigHandler.deactivateTeleportation || this.go2 ? PostHandler.getForceWSbyName(this.base1InputBox.getText()) : null;
        tilebases.sign2.base = ConfigHandler.deactivateTeleportation || this.go1 ? PostHandler.getForceWSbyName(this.base2InputBox.getText()) : null;
        NetworkHandler.netWrap.sendToServer((IMessage)new SendPostBasesMessage(this.tile, tilebases));
    }
}

