/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.PostPost;
import gollorum.signpost.blocks.SuperPostPostTile;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendAllPostBasesMessage;
import gollorum.signpost.network.messages.SendPostBasesMessage;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.DoubleBaseInfo;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Sign;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PostPostTile
extends SuperPostPostTile {
    public PostPost.PostType type = PostPost.PostType.OAK;
    @Deprecated
    public DoubleBaseInfo bases = null;

    public PostPostTile() {
    }

    public PostPostTile(PostPost.PostType type) {
        this();
        this.type = type;
    }

    public DoubleBaseInfo getBases() {
        DoubleBaseInfo bases = PostHandler.posts.get(this.toPos());
        if (bases == null) {
            bases = new DoubleBaseInfo(this.type.texture);
            PostHandler.posts.put(this.toPos(), bases);
        }
        this.bases = bases;
        return bases;
    }

    @Override
    public void onBlockDestroy(MyBlockPos pos) {
        EntityItem item;
        this.isCanceled = true;
        DoubleBaseInfo bases = this.getBases();
        if (bases.sign1.overlay != null) {
            item = new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign1.overlay.item, 1));
            this.field_145850_b.func_72838_d((Entity)item);
        }
        if (bases.sign2.overlay != null) {
            item = new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign2.overlay.item, 1));
            this.field_145850_b.func_72838_d((Entity)item);
        }
        if (PostHandler.posts.remove(pos) != null) {
            NetworkHandler.netWrap.sendToAll((IMessage)new SendAllPostBasesMessage());
        }
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
        DoubleBaseInfo bases = this.getBases();
        tagCompound.func_74778_a("base1", "" + bases.sign1.base);
        tagCompound.func_74778_a("base2", "" + bases.sign2.base);
        tagCompound.func_74768_a("rot1", bases.sign1.rotation);
        tagCompound.func_74768_a("rot2", bases.sign2.rotation);
        tagCompound.func_74757_a("flip1", bases.sign1.flip);
        tagCompound.func_74757_a("flip2", bases.sign2.flip);
        tagCompound.func_74778_a("overlay1", "" + (Object)((Object)bases.sign1.overlay));
        tagCompound.func_74778_a("overlay2", "" + (Object)((Object)bases.sign2.overlay));
        tagCompound.func_74757_a("point1", bases.sign1.point);
        tagCompound.func_74757_a("point2", bases.sign2.point);
        tagCompound.func_74778_a("paint1", SuperPostPostTile.LocToString(bases.sign1.paint));
        tagCompound.func_74778_a("paint2", SuperPostPostTile.LocToString(bases.sign2.paint));
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
        final String base1 = tagCompound.func_74779_i("base1");
        final String base2 = tagCompound.func_74779_i("base2");
        final int rotation1 = tagCompound.func_74762_e("rot1");
        final int rotation2 = tagCompound.func_74762_e("rot2");
        final boolean flip1 = tagCompound.func_74767_n("flip1");
        final boolean flip2 = tagCompound.func_74767_n("flip2");
        final Sign.OverlayType overlay1 = Sign.OverlayType.get(tagCompound.func_74779_i("overlay1"));
        final Sign.OverlayType overlay2 = Sign.OverlayType.get(tagCompound.func_74779_i("overlay2"));
        final boolean point1 = tagCompound.func_74767_n("point1");
        final boolean point2 = tagCompound.func_74767_n("point2");
        final String paint1 = tagCompound.func_74779_i("paint1");
        final String paint2 = tagCompound.func_74779_i("paint2");
        final PostPostTile self = this;
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (PostPostTile.this.field_145850_b == null) {
                    return false;
                }
                if (((PostPostTile)PostPostTile.this).field_145850_b.field_72995_K) {
                    return true;
                }
                DoubleBaseInfo bases = PostPostTile.this.getBases();
                bases.sign1.base = PostHandler.getForceWSbyName(base1);
                bases.sign2.base = PostHandler.getForceWSbyName(base2);
                bases.sign1.rotation = rotation1;
                bases.sign2.rotation = rotation2;
                bases.sign1.flip = flip1;
                bases.sign2.flip = flip2;
                bases.sign1.overlay = overlay1;
                bases.sign2.overlay = overlay2;
                bases.sign1.point = point1;
                bases.sign2.point = point2;
                bases.sign1.paint = SuperPostPostTile.stringToLoc(paint1);
                bases.sign2.paint = SuperPostPostTile.stringToLoc(paint2);
                NetworkHandler.netWrap.sendToAll((IMessage)new SendPostBasesMessage(self, bases));
                return true;
            }
        });
    }

    @Override
    public Sign getSign(EntityPlayer player) {
        DoubleBaseInfo bases = this.getBases();
        PostPost.Hit hit = (PostPost.Hit)((PostPost)this.field_145854_h).getHitTarget(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)PostPost.HitTarget.BASE1)) {
            return bases.sign1;
        }
        if (hit.target.equals((Object)PostPost.HitTarget.BASE2)) {
            return bases.sign2;
        }
        return null;
    }
}

