/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.SPEventHandler;
import gollorum.signpost.blocks.BigPostPost;
import gollorum.signpost.blocks.SuperPostPostTile;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.SendAllBigPostBasesMessage;
import gollorum.signpost.network.messages.SendBigPostBasesMessage;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.Sign;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BigPostPostTile
extends SuperPostPostTile {
    public BigPostPost.BigPostType type = BigPostPost.BigPostType.OAK;
    public static final int DESCRIPTIONLENGTH = 4;
    @Deprecated
    public BigBaseInfo bases = null;

    public BigPostPostTile() {
    }

    public BigPostPostTile(BigPostPost.BigPostType type) {
        this();
        this.type = type;
    }

    public BigBaseInfo getBases() {
        BigBaseInfo bases = PostHandler.bigPosts.get(this.toPos());
        if (bases == null) {
            bases = new BigBaseInfo(this.type.texture);
            PostHandler.bigPosts.put(this.toPos(), bases);
        }
        this.bases = bases;
        return bases;
    }

    @Override
    public void onBlockDestroy(MyBlockPos pos) {
        this.isCanceled = true;
        BigBaseInfo bases = this.getBases();
        if (bases.sign.overlay != null) {
            EntityItem item = new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(bases.sign.overlay.item, 1));
            this.field_145850_b.func_72838_d((Entity)item);
        }
        if (PostHandler.bigPosts.remove(pos) != null) {
            NetworkHandler.netWrap.sendToAll((IMessage)new SendAllBigPostBasesMessage());
        }
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
        BigBaseInfo bases = this.getBases();
        tagCompound.func_74778_a("base", "" + bases.sign.base);
        tagCompound.func_74768_a("rot", bases.sign.rotation);
        tagCompound.func_74757_a("flip", bases.sign.flip);
        tagCompound.func_74778_a("overlay", "" + (Object)((Object)bases.sign.overlay));
        tagCompound.func_74757_a("point", bases.sign.point);
        tagCompound.func_74778_a("paint", SuperPostPostTile.LocToString(bases.sign.paint));
        for (int i = 0; i < bases.description.length; ++i) {
            tagCompound.func_74778_a("description" + i, bases.description[i]);
        }
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
        final String base = tagCompound.func_74779_i("base");
        final int rotation = tagCompound.func_74762_e("rot");
        final boolean flip = tagCompound.func_74767_n("flip");
        final Sign.OverlayType overlay = Sign.OverlayType.get(tagCompound.func_74779_i("overlay"));
        final boolean point = tagCompound.func_74767_n("point");
        final String[] description = new String[4];
        final String paint = tagCompound.func_74779_i("paint");
        final BigPostPostTile self = this;
        for (int i = 0; i < 4; ++i) {
            description[i] = tagCompound.func_74779_i("description" + i);
        }
        SPEventHandler.scheduleTask(new BoolRun(){

            @Override
            public boolean run() {
                if (BigPostPostTile.this.field_145850_b == null) {
                    return false;
                }
                if (((BigPostPostTile)BigPostPostTile.this).field_145850_b.field_72995_K) {
                    return true;
                }
                BigBaseInfo bases = BigPostPostTile.this.getBases();
                bases.sign.base = PostHandler.getForceWSbyName(base);
                bases.sign.rotation = rotation;
                bases.sign.flip = flip;
                bases.sign.overlay = overlay;
                bases.sign.point = point;
                bases.description = description;
                bases.sign.paint = SuperPostPostTile.stringToLoc(paint);
                NetworkHandler.netWrap.sendToAll((IMessage)new SendBigPostBasesMessage(self, bases));
                return true;
            }
        });
    }

    @Override
    public Sign getSign(EntityPlayer player) {
        BigBaseInfo bases = this.getBases();
        BigPostPost.BigHit hit = (BigPostPost.BigHit)((BigPostPost)this.field_145854_h).getHitTarget(this.field_145850_b, this.func_174877_v().func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), player);
        if (hit.target.equals((Object)BigPostPost.BigHitTarget.BASE)) {
            return bases.sign;
        }
        return null;
    }
}

