/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.blocks.BigPostPostTile;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.SuperPostPostTile;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.network.messages.SendBigPostBasesMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.BigBaseInfo;
import gollorum.signpost.util.Sign;
import gollorum.signpost.util.math.tracking.Cuboid;
import gollorum.signpost.util.math.tracking.DDDVector;
import gollorum.signpost.util.math.tracking.Intersect;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BigPostPost
extends SuperPostPost {
    public BigPostType type;

    @Deprecated
    public BigPostPost() {
        super(Material.field_151575_d);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149713_g(0);
        this.func_149663_c("SignpostBigPostOAK");
        this.setRegistryName("signpost:blockbigpostoak");
    }

    public BigPostPost(BigPostType type) {
        super(type.material);
        this.type = type;
        this.func_149647_a(CreativeTabs.field_78029_e);
        switch (type) {
            case STONE: {
                this.setHarvestLevel("pickaxe", 0);
                break;
            }
            case IRON: {
                this.setHarvestLevel("pickaxe", 1);
                break;
            }
            default: {
                this.setHarvestLevel("axe", 0);
            }
        }
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149713_g(0);
        this.func_149663_c("SignpostBigPost" + type.name());
        this.setRegistryName("signpost:blockbigpost" + type.name().toLowerCase());
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        BigPostPostTile tile = new BigPostPostTile(this.type);
        return tile;
    }

    public static BigPostPostTile getWaystonePostTile(World world, int x, int y, int z) {
        TileEntity ret = world.func_175625_s(new BlockPos(x, y, z));
        if (ret instanceof BigPostPostTile) {
            return (BigPostPostTile)ret;
        }
        return null;
    }

    @Override
    public void clickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.rotation = (tilebases.sign.rotation - 15) % 360;
        }
    }

    @Override
    public void rightClickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.rotation = (tilebases.sign.rotation + 15) % 360;
        }
    }

    @Override
    public void shiftClickWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.flip = !tilebases.sign.flip;
        }
    }

    @Override
    public void rightClickBrush(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(3, x, y, z), (EntityPlayerMP)player);
    }

    @Override
    public void clickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Sign sign;
        if (((BigHit)hitObj).target.equals((Object)BigHitTarget.BASE) && (sign = ((BigPostPostTile)superTile).getBases().sign) != null) {
            sign.rotation = (sign.flip ? 90 : 270) - (int)player.field_70759_as;
        }
    }

    @Override
    public void rightClickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        if (hit.target.equals((Object)BigHitTarget.BASE)) {
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(4, x, y, z), (EntityPlayerMP)player);
        }
    }

    @Override
    public void shiftClickCalibratedWrench(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        Sign sign;
        if (((BigHit)hitObj).target.equals((Object)BigHitTarget.BASE) && (sign = ((BigPostPostTile)superTile).getBases().sign) != null) {
            sign.rotation = (sign.flip ? 270 : 90) - (int)player.field_70759_as;
        }
    }

    @Override
    public void click(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE && tilebases.sign.overlay != null) {
            player.field_71071_by.func_70441_a(new ItemStack(tilebases.sign.overlay.item, 1));
        }
        for (Sign.OverlayType now : Sign.OverlayType.values()) {
            if (player.func_184614_ca().func_77973_b().getClass() != now.item.getClass()) continue;
            if (hit.target == BigHitTarget.BASE) {
                tilebases.sign.overlay = now;
            }
            player.field_71071_by.func_174925_a(now.item, 0, 1, null);
            return;
        }
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.overlay = null;
        }
    }

    @Override
    public void rightClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        if (hit.target != BigHitTarget.POST) {
            if (ConfigHandler.deactivateTeleportation) {
                return;
            }
            BigPostPostTile tile = (BigPostPostTile)superTile;
            BaseInfo destination = tile.getBases().sign.base;
            if (destination != null) {
                if (destination.pos == null) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.noTeleport"), (EntityPlayerMP)player);
                } else if (ConfigHandler.cost == null) {
                    PostHandler.teleportMe(destination, (EntityPlayerMP)player, 0);
                } else {
                    int stackSize = (int)destination.pos.distance(tile.toPos()) / ConfigHandler.costMult + 1;
                    if (!PostHandler.isHandEmpty(player) && player.func_184614_ca().func_77973_b().getClass() == ConfigHandler.cost.getClass() && player.func_184614_ca().field_77994_a >= stackSize) {
                        PostHandler.teleportMe(destination, (EntityPlayerMP)player, stackSize);
                    } else {
                        String[] keyword = new String[]{"<itemName>", "<amount>"};
                        String[] replacement = new String[]{ConfigHandler.cost.func_77658_a() + ".name", "" + stackSize};
                        NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.payment", keyword, replacement), (EntityPlayerMP)player);
                    }
                }
            }
        } else {
            NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(2, x, y, z), (EntityPlayerMP)player);
        }
    }

    @Override
    public void shiftClick(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.point = !tilebases.sign.point;
        }
    }

    @Override
    public void clickBare(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        BigBaseInfo tilebases = ((BigPostPostTile)superTile).getBases();
        if (hit.target == BigHitTarget.BASE) {
            tilebases.sign.point = !tilebases.sign.point;
        }
    }

    @Override
    public void shiftClickBare(Object hitObj, SuperPostPostTile superTile, EntityPlayer player, int x, int y, int z) {
        BigHit hit = (BigHit)hitObj;
        this.shiftClick(hitObj, superTile, player, x, y, z);
    }

    @Override
    public void sendPostBasesToAll(SuperPostPostTile superTile) {
        BigPostPostTile tile = (BigPostPostTile)superTile;
        BigBaseInfo tilebases = tile.getBases();
        NetworkHandler.netWrap.sendToAll((IMessage)new SendBigPostBasesMessage(tile, tilebases));
    }

    @Override
    public void sendPostBasesToServer(SuperPostPostTile superTile) {
        BigPostPostTile tile = (BigPostPostTile)superTile;
        BigBaseInfo tilebases = tile.getBases();
        NetworkHandler.netWrap.sendToServer((IMessage)new SendBigPostBasesMessage(tile, tilebases));
    }

    @Override
    public Object getHitTarget(World world, int x, int y, int z, EntityPlayer player) {
        DDDVector head = new DDDVector(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        head.y += (double)player.func_70047_e();
        if (player.func_70093_af()) {
            head.y -= 0.08;
        }
        Vec3d look = player.func_70040_Z();
        BigBaseInfo bases = BigPostPost.getWaystonePostTile(world, x, y, z).getBases();
        DDDVector rotPos = new DDDVector((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        DDDVector edges = new DDDVector(1.4375, 0.75, 0.0625);
        DDDVector signPos = bases.sign.flip ? new DDDVector((double)x - 0.375, (double)y + 0.1875, (double)z + 0.625) : new DDDVector((double)x - 0.0625, (double)y + 0.1875, (double)z + 0.625);
        Cuboid sign = new Cuboid(signPos, edges, bases.sign.calcRot(x, z), rotPos);
        Cuboid post = new Cuboid(new DDDVector((double)x + 0.375, y, (double)z + 0.375), new DDDVector(0.25, 1.0, 0.25), 0.0);
        DDDVector start = new DDDVector(head.x, head.y, head.z);
        DDDVector end = start.add(new DDDVector(look.field_72450_a, look.field_72448_b, look.field_72449_c));
        Intersect signHit = sign.traceLine(start, end, true);
        Intersect postHit = post.traceLine(start, end, true);
        double signDist = signHit.exists && bases.sign.base != null ? signHit.pos.distance(start) : Double.MAX_VALUE;
        double postDist = postHit.exists ? postHit.pos.distance(start) : 8.988465674311579E307;
        double dist = signDist;
        DDDVector pos = signHit.pos;
        BigHitTarget target = BigHitTarget.BASE;
        if (postDist < dist) {
            dist = postDist;
            pos = postHit.pos;
            target = BigHitTarget.POST;
        }
        return new BigHit(target, pos);
    }

    public static BigPostPostTile getTile(World world, BlockPos pos) {
        TileEntity ret = world.func_175625_s(pos);
        if (ret instanceof BigPostPostTile) {
            return (BigPostPostTile)ret;
        }
        return null;
    }

    public static class BigHit {
        public BigHitTarget target;
        public DDDVector pos;

        public BigHit(BigHitTarget target, DDDVector pos) {
            this.target = target;
            this.pos = pos;
        }
    }

    public static enum BigHitTarget {
        BASE,
        POST;

    }

    public static enum BigPostType {
        OAK(Material.field_151575_d, "bigsign_oak", "planks_oak", Item.func_150898_a((Block)Blocks.field_150344_f), 0),
        SPRUCE(Material.field_151575_d, "bigsign_spruce", "planks_spruce", Item.func_150898_a((Block)Blocks.field_150344_f), 1),
        BIRCH(Material.field_151575_d, "bigsign_birch", "planks_birch", Item.func_150898_a((Block)Blocks.field_150344_f), 2),
        JUNGLE(Material.field_151575_d, "bigsign_jungle", "planks_jungle", Item.func_150898_a((Block)Blocks.field_150344_f), 3),
        ACACIA(Material.field_151575_d, "bigsign_acacia", "planks_acacia", Item.func_150898_a((Block)Blocks.field_150344_f), 4),
        BIGOAK(Material.field_151575_d, "bigsign_big_oak", "planks_big_oak", Item.func_150898_a((Block)Blocks.field_150344_f), 5),
        IRON(Material.field_151573_f, "bigsign_iron", "iron_block", Items.field_151042_j, 0),
        STONE(Material.field_151576_e, "bigsign_stone", "stone", Item.func_150898_a((Block)Blocks.field_150348_b), 0);

        public Material material;
        public ResourceLocation texture;
        public String textureMain;
        public ResourceLocation resLocMain;
        public Item baseItem;
        public int metadata;

        private BigPostType(Material material, String texture, String textureMain, Item baseItem, int metadata) {
            this.material = material;
            this.texture = new ResourceLocation("signpost:textures/blocks/" + texture + ".png");
            this.textureMain = textureMain;
            this.resLocMain = new ResourceLocation("minecraft:textures/blocks/" + textureMain + ".png");
            this.baseItem = baseItem;
            this.metadata = metadata;
        }
    }
}

