/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blocks;

import gollorum.signpost.blocks.BasePostTile;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.BaseUpdateClientMessage;
import gollorum.signpost.network.messages.ChatMessage;
import gollorum.signpost.network.messages.OpenGuiMessage;
import gollorum.signpost.util.BaseInfo;
import gollorum.signpost.util.MyBlockPos;
import java.util.UUID;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BasePost
extends BlockContainer {
    public BasePost() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(2.0f);
        this.func_149752_b(100000.0f);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.func_149663_c("SignpostBase");
        this.setRegistryName("signpost:blockbase");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ConfigHandler.deactivateTeleportation) {
            return false;
        }
        if (!world.field_72995_K) {
            BaseInfo ws = BasePost.getWaystoneRootTile(world, pos).getBaseInfo();
            if (!player.func_70093_af()) {
                if (!ConfigHandler.deactivateTeleportation) {
                    NetworkHandler.netWrap.sendTo((IMessage)new ChatMessage("signpost.discovered", "<Waystone>", ws.name), (EntityPlayerMP)player);
                }
                PostHandler.addDiscovered(player.func_110124_au(), ws);
            } else if (!ConfigHandler.deactivateTeleportation && ConfigHandler.securityLevelWaystone.canUse((EntityPlayerMP)player, "" + ws.owner)) {
                NetworkHandler.netWrap.sendTo((IMessage)new OpenGuiMessage(0, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BasePostTile().setup();
    }

    public static BasePostTile getWaystoneRootTile(World world, BlockPos pos) {
        TileEntity ret = world.func_175625_s(pos);
        if (ret instanceof BasePostTile) {
            return (BasePostTile)ret;
        }
        return null;
    }

    public static String generateName() {
        String ret;
        int i = 1;
        while (PostHandler.allWaystones.nameTaken(ret = "Waystone " + i++)) {
        }
        return ret;
    }

    public static void placeServer(World world, MyBlockPos pos, EntityPlayerMP player) {
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.toBlockPos());
        String name = BasePost.generateName();
        UUID owner = player.func_110124_au();
        BaseInfo ws = tile.getBaseInfo();
        if (ws == null) {
            ws = new BaseInfo(name, pos, owner);
            PostHandler.allWaystones.add(ws);
        } else {
            ws.setAll(new BaseInfo(name, pos, owner));
        }
        PostHandler.addDiscovered(player.func_110124_au(), ws);
        NetworkHandler.netWrap.sendToAll((IMessage)new BaseUpdateClientMessage());
        MinecraftForge.EVENT_BUS.post((Event)new UpdateWaystoneEvent(UpdateWaystoneEvent.WaystoneEventType.PLACED, world, pos.x, pos.y, pos.z, name));
    }

    public static void placeClient(World world, MyBlockPos pos, EntityPlayer player) {
        BasePostTile tile = BasePost.getWaystoneRootTile(world, pos.toBlockPos());
        if (tile != null && tile.getBaseInfo() == null) {
            PostHandler.allWaystones.add(new BaseInfo("", pos, player.func_110124_au()));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BasePostTile();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }
}

