/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.blocks.BasePost;
import gollorum.signpost.blocks.BasePostTile;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.blocks.SuperPostPostTile;
import gollorum.signpost.items.CalibratedPostWrench;
import gollorum.signpost.items.PostWrench;
import gollorum.signpost.management.ConfigHandler;
import gollorum.signpost.management.PlayerProvider;
import gollorum.signpost.management.PlayerStore;
import gollorum.signpost.management.PostHandler;
import gollorum.signpost.management.WorldSigns;
import gollorum.signpost.network.NetworkHandler;
import gollorum.signpost.network.messages.InitPlayerResponseMessage;
import gollorum.signpost.network.messages.SendAllBigPostBasesMessage;
import gollorum.signpost.network.messages.SendAllPostBasesMessage;
import gollorum.signpost.util.BoolRun;
import gollorum.signpost.util.MyBlockPos;
import gollorum.signpost.util.StringSet;
import gollorum.signpost.util.collections.Lurchpaerchensauna;
import gollorum.signpost.util.collections.Lurchsauna;
import gollorum.signpost.util.collections.Pair;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SPEventHandler {
    private static Lurchpaerchensauna<Runnable, Integer> tasks = new Lurchpaerchensauna();
    private static Lurchsauna<BoolRun> predicatedTasks = new Lurchsauna();
    public static final ResourceLocation PLAYER_CAP = new ResourceLocation("signpost", "playerstore");

    public static void scheduleTask(Runnable task, int delay) {
        tasks.put(task, delay);
    }

    public static void scheduleTask(BoolRun task) {
        predicatedTasks.add(task);
    }

    public static boolean cancelTask(BoolRun task) {
        return predicatedTasks.remove(task);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!(event instanceof TickEvent.ServerTickEvent) && !(event instanceof TickEvent.ClientTickEvent)) {
            return;
        }
        Lurchpaerchensauna<Runnable, Integer> remainingTasks = new Lurchpaerchensauna<Runnable, Integer>();
        for (Map.Entry<Runnable, Integer> now : tasks.entrySet()) {
            int val = now.getValue() - 1;
            if (val < 2) {
                now.getKey().run();
                continue;
            }
            remainingTasks.put(now.getKey(), val);
        }
        tasks = remainingTasks;
        Lurchsauna<BoolRun> remainingPreds = new Lurchsauna<BoolRun>();
        for (BoolRun now : predicatedTasks) {
            boolean a = false;
            if (now.run()) continue;
            remainingPreds.add(now);
        }
        predicatedTasks = remainingPreds;
    }

    @SubscribeEvent
    public void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            NetworkHandler.netWrap.sendTo((IMessage)new InitPlayerResponseMessage(), (EntityPlayerMP)event.player);
            NetworkHandler.netWrap.sendTo((IMessage)new SendAllPostBasesMessage(), (EntityPlayerMP)event.player);
            NetworkHandler.netWrap.sendTo((IMessage)new SendAllBigPostBasesMessage(), (EntityPlayerMP)event.player);
            PlayerStore store = (PlayerStore)event.player.getCapability(PlayerProvider.STORE_CAP, null);
            store.init((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            PlayerProvider provider = new PlayerProvider((EntityPlayerMP)event.getEntity());
            event.addCapability(PLAYER_CAP, (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            WorldSigns.worldSigns(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            WorldSigns.worldSigns(event.getWorld());
        }
    }

    @SubscribeEvent
    public void oBlockPlace(BlockEvent.PlaceEvent event) {
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            if (event.getState().func_177230_c() instanceof BasePost) {
                BasePost.placeClient(event.getWorld(), new MyBlockPos("", event.getPos(), event.getPlayer().field_71093_bK), event.getPlayer());
            } else if (event.getState().func_177230_c() instanceof SuperPostPost) {
                SuperPostPost.placeClient(event.getWorld(), new MyBlockPos("", event.getPos(), event.getPlayer().field_71093_bK), event.getPlayer());
            }
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (event.getState().func_177230_c() instanceof BasePost) {
            BasePostTile tile = BasePost.getWaystoneRootTile(event.getWorld(), event.getPos());
            if (!ConfigHandler.securityLevelWaystone.canPlace(player) || !this.checkWaystoneCount(player)) {
                tile.onBlockDestroy(new MyBlockPos(event.getWorld(), event.getPos(), player.field_71093_bK));
                event.setCanceled(true);
            } else {
                BasePost.placeServer(event.getWorld(), new MyBlockPos(event.getWorld().func_72912_H().func_76065_j(), event.getPos(), event.getPlayer().field_71093_bK), (EntityPlayerMP)event.getPlayer());
            }
        } else if (event.getState().func_177230_c() instanceof SuperPostPost) {
            SuperPostPostTile tile = SuperPostPost.getSuperTile(event.getWorld(), event.getPos());
            if (!ConfigHandler.securityLevelSignpost.canPlace(player) || !this.checkSignpostCount(player)) {
                tile.onBlockDestroy(new MyBlockPos(event.getWorld(), event.getPos(), player.field_71093_bK));
                event.setCanceled(true);
            } else {
                SuperPostPost.placeServer(event.getWorld(), new MyBlockPos(event.getWorld().func_72912_H().func_76065_j(), event.getPos(), event.getPlayer().field_71093_bK), (EntityPlayerMP)event.getPlayer());
            }
        }
    }

    private boolean checkWaystoneCount(EntityPlayerMP player) {
        Pair<StringSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystones.get(player.func_110124_au());
        int remaining = (Integer)((Pair)pair.b).a;
        if (remaining == 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to place more waystones"));
            return false;
        }
        if (remaining > 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.a;
            pair2.a = (Integer)pair2.a - 1;
            Integer n2 = pair2.a;
        }
        return true;
    }

    private void updateWaystoneCount(BasePostTile tile) {
        if (tile == null || tile.getBaseInfo() == null) {
            return;
        }
        UUID owner = tile.getBaseInfo().owner;
        if (owner == null) {
            return;
        }
        Pair<StringSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystones.get(owner);
        if (pair != null && (Integer)((Pair)pair.b).a >= 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.a;
            pair2.a = (Integer)pair2.a + 1;
            Integer n2 = pair2.a;
        }
    }

    private boolean checkSignpostCount(EntityPlayerMP player) {
        Pair<StringSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystones.get(player.func_110124_au());
        int remaining = (Integer)((Pair)pair.b).b;
        if (remaining == 0) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to place more signposts"));
            return false;
        }
        if (remaining > 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.b;
            pair2.b = (Integer)pair2.b - 1;
            Integer n2 = pair2.b;
        }
        return true;
    }

    private void updateSignpostCount(SuperPostPostTile tile) {
        if (tile == null || tile.owner == null) {
            return;
        }
        Pair<StringSet, Pair<Integer, Integer>> pair = PostHandler.playerKnownWaystones.get(tile.owner);
        if ((Integer)((Pair)pair.b).b >= 0) {
            Pair pair2 = (Pair)pair.b;
            Integer n = (Integer)pair2.b;
            pair2.b = (Integer)pair2.b + 1;
            Integer n2 = pair2.b;
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile instanceof SuperPostPostTile && !PostHandler.isHandEmpty(event.getPlayer()) && (event.getPlayer().func_184614_ca().func_77973_b() instanceof PostWrench || event.getPlayer().func_184614_ca().func_77973_b() instanceof CalibratedPostWrench)) {
            event.setCanceled(true);
            ((SuperPostPost)tile.func_145838_q()).func_180649_a(event.getWorld(), event.getPos(), event.getPlayer());
            return;
        }
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (event.getState().func_177230_c() instanceof BasePost) {
            BasePostTile t = BasePost.getWaystoneRootTile(event.getWorld(), event.getPos());
            if (!ConfigHandler.securityLevelWaystone.canUse(player, "" + t.getBaseInfo().owner)) {
                event.setCanceled(true);
            } else {
                this.updateWaystoneCount(t);
                t.onBlockDestroy(new MyBlockPos(event.getWorld(), event.getPos(), player.field_71093_bK));
            }
        } else if (event.getState().func_177230_c() instanceof SuperPostPost) {
            SuperPostPostTile t = SuperPostPost.getSuperTile(event.getWorld(), event.getPos());
            if (!ConfigHandler.securityLevelSignpost.canUse(player, "" + t.owner)) {
                event.setCanceled(true);
            } else {
                this.updateSignpostCount(t);
                t.onBlockDestroy(new MyBlockPos(event.getWorld(), event.getPos(), player.field_71093_bK));
            }
        }
    }
}

