/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.proxy;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.common.config.ModConfiguration;
import org.jglrxavpok.mods.decraft.common.config.ModJsonConfiguration;
import org.jglrxavpok.mods.decraft.common.network.ModGuiHandler;
import org.jglrxavpok.mods.decraft.common.network.message.ConfigSyncMessage;
import org.jglrxavpok.mods.decraft.common.network.message.RecipeNavigationMessage;
import org.jglrxavpok.mods.decraft.init.ModBlocks;
import org.jglrxavpok.mods.decraft.init.ModItems;
import org.jglrxavpok.mods.decraft.integration.ModIntegrations;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingManager;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;
import org.jglrxavpok.mods.decraft.stats.ModAchievementList;

public class CommonProxy {
    public void preInit() {
        this.initializeConfig();
        this.registerIntegrations();
        this.registerNetworkMessages();
    }

    public void init() {
        this.registerAchievements();
        this.registerCraftingRecipes();
        this.registerGuiHandler();
        this.registerOreDictionaryEntries();
        this.registerUncraftingRecipes();
    }

    public void postInit() {
        this.initializeRecipeHandlers();
    }

    private void initializeConfig() {
        ModConfiguration.initializeConfiguration();
        ModJsonConfiguration.loadItemMappings();
    }

    private void initializeRecipeHandlers() {
        RecipeHandlers.postInit();
    }

    private void registerAchievements() {
        ModAchievementList.registerAchievementPage();
    }

    private void registerCraftingRecipes() {
        ModBlocks.registerCraftingRecipes();
        ModItems.registerCraftingRecipes();
    }

    private void registerGuiHandler() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ModUncrafting.instance, (IGuiHandler)new ModGuiHandler());
    }

    private void registerIntegrations() {
        ModIntegrations.registerIntegrations();
    }

    private void registerNetworkMessages() {
        ModUncrafting.NETWORK.registerMessage(RecipeNavigationMessage.MessageHandler.class, RecipeNavigationMessage.class, 0, Side.SERVER);
        ModUncrafting.NETWORK.registerMessage(ConfigSyncMessage.MessageHandler.class, ConfigSyncMessage.class, 1, Side.CLIENT);
        ModUncrafting.NETWORK.registerMessage(ConfigSyncMessage.MessageHandler.class, ConfigSyncMessage.class, 2, Side.SERVER);
    }

    private void registerOreDictionaryEntries() {
        ModItems.registerOreDictionaryEntries();
    }

    private void registerUncraftingRecipes() {
        UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 1), new Object[]{"B B", " I ", "I I", Character.valueOf('B'), "blockIron", Character.valueOf('I'), "ingotIron"}));
        UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 2), new Object[]{"B  ", " I ", "  I", Character.valueOf('B'), "blockIron", Character.valueOf('I'), "ingotIron"}));
        if (!Loader.isModLoaded((String)"craftablehorsearmour")) {
            UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(Items.field_151138_bX, new Object[]{"  I", "IWI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('W'), Item.func_150898_a((Block)Blocks.field_150325_L)}));
            UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(Items.field_151136_bY, new Object[]{"  G", "GWG", "GGG", Character.valueOf('G'), "ingotGold", Character.valueOf('W'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 4)}));
            UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(Items.field_151125_bZ, new Object[]{"  D", "DWD", "DDD", Character.valueOf('D'), "gemDiamond", Character.valueOf('W'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 3)}));
            UncraftingManager.addUncraftingRecipe((IRecipe)new ShapedOreRecipe(Items.field_151141_av, new Object[]{"LLL", "S S", "I I", Character.valueOf('L'), "leather", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('I'), "ingotIron"}));
        }
    }
}

