/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;

public class MekanismRecipeHandlers {

    public static class ShapelessMekanismRecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapelessMekanismRecipeHandler.getRecipeClass("mekanism.common.recipe.ShapelessMekanismRecipe");

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                for (Object target : (ArrayList)recipeClass.getMethod("getInput", null).invoke((Object)r, new Object[0])) {
                    if (target instanceof ItemStack) {
                        itemStacks.add((ItemStack)target);
                        continue;
                    }
                    if (!(target instanceof ArrayList)) continue;
                    itemStacks.add((ItemStack)((ArrayList)target).get(0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapelessMekanismRecipeHandler.copyRecipeStacks(itemStacks).toArray(new ItemStack[9]);
        }
    }

    public static class ShapedMekanismRecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapedMekanismRecipeHandler.getRecipeClass("mekanism.common.recipe.ShapedMekanismRecipe");

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                for (Object itemObject : (Object[])recipeClass.getMethod("getInput", null).invoke((Object)r, new Object[0])) {
                    Object itemStack = itemObject instanceof ItemStack ? (ItemStack)itemObject : (itemObject instanceof List ? (ItemStack)((List)itemObject).get(0) : null);
                    itemStacks.add((ItemStack)itemStack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapedMekanismRecipeHandler.copyRecipeStacks(itemStacks).toArray(new ItemStack[9]);
        }
    }
}

