/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;

public class IC2RecipeHandlers {

    public static class ShapelessIC2RecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapelessIC2RecipeHandler.getRecipeClass("ic2.core.recipe.AdvShapelessRecipe");

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                Class<?> RecipeInputItemStack = Class.forName("ic2.api.recipe.RecipeInputItemStack");
                Class<?> RecipeInputOreDict = Class.forName("ic2.api.recipe.RecipeInputOreDict");
                for (Object target : (Object[])recipeClass.getField("input").get(r)) {
                    if (RecipeInputItemStack.isInstance(target)) {
                        ItemStack itemStack = (ItemStack)RecipeInputItemStack.getField("input").get(target);
                        itemStacks.add(itemStack);
                        continue;
                    }
                    if (RecipeInputOreDict.isInstance(target)) {
                        List _itemStacks = (List)RecipeInputOreDict.getMethod("getInputs", null).invoke(target, new Object[0]);
                        itemStacks.add((ItemStack)_itemStacks.get(0));
                        continue;
                    }
                    if (target instanceof ItemStack) {
                        itemStacks.add((ItemStack)target);
                        continue;
                    }
                    if (!(target instanceof ArrayList)) continue;
                    itemStacks.add((ItemStack)((ArrayList)target).get(0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapelessIC2RecipeHandler.copyRecipeStacks(itemStacks).toArray(new ItemStack[9]);
        }
    }

    public static class ShapedIC2RecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapedIC2RecipeHandler.getRecipeClass("ic2.core.recipe.AdvRecipe");

        private List<List<ItemStack>> getInputs(IRecipe r) {
            try {
                Object[] input = (Object[])recipeClass.getField("input").get(r);
                int[] masks = (int[])recipeClass.getField("masks").get(r);
                int inputWidth = (Integer)recipeClass.getField("inputWidth").get(r);
                int inputHeight = (Integer)recipeClass.getField("inputHeight").get(r);
                int mask = masks[0];
                int itemIndex = 0;
                ArrayList<Object> ret = new ArrayList<Object>();
                for (int i = 0; i < 9; ++i) {
                    if (i % 3 >= inputWidth || i / 3 >= inputHeight) continue;
                    if ((mask >>> 8 - i & 1) != 0) {
                        ret.add(input[itemIndex++]);
                        continue;
                    }
                    ret.add(null);
                }
                return this.replaceRecipeInputs(ret);
            }
            catch (Exception ex) {
                return null;
            }
        }

        private List<List<ItemStack>> replaceRecipeInputs(List list) {
            try {
                ArrayList<List<ItemStack>> out = new ArrayList<List<ItemStack>>(list.size());
                for (Object recipe : list) {
                    if (recipe == null) {
                        out.add(Collections.emptyList());
                        continue;
                    }
                    ArrayList replace = new ArrayList((List)Class.forName("ic2.api.recipe.IRecipeInput").getMethod("getInputs", null).invoke(recipe, new Object[0]));
                    ListIterator<ItemStack> it = replace.listIterator();
                    while (it.hasNext()) {
                        ItemStack stack = (ItemStack)it.next();
                        if (stack == null || !Class.forName("ic2.api.item.IElectricItem").isInstance(stack.func_77973_b())) continue;
                        it.set(stack.func_77946_l());
                    }
                    out.add(replace);
                }
                return out;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                List<List<ItemStack>> items = this.getInputs(r);
                if (items != null) {
                    for (List<ItemStack> list : items) {
                        if (list != null && list.size() > 0) {
                            itemStacks.add(list.get(0));
                            continue;
                        }
                        itemStacks.add(null);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapedIC2RecipeHandler.copyRecipeStacks(itemStacks).toArray(new ItemStack[9]);
        }
    }
}

