/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;

public class AE2RecipeHandlers {

    public static class ShapelessAE2RecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapelessAE2RecipeHandler.getRecipeClass("appeng.recipes.game.ShapelessRecipe");

        private List<List<ItemStack>> getIngredients(IRecipe r) {
            try {
                Class<?> IIngredient2 = Class.forName("appeng.api.recipes.IIngredient");
                List recipeInput = (List)recipeClass.getMethod("getInput", null).invoke((Object)r, new Object[0]);
                ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(recipeInput.size());
                for (Object inputObj : recipeInput) {
                    if (!IIngredient2.isInstance(inputObj)) continue;
                    try {
                        Object[] is = (ItemStack[])inputObj.getClass().getMethod("getItemStackSet", null).invoke(inputObj, new Object[0]);
                        inputs.add(Lists.newArrayList((Object[])is));
                    }
                    catch (Exception ex) {
                        ModUncrafting.LOGGER.catching((Throwable)ex);
                    }
                }
                return inputs;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                for (List<ItemStack> itemObject : this.getIngredients(r)) {
                    Object itemStack = itemObject instanceof ItemStack ? (ItemStack)itemObject : (itemObject instanceof ArrayList ? (ItemStack)((ArrayList)itemObject).get(0) : null);
                    itemStacks.add((ItemStack)itemStack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapelessAE2RecipeHandler.copyRecipeStacks(itemStacks).toArray(new ItemStack[9]);
        }
    }

    public static class ShapedAE2RecipeHandler
    extends RecipeHandlers.RecipeHandler {
        public static final Class<? extends IRecipe> recipeClass = ShapedAE2RecipeHandler.getRecipeClass("appeng.recipes.game.ShapedRecipe");

        private List<List<ItemStack>> getIngredients(IRecipe r) {
            try {
                Object[] items = (Object[])recipeClass.getMethod("getIngredients", null).invoke((Object)r, new Object[0]);
                int width = (Integer)recipeClass.getMethod("getWidth", null).invoke((Object)r, new Object[0]);
                int height = (Integer)recipeClass.getMethod("getHeight", null).invoke((Object)r, new Object[0]);
                ArrayList<List<ItemStack>> in = new ArrayList<List<ItemStack>>(width * height);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if (items[x * height + y] != null) {
                            Object ing = items[x * height + y];
                            List<Object> slotList = Collections.emptyList();
                            try {
                                ItemStack[] is = (ItemStack[])ing.getClass().getMethod("getItemStackSet", null).invoke(ing, new Object[0]);
                                slotList = Arrays.asList(is);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            in.add(slotList);
                            continue;
                        }
                        in.add(Collections.emptyList());
                    }
                }
                return in;
            }
            catch (Exception ex) {
                return null;
            }
        }

        private static ItemStack[] reshapeRecipe(List<ItemStack> recipeItems, IRecipe r) {
            try {
                int width = (Integer)recipeClass.getMethod("getWidth", null).invoke((Object)r, new Object[0]);
                int height = (Integer)recipeClass.getMethod("getHeight", null).invoke((Object)r, new Object[0]);
                return ShapedAE2RecipeHandler.reshapeRecipe(recipeItems, width, height);
            }
            catch (Exception ex) {
                return recipeItems.toArray(new ItemStack[9]);
            }
        }

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            try {
                List<List<ItemStack>> items = this.getIngredients(r);
                if (items != null) {
                    for (List<ItemStack> list : items) {
                        if (list != null && list.size() > 0) {
                            itemStacks.add(list.get(0));
                            continue;
                        }
                        itemStacks.add(null);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ShapedAE2RecipeHandler.reshapeRecipe(ShapedAE2RecipeHandler.copyRecipeStacks(itemStacks), r);
        }
    }
}

