/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.NBTSensitiveRecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external.AE2RecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external.CoFHRecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external.IC2RecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external.MekanismRecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.external.TinkersRecipeHandlers;

public final class RecipeHandlers {
    public static final RecipeMap<RecipeHandler> HANDLERS = new RecipeMap();
    private static final RecipeMap<ItemStack[]> RECIPE_OUTPUTS = new RecipeMap();

    public static void postInit() {
        RecipeHandlers.buildHandlerMap();
        RecipeHandlers.buildRecipeOutputMap();
    }

    private static void buildHandlerMap() {
        HANDLERS.put(RecipesMapExtending.class, null);
        HANDLERS.put(ShapedRecipes.class, new ShapedRecipeHandler());
        HANDLERS.put(ShapelessRecipes.class, new ShapelessRecipeHandler());
        HANDLERS.put(RecipeFireworks.class, new NBTSensitiveRecipeHandlers.FireworksRecipeHandler());
        HANDLERS.put(RecipeTippedArrow.class, new NBTSensitiveRecipeHandlers.TippedArrowRecipeHandler());
        HANDLERS.put(ShapedOreRecipe.class, new ShapedOreRecipeHandler());
        HANDLERS.put(ShapelessOreRecipe.class, new ShapelessOreRecipeHandler());
        if (AE2RecipeHandlers.ShapedAE2RecipeHandler.recipeClass != null) {
            HANDLERS.put(AE2RecipeHandlers.ShapedAE2RecipeHandler.recipeClass, new AE2RecipeHandlers.ShapedAE2RecipeHandler());
        }
        if (AE2RecipeHandlers.ShapelessAE2RecipeHandler.recipeClass != null) {
            HANDLERS.put(AE2RecipeHandlers.ShapelessAE2RecipeHandler.recipeClass, new AE2RecipeHandlers.ShapelessAE2RecipeHandler());
        }
        if (CoFHRecipeHandlers.CoverRecipeHandler.recipeClass != null) {
            HANDLERS.put(CoFHRecipeHandlers.CoverRecipeHandler.recipeClass, new CoFHRecipeHandlers.CoverRecipeHandler());
        }
        if (IC2RecipeHandlers.ShapedIC2RecipeHandler.recipeClass != null) {
            HANDLERS.put(IC2RecipeHandlers.ShapedIC2RecipeHandler.recipeClass, new IC2RecipeHandlers.ShapedIC2RecipeHandler());
        }
        if (IC2RecipeHandlers.ShapelessIC2RecipeHandler.recipeClass != null) {
            HANDLERS.put(IC2RecipeHandlers.ShapelessIC2RecipeHandler.recipeClass, new IC2RecipeHandlers.ShapelessIC2RecipeHandler());
        }
        if (MekanismRecipeHandlers.ShapedMekanismRecipeHandler.recipeClass != null) {
            HANDLERS.put(MekanismRecipeHandlers.ShapedMekanismRecipeHandler.recipeClass, new MekanismRecipeHandlers.ShapedMekanismRecipeHandler());
        }
        if (MekanismRecipeHandlers.ShapelessMekanismRecipeHandler.recipeClass != null) {
            HANDLERS.put(MekanismRecipeHandlers.ShapelessMekanismRecipeHandler.recipeClass, new MekanismRecipeHandlers.ShapelessMekanismRecipeHandler());
        }
        if (TinkersRecipeHandlers.TableRecipeHandler.recipeClass != null) {
            HANDLERS.put(TinkersRecipeHandlers.TableRecipeHandler.recipeClass, new TinkersRecipeHandlers.TableRecipeHandler());
        }
    }

    private static void buildRecipeOutputMap() {
        RECIPE_OUTPUTS.put(RecipeFireworks.class, new ItemStack[]{new ItemStack(Items.field_151154_bQ), new ItemStack(Items.field_151152_bP, 3)});
        RECIPE_OUTPUTS.put(RecipeTippedArrow.class, new ItemStack[]{new ItemStack(Items.field_185167_i, 8)});
    }

    public static class ShapelessOreRecipeHandler
    extends RecipeHandler {
        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ShapelessOreRecipe shapelessRecipe = (ShapelessOreRecipe)r;
            List<ItemStack> recipeItems = ShapelessOreRecipeHandler.copyRecipeStacks(ShapelessOreRecipeHandler.getOreRecipeItems(shapelessRecipe.getInput()));
            if (!recipeItems.isEmpty()) {
                return recipeItems.toArray(new ItemStack[9]);
            }
            return new ItemStack[0];
        }
    }

    public static class ShapedOreRecipeHandler
    extends RecipeHandler {
        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ShapedOreRecipe shapedRecipe = (ShapedOreRecipe)r;
            List<ItemStack> recipeItems = ShapedOreRecipeHandler.copyRecipeStacks(ShapedOreRecipeHandler.getOreRecipeItems(Arrays.asList(shapedRecipe.getInput())));
            if (!recipeItems.isEmpty()) {
                int recipeWidth = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedRecipe, (String[])new String[]{"width"});
                int recipeHeight = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedRecipe, (String[])new String[]{"height"});
                return ShapedOreRecipeHandler.reshapeRecipe(recipeItems, recipeWidth, recipeHeight);
            }
            return new ItemStack[0];
        }
    }

    public static class ShapelessRecipeHandler
    extends RecipeHandler {
        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ShapelessRecipes shapelessRecipe = (ShapelessRecipes)r;
            List<ItemStack> recipeItems = ShapelessRecipeHandler.copyRecipeStacks(shapelessRecipe.field_77579_b);
            return recipeItems.toArray(new ItemStack[9]);
        }
    }

    public static class ShapedRecipeHandler
    extends RecipeHandler {
        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)r;
            List<ItemStack> recipeItems = ShapedRecipeHandler.copyRecipeStacks(Arrays.asList(shapedRecipe.field_77574_d));
            int recipeWidth = shapedRecipe.field_77576_b;
            int recipeHeight = shapedRecipe.field_77577_c;
            return ShapedRecipeHandler.reshapeRecipe(recipeItems, recipeWidth, recipeHeight);
        }
    }

    public static abstract class RecipeHandler {
        public abstract ItemStack[] getCraftingGrid(IRecipe var1);

        protected static Class<? extends IRecipe> getRecipeClass(String className) {
            try {
                return Class.forName(className).asSubclass(IRecipe.class);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }

        public static ItemStack getPossibleRecipeOutput(IRecipe r, ItemStack inputStack) {
            ItemStack[] outputStacks = (ItemStack[])RECIPE_OUTPUTS.get(r.getClass());
            if (outputStacks != null && outputStacks.length > 0) {
                for (ItemStack outputStack : outputStacks) {
                    if (!ItemStack.func_179545_c((ItemStack)inputStack, (ItemStack)outputStack)) continue;
                    return outputStack.func_77946_l();
                }
            }
            return null;
        }

        protected static ItemStack[] reshapeRecipe(List<ItemStack> recipeItems, int recipeWidth, int recipeHeight) {
            ItemStack[] stacks = new ItemStack[9];
            for (int row = 0; row < recipeHeight; ++row) {
                for (int col = 0; col < recipeWidth; ++col) {
                    stacks[row * 3 + col] = recipeItems.get(col + row * recipeWidth);
                }
            }
            return stacks;
        }

        protected static List<ItemStack> getOreRecipeItems(List<Object> itemObjects) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (Object itemObject : itemObjects) {
                ItemStack itemStack;
                if (itemObject instanceof ItemStack) {
                    itemStack = (ItemStack)itemObject;
                } else if (itemObject instanceof List) {
                    List list = (List)itemObject;
                    if (list.isEmpty()) {
                        itemStacks.clear();
                        break;
                    }
                    itemStack = (ItemStack)((List)itemObject).get(0);
                } else {
                    itemStack = null;
                }
                itemStacks.add(itemStack);
            }
            return itemStacks;
        }

        protected static List<ItemStack> copyRecipeStacks(List<ItemStack> inputStacks) {
            ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
            for (ItemStack inputStack : inputStacks) {
                if (inputStack != null) {
                    ItemStack outputStack = inputStack.func_77946_l();
                    if (outputStack.func_77952_i() == Short.MAX_VALUE) {
                        outputStack.func_77964_b(0);
                    }
                    outputStacks.add(outputStack);
                    continue;
                }
                outputStacks.add(null);
            }
            return outputStacks;
        }
    }

    public static class RecipeMap<T>
    extends HashMap<Class<? extends IRecipe>, T> {
        public T get(Class<? extends IRecipe> key) {
            Object result = super.get(key);
            while (result == null && key.getSuperclass() != Object.class) {
                key = key.getSuperclass();
                result = super.get(key);
            }
            return (T)result;
        }
    }
}

