/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;

public final class NBTSensitiveRecipeHandlers {

    public static class TippedArrowRecipeHandler
    extends NBTSensitiveRecipeHandler {
        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                if (i != 4) {
                    recipeItems.add(new ItemStack(Items.field_151032_g, 1));
                    continue;
                }
                ItemStack stack = new ItemStack((Item)Items.field_185156_bI, 1);
                PotionUtils.func_185188_a((ItemStack)stack, (PotionType)PotionUtils.func_185191_c((ItemStack)this.inputStack));
                PotionUtils.func_185184_a((ItemStack)stack, (Collection)PotionUtils.func_185190_b((ItemStack)this.inputStack));
                recipeItems.add(stack);
            }
            return recipeItems.toArray(new ItemStack[9]);
        }
    }

    public static class FireworksRecipeHandler
    extends NBTSensitiveRecipeHandler {
        private List<ItemStack> getFireworkStarItems() {
            ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
            recipeItems.add(new ItemStack(Items.field_151016_H, 1));
            if (this.inputStack.func_77942_o()) {
                NBTTagCompound tag = this.inputStack.func_77978_p().func_74775_l("Explosion");
                for (int color : tag.func_74759_k("Colors")) {
                    int index = ArrayUtils.indexOf((int[])ItemDye.field_150922_c, (int)color);
                    if (index < 0) continue;
                    recipeItems.add(new ItemStack(Items.field_151100_aR, 1, index));
                }
                switch (tag.func_74762_e("Type")) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        recipeItems.add(new ItemStack(Items.field_151059_bz, 1));
                        break;
                    }
                    case 2: {
                        recipeItems.add(new ItemStack(Items.field_151074_bl, 1));
                        break;
                    }
                    case 3: {
                        recipeItems.add(new ItemStack(Items.field_151144_bL, 1, 4));
                        break;
                    }
                    case 4: {
                        recipeItems.add(new ItemStack(Items.field_151008_G, 1));
                    }
                }
                if (tag.func_74764_b("Trail") && tag.func_74771_c("Trail") == 1) {
                    recipeItems.add(new ItemStack(Items.field_151045_i, 1));
                }
                if (tag.func_74764_b("Flicker") && tag.func_74771_c("Flicker") == 1) {
                    recipeItems.add(new ItemStack(Items.field_151114_aO, 1));
                }
            }
            return recipeItems;
        }

        private List<ItemStack> getFireworkRocketItems() {
            ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
            if (this.inputStack.func_77942_o()) {
                NBTTagCompound tag = this.inputStack.func_77978_p().func_74775_l("Fireworks");
                if (tag.func_74764_b("Flight")) {
                    recipeItems.add(new ItemStack(Items.field_151016_H, tag.func_74762_e("Flight")));
                }
                recipeItems.add(new ItemStack(Items.field_151121_aF, 1));
                NBTTagList explosions = tag.func_150295_c("Explosions", 10);
                for (int i = 0; i < explosions.func_74745_c(); ++i) {
                    NBTTagCompound explosion = explosions.func_150305_b(i);
                    ItemStack stack = new ItemStack(Items.field_151154_bQ, 1);
                    NBTTagCompound stackTag = new NBTTagCompound();
                    stackTag.func_74782_a("Explosion", (NBTBase)explosion);
                    stack.func_77982_d(stackTag);
                    recipeItems.add(stack);
                }
            }
            return recipeItems;
        }

        @Override
        public ItemStack[] getCraftingGrid(IRecipe r) {
            ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
            if (this.inputStack.func_77973_b() == Items.field_151154_bQ) {
                recipeItems.addAll(this.getFireworkStarItems());
            }
            if (this.inputStack.func_77973_b() == Items.field_151152_bP) {
                recipeItems.addAll(this.getFireworkRocketItems());
            }
            return recipeItems.toArray(new ItemStack[9]);
        }
    }

    public static abstract class NBTSensitiveRecipeHandler
    extends RecipeHandlers.RecipeHandler
    implements INBTSensitiveRecipeHandler {
        protected ItemStack inputStack;

        @Override
        public void setInputStack(ItemStack stack) {
            this.inputStack = stack;
        }

        @Override
        public ItemStack getInputStack() {
            return this.inputStack;
        }
    }

    public static interface INBTSensitiveRecipeHandler {
        public void setInputStack(ItemStack var1);

        public ItemStack getInputStack();
    }
}

