/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class UncraftingResult {
    public ResultType resultType = ResultType.INACTIVE;
    public List<Map.Entry<ItemStack[], Integer>> craftingGrids = new ArrayList<Map.Entry<ItemStack[], Integer>>();
    public int experienceCost = 0;
    public int selectedCraftingGrid = 0;

    public int getRecipeCount() {
        return this.craftingGrids.size();
    }

    public int getMinStackSize() {
        return this.craftingGrids.size() > 0 ? this.craftingGrids.get(this.selectedCraftingGrid).getValue() : 1;
    }

    public ItemStack[] getCraftingGrid() {
        return this.craftingGrids.size() > 0 ? this.craftingGrids.get(this.selectedCraftingGrid).getKey() : null;
    }

    public boolean isError() {
        return ArrayUtils.indexOf((Object[])ResultType.IS_ERROR, (Object)((Object)this.resultType)) >= 0;
    }

    public boolean canPopulateInventory() {
        return ArrayUtils.indexOf((Object[])ResultType.CAN_POPULATE_INVENTORY, (Object)((Object)this.resultType)) >= 0;
    }

    public boolean renderBackgroundItems() {
        return ArrayUtils.indexOf((Object[])ResultType.RENDER_BACKGROUND_ITEMS, (Object)((Object)this.resultType)) >= 0;
    }

    public static enum ResultType {
        INACTIVE,
        NOT_UNCRAFTABLE,
        NOT_ENOUGH_ITEMS,
        NOT_ENOUGH_XP,
        NEED_CONTAINER_ITEMS,
        VALID,
        UNCRAFTED;

        private static final ResultType[] IS_ERROR;
        private static final ResultType[] CAN_POPULATE_INVENTORY;
        private static final ResultType[] RENDER_BACKGROUND_ITEMS;

        static {
            IS_ERROR = new ResultType[]{NOT_UNCRAFTABLE, NOT_ENOUGH_ITEMS, NOT_ENOUGH_XP, NEED_CONTAINER_ITEMS};
            CAN_POPULATE_INVENTORY = new ResultType[]{VALID, NEED_CONTAINER_ITEMS};
            RENDER_BACKGROUND_ITEMS = new ResultType[]{NOT_ENOUGH_ITEMS, NOT_ENOUGH_XP, NEED_CONTAINER_ITEMS};
        }
    }
}

