/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.item.uncrafting;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.common.config.ModConfiguration;
import org.jglrxavpok.mods.decraft.common.config.ModJsonConfiguration;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingResult;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.NBTSensitiveRecipeHandlers;
import org.jglrxavpok.mods.decraft.item.uncrafting.handlers.RecipeHandlers;

public class UncraftingManager {
    public static final List<IRecipe> recipes = Lists.newArrayList();
    public static final List<IRecipe> blockedRecipes = Lists.newArrayList();
    public static final List<ItemStack> blockedItems = Lists.newArrayList();
    public static final List<ItemStack> blockedIngredients = Lists.newArrayList();
    public static final List<ItemStack> removedIngredients = Lists.newArrayList();

    public static void addUncraftingRecipe(IRecipe recipe) {
        recipes.add(recipe);
    }

    public static UncraftingResult getUncraftingResult(EntityPlayer player, ItemStack itemStack) {
        UncraftingResult uncraftingResult = new UncraftingResult();
        uncraftingResult.craftingGrids = UncraftingManager.findMatchingRecipes(itemStack);
        uncraftingResult.experienceCost = UncraftingManager.getUncraftingXpCost(itemStack);
        if (uncraftingResult.getRecipeCount() > 0 && itemStack.field_77994_a < uncraftingResult.getMinStackSize()) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_ENOUGH_ITEMS;
        } else if (uncraftingResult.getRecipeCount() == 0) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_UNCRAFTABLE;
        } else if (!player.field_71075_bZ.field_75098_d && player.field_71068_ca < uncraftingResult.experienceCost) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_ENOUGH_XP;
        } else {
            for (ItemStack recipeStack : uncraftingResult.getCraftingGrid()) {
                if (recipeStack == null || !recipeStack.func_77973_b().hasContainerItem(recipeStack)) continue;
                uncraftingResult.resultType = UncraftingResult.ResultType.NEED_CONTAINER_ITEMS;
                break;
            }
            if (uncraftingResult.resultType != UncraftingResult.ResultType.NEED_CONTAINER_ITEMS) {
                uncraftingResult.resultType = UncraftingResult.ResultType.VALID;
            }
        }
        return uncraftingResult;
    }

    public static void recalculateResultType(UncraftingResult uncraftingResult, EntityPlayer player, ItemStack itemStack) {
        uncraftingResult.resultType = UncraftingResult.ResultType.INACTIVE;
        if (uncraftingResult.getRecipeCount() > 0 && itemStack.field_77994_a < uncraftingResult.getMinStackSize()) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_ENOUGH_ITEMS;
        } else if (uncraftingResult.getRecipeCount() == 0) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_UNCRAFTABLE;
        } else if (!player.field_71075_bZ.field_75098_d && player.field_71068_ca < uncraftingResult.experienceCost) {
            uncraftingResult.resultType = UncraftingResult.ResultType.NOT_ENOUGH_XP;
        } else {
            for (ItemStack recipeStack : uncraftingResult.getCraftingGrid()) {
                if (recipeStack == null || !recipeStack.func_77973_b().hasContainerItem(recipeStack)) continue;
                uncraftingResult.resultType = UncraftingResult.ResultType.NEED_CONTAINER_ITEMS;
                break;
            }
            if (uncraftingResult.resultType != UncraftingResult.ResultType.NEED_CONTAINER_ITEMS) {
                uncraftingResult.resultType = UncraftingResult.ResultType.VALID;
            }
        }
    }

    private static int getUncraftingXpCost(ItemStack itemStack) {
        if (ModConfiguration.uncraftMethod == 0) {
            return ModConfiguration.standardLevel;
        }
        if (ModConfiguration.uncraftMethod == 1) {
            if (itemStack == null) {
                return 0;
            }
            if (!itemStack.func_77973_b().func_77645_m()) {
                return ModConfiguration.standardLevel;
            }
            if (itemStack.func_77973_b().func_77645_m() && itemStack.func_77952_i() == 0) {
                return ModConfiguration.standardLevel;
            }
            int damagePercentage = (int)((double)itemStack.func_77952_i() / (double)itemStack.func_77958_k() * 100.0);
            return ModConfiguration.maxUsedLevel * damagePercentage / 100;
        }
        return ModConfiguration.standardLevel;
    }

    public static int recalculateExperienceCost(ItemStack inputStack, ItemStack bookStack) {
        int experienceCost = UncraftingManager.getUncraftingXpCost(inputStack);
        if (bookStack != null && inputStack != null && inputStack.func_77948_v()) {
            int enchantmentCount = EnchantmentHelper.func_82781_a((ItemStack)inputStack).size();
            experienceCost += enchantmentCount * ModConfiguration.enchantmentCost;
        }
        return Math.min(experienceCost, ModConfiguration.maxUsedLevel);
    }

    private static List<Map.Entry<ItemStack[], Integer>> findMatchingRecipes(ItemStack itemStack) {
        ArrayList<Map.Entry<ItemStack[], Integer>> list = new ArrayList<Map.Entry<ItemStack[], Integer>>();
        if (UncraftingManager.isOutputBlocked(itemStack)) {
            return list;
        }
        ArrayList<IRecipe> recipeList = new ArrayList<IRecipe>(CraftingManager.func_77594_a().func_77592_b());
        recipeList.addAll(recipes);
        for (IRecipe recipe : recipeList) {
            ModJsonConfiguration.ItemMapping mapping;
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null) {
                recipeOutput = RecipeHandlers.RecipeHandler.getPossibleRecipeOutput(recipe, itemStack);
            }
            if (!ItemStack.func_185132_d((ItemStack)itemStack, (ItemStack)recipeOutput) || (mapping = ModJsonConfiguration.ITEM_MAPPINGS.get(itemStack)) != null && (mapping.recipeType != null && !recipe.getClass().getCanonicalName().equals(mapping.recipeType) || mapping.matchTag && !UncraftingManager.areItemStackSubTagsEqual(itemStack, recipeOutput, mapping.tagName) || mapping.matchField && !UncraftingManager.arePrivateFieldValuesEqual(itemStack, recipeOutput, mapping.fieldNames))) continue;
            RecipeHandlers.RecipeHandler handler = RecipeHandlers.HANDLERS.get(recipe.getClass());
            if (handler != null) {
                if (handler instanceof NBTSensitiveRecipeHandlers.INBTSensitiveRecipeHandler) {
                    ((NBTSensitiveRecipeHandlers.INBTSensitiveRecipeHandler)((Object)handler)).setInputStack(itemStack.func_77946_l());
                }
                int minStackSize = recipeOutput.field_77994_a;
                ItemStack[] craftingGrid = handler.getCraftingGrid(recipe);
                if (craftingGrid == null || craftingGrid.length <= 0 || UncraftingManager.isRecipeBlocked(craftingGrid) || UncraftingManager.recipeContainsBlockedItems(craftingGrid) || UncraftingManager.craftingGridContainsInputItem(itemStack, craftingGrid)) continue;
                craftingGrid = UncraftingManager.removeItemsFromOutputBecauseCraftTweaker(craftingGrid);
                if (ModConfiguration.uncraftMethod == 0 && itemStack.func_77984_f() && itemStack.func_77951_h()) {
                    craftingGrid = UncraftingManager.removeItemsFromOutputByDamage(itemStack, craftingGrid);
                }
                if (UncraftingManager.countFilledSlotsInCraftingGrid(craftingGrid) > 0) {
                    AbstractMap.SimpleEntry<ItemStack[], Integer> pair = new AbstractMap.SimpleEntry<ItemStack[], Integer>(craftingGrid, minStackSize);
                    list.add(pair);
                }
                if (mapping == null || !mapping.singleRecipe) continue;
                break;
            }
            ModUncrafting.LOGGER.error("findMatchingRecipes :: Unknown IRecipe implementation " + recipe.getClass().getCanonicalName() + " for item " + itemStack.func_77973_b().getRegistryName());
        }
        return list;
    }

    private static boolean areItemStackSubTagsEqual(ItemStack stackA, ItemStack stackB, String tagName) {
        String regex = "(?<=\\d+)[bdfsL](?=[,}])";
        NBTTagCompound tagA = stackA.func_77978_p();
        NBTTagCompound tagB = stackB.func_77978_p();
        if (tagA != null && tagB != null) {
            NBTBase subTagB;
            NBTBase subTagA = tagA.func_74781_a(tagName);
            return subTagA.equals((Object)(subTagB = tagB.func_74781_a(tagName))) || subTagA.toString().replaceAll("(?<=\\d+)[bdfsL](?=[,}])", "").equals(subTagB.toString().replaceAll("(?<=\\d+)[bdfsL](?=[,}])", ""));
        }
        return false;
    }

    private static boolean arePrivateFieldValuesEqual(ItemStack stackA, ItemStack stackB, String[] fieldNames) {
        Object oA = ObfuscationReflectionHelper.getPrivateValue(ItemStack.class, (Object)stackA, (String[])fieldNames);
        Object oB = ObfuscationReflectionHelper.getPrivateValue(ItemStack.class, (Object)stackB, (String[])fieldNames);
        return oA.equals(oB);
    }

    private static int countFilledSlotsInCraftingGrid(ItemStack[] craftingGrid) {
        int result = 0;
        for (int i = 0; i < craftingGrid.length; ++i) {
            if (craftingGrid[i] == null) continue;
            ++result;
        }
        return result;
    }

    private static boolean craftingGridContainsInputItem(ItemStack stack, ItemStack[] craftingGrid) {
        for (ItemStack recipeStack : craftingGrid) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)recipeStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)recipeStack)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack[] removeItemsFromOutputByDamage(ItemStack stack, ItemStack[] craftingGrid) {
        double damagePercentage = 100.0 * ((double)stack.func_77952_i() / (double)stack.func_77958_k());
        double durabilityPercentage = 100.0 - 100.0 * ((double)stack.func_77952_i() / (double)stack.func_77958_k());
        HashMap<String, AbstractMap.SimpleEntry<ItemStack, Integer>> materials = new HashMap<String, AbstractMap.SimpleEntry<ItemStack, Integer>>();
        for (ItemStack recipeStack : craftingGrid) {
            if (recipeStack == null) continue;
            String key = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)recipeStack.func_77973_b())).toString();
            if (recipeStack.func_77952_i() != 0) {
                key = key + "," + recipeStack.func_77952_i();
            }
            if (materials.containsKey(key)) {
                ((Map.Entry)materials.get(key)).setValue((Integer)((Map.Entry)materials.get(key)).getValue() + recipeStack.field_77994_a);
                continue;
            }
            AbstractMap.SimpleEntry<ItemStack, Integer> value = new AbstractMap.SimpleEntry<ItemStack, Integer>(recipeStack.func_77946_l(), recipeStack.field_77994_a);
            ((ItemStack)value.getKey()).field_77994_a = 1;
            materials.put(key, value);
        }
        for (String key : materials.keySet()) {
            ItemStack materialStack = (ItemStack)((Map.Entry)materials.get(key)).getKey();
            ItemStack nuggetStack = ModConfiguration.useNuggets ? UncraftingManager.getNuggetForOre(materialStack) : null;
            int amount = (Integer)((Map.Entry)materials.get(key)).getValue();
            int itemCount = 0;
            int nuggetCount = 0;
            if (ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)materialStack), (int)OreDictionary.getOreID((String)"stickWood"))) {
                itemCount = (int)Math.ceil((double)amount * (durabilityPercentage / 100.0));
            } else if (ModConfiguration.useRabbitHide && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)materialStack), (int)OreDictionary.getOreID((String)"leather"))) {
                nuggetStack = new ItemStack(Items.field_179555_bs, 1, 0);
                itemCount = (int)Math.floor((double)amount * (durabilityPercentage / 100.0));
                nuggetCount = (int)Math.floor((double)(amount * 4) * (durabilityPercentage / 100.0)) - itemCount * 4;
            } else if (nuggetStack != null) {
                itemCount = (int)Math.floor((double)amount * (durabilityPercentage / 100.0));
                nuggetCount = (int)Math.floor((double)(amount * 9) * (durabilityPercentage / 100.0)) - itemCount * 9;
            } else {
                itemCount = (int)Math.floor((double)amount * (durabilityPercentage / 100.0));
            }
            if (ModConfiguration.ensureReturn && itemCount == 0 && nuggetCount == 0 && nuggetStack != null) {
                nuggetCount = 1;
            }
            itemCount = amount - itemCount;
            for (int i = 0; i < craftingGrid.length; ++i) {
                if (craftingGrid[i] == null || !craftingGrid[i].func_77969_a(materialStack)) continue;
                if (itemCount > 0) {
                    craftingGrid[i] = null;
                    --itemCount;
                }
                if (itemCount != 0 || nuggetCount <= 0) continue;
                craftingGrid[i] = new ItemStack(nuggetStack.func_77973_b(), nuggetCount, nuggetStack.func_77952_i());
                nuggetCount = 0;
            }
        }
        return craftingGrid;
    }

    private static ItemStack getNuggetForOre(ItemStack oreStack) {
        int[] oreIds;
        Object[] oreTypes = new String[]{"gem", "ingot"};
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)oreStack)) {
            String nuggetName;
            List nuggetOres;
            String oreName = OreDictionary.getOreName((int)oreId);
            String[] oreNameParts = oreName.split("(?=\\p{Upper})");
            if (oreNameParts.length != 1 && (oreNameParts.length != 2 || ArrayUtils.indexOf((Object[])oreTypes, (Object)oreNameParts[0]) < 0)) continue;
            String oreNamePart = oreNameParts[oreNameParts.length - 1];
            if (Pattern.matches("^[a-z]+", oreNamePart)) {
                oreNamePart = oreNamePart.substring(0, 1).toUpperCase() + oreNamePart.substring(1);
            }
            if ((nuggetOres = OreDictionary.getOres((String)(nuggetName = "nugget" + oreNamePart))).isEmpty()) continue;
            ItemStack nuggetOre = (ItemStack)nuggetOres.get(0);
            return nuggetOre;
        }
        return null;
    }

    private static ItemStack[] removeItemsFromOutputBecauseCraftTweaker(ItemStack[] craftingGrid) {
        for (int i = 0; i < craftingGrid.length; ++i) {
            if (!UncraftingManager.shouldIngredientBeRemoved(craftingGrid[i])) continue;
            craftingGrid[i] = null;
        }
        return craftingGrid;
    }

    private static boolean isRecipeBlocked(ItemStack[] craftingGrid) {
        InventoryCrafting craftMatrix = new InventoryCrafting(craftingGrid);
        for (IRecipe irecipe : blockedRecipes) {
            if (!irecipe.func_77569_a((net.minecraft.inventory.InventoryCrafting)craftMatrix, null)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputBlocked(ItemStack stack) {
        String registryName = stack.func_77973_b().getRegistryName().toString();
        if (ArrayUtils.indexOf((Object[])ModConfiguration.excludedItems, (Object)registryName) >= 0) {
            return true;
        }
        if (ArrayUtils.indexOf((Object[])ModConfiguration.excludedItems, (Object)(registryName + "," + Integer.toString(stack.func_77952_i()))) >= 0) {
            return true;
        }
        for (ItemStack stackB : blockedItems) {
            if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)stackB)) continue;
            if (!stackB.func_77942_o()) {
                return true;
            }
            if (ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackB)) {
                return true;
            }
            if (!stack.func_77942_o()) continue;
            for (String key : stackB.func_77978_p().func_150296_c()) {
                if (!UncraftingManager.areItemStackSubTagsEqual(stack, stackB, key)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIngredientBlocked(ItemStack stack) {
        for (ItemStack stackB : blockedIngredients) {
            if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)stackB) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackB)) continue;
            return true;
        }
        return false;
    }

    private static boolean recipeContainsBlockedItems(ItemStack[] craftingGrid) {
        for (ItemStack stack : craftingGrid) {
            if (!UncraftingManager.isIngredientBlocked(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldIngredientBeRemoved(ItemStack stack) {
        for (ItemStack stackB : removedIngredients) {
            if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)stackB) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackB)) continue;
            return true;
        }
        return false;
    }

    private static class UncraftingMethod {
        public static final int JGLRXAVPOK = 0;
        public static final int XELL75_ZENEN = 1;

        private UncraftingMethod() {
        }
    }

    private static class InventoryCrafting
    extends net.minecraft.inventory.InventoryCrafting {
        public InventoryCrafting(ItemStack[] craftingGrid) {
            super(null, 3, 3);
            for (int i = 0; i < craftingGrid.length; ++i) {
                this.func_70299_a(i, craftingGrid[i]);
            }
        }

        public void func_70299_a(int index, @Nullable ItemStack stack) {
            try {
                super.func_70299_a(index, stack);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

