/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.jglrxavpok.mods.decraft.inventory.ContainerUncraftingTable;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingResult;

public class InventoryUncraftResult
implements IInventory {
    private ItemStackPair[] stackResult = new ItemStackPair[9];
    private ContainerUncraftingTable eventHandler;

    public InventoryUncraftResult(ContainerUncraftingTable p_i1807_1_) {
        for (int i = 0; i < this.stackResult.length; ++i) {
            this.stackResult[i] = new ItemStackPair();
        }
        this.eventHandler = p_i1807_1_;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int index) {
        if (this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.INACTIVE) {
            return this.stackResult[index].containerItem;
        }
        if (this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.NEED_CONTAINER_ITEMS) {
            if (this.stackResult[index].recipeItem != null && this.stackResult[index].recipeItem.func_77973_b().hasContainerItem(this.stackResult[index].recipeItem) && this.stackResult[index].containerItem != null) {
                return this.stackResult[index].recipeItem;
            }
            return null;
        }
        return this.stackResult[index].recipeItem;
    }

    public ItemStack getStackInSlot(int index, StackType stackType) {
        switch (stackType) {
            case RECIPE: {
                return this.stackResult[index].recipeItem;
            }
            case CONTAINER: {
                return this.stackResult[index].containerItem;
            }
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.VALID || this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED) {
            if (this.stackResult[index].recipeItem != null) {
                ItemStack itemstack = this.stackResult[index].recipeItem;
                this.stackResult[index].recipeItem = null;
                this.stackResult[index].containerItem = null;
                this.eventHandler.func_75130_a(this);
                return itemstack;
            }
        } else if (this.stackResult[index].containerItem != null) {
            ItemStack itemstack = this.stackResult[index].containerItem;
            this.stackResult[index].containerItem = null;
            this.eventHandler.func_75130_a(this);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED) {
            if (this.stackResult[index].recipeItem != null) {
                ItemStack itemstack = this.stackResult[index].recipeItem;
                this.stackResult[index].recipeItem = null;
                return itemstack;
            }
        } else if (this.stackResult[index].containerItem != null) {
            ItemStack itemstack = this.stackResult[index].containerItem;
            this.stackResult[index].containerItem = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack != null && this.stackResult[index].recipeItem != null && this.stackResult[index].recipeItem.func_77973_b().hasContainerItem(this.stackResult[index].recipeItem)) {
            Item recipeItem = this.stackResult[index].recipeItem.func_77973_b();
            Item containerItem = recipeItem.func_77668_q();
            if (containerItem == null) {
                containerItem = recipeItem;
            }
            if (stack.func_77973_b() == containerItem) {
                this.stackResult[index].containerItem = stack;
                if (recipeItem == containerItem) {
                    ItemStack newStack = stack.func_77946_l();
                    this.stackResult[index].recipeItem = newStack;
                    this.eventHandler.uncraftingResult.getCraftingGrid()[index] = newStack;
                }
                this.eventHandler.func_75130_a(this);
            }
        } else {
            this.stackResult[index].recipeItem = stack;
            if (this.eventHandler.uncraftingResult.resultType == UncraftingResult.ResultType.INACTIVE && stack == null) {
                this.stackResult[index].containerItem = stack;
            }
            this.eventHandler.func_75130_a(this);
        }
    }

    public void setInventorySlotContents(int index, ItemStack stack, StackType stackType) {
        switch (stackType) {
            case RECIPE: {
                this.stackResult[index].recipeItem = stack;
                break;
            }
            case CONTAINER: {
                this.stackResult[index].containerItem = stack;
            }
        }
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.stackResult[index].recipeItem != null && this.stackResult[index].recipeItem.func_77973_b().hasContainerItem(this.stackResult[index].recipeItem)) {
            Item recipeItem = this.stackResult[index].recipeItem.func_77973_b();
            Item containerItem = recipeItem.func_77668_q();
            if (containerItem == null) {
                return ItemStack.func_179545_c((ItemStack)this.stackResult[index].recipeItem, (ItemStack)stack);
            }
            return stack.func_77973_b() == containerItem;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.stackResult.length; ++i) {
            if (this.stackResult[i].recipeItem == null && this.stackResult[i].containerItem == null) continue;
            return false;
        }
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.stackResult.length; ++i) {
            this.stackResult[i].recipeItem = null;
            this.stackResult[i].containerItem = null;
        }
    }

    public void clear(StackType stackType) {
        switch (stackType) {
            case RECIPE: {
                for (int i = 0; i < this.stackResult.length; ++i) {
                    this.stackResult[i].recipeItem = null;
                }
                break;
            }
            case CONTAINER: {
                for (int i = 0; i < this.stackResult.length; ++i) {
                    this.stackResult[i].containerItem = null;
                }
                break;
            }
        }
    }

    public boolean missingContainerItems() {
        for (int index = 0; index < this.stackResult.length; ++index) {
            if (this.stackResult[index].recipeItem == null || !this.stackResult[index].recipeItem.func_77973_b().hasContainerItem(this.stackResult[index].recipeItem) || this.stackResult[index].containerItem != null) continue;
            return true;
        }
        return false;
    }

    public int missingContainerItemCount() {
        int count = 0;
        for (int index = 0; index < this.stackResult.length; ++index) {
            if (this.stackResult[index].recipeItem == null || !this.stackResult[index].recipeItem.func_77973_b().hasContainerItem(this.stackResult[index].recipeItem) || this.stackResult[index].containerItem != null) continue;
            ++count;
        }
        return count;
    }

    private class ItemStackPair {
        private ItemStack recipeItem;
        private ItemStack containerItem;

        private ItemStackPair() {
        }
    }

    public static enum StackType {
        RECIPE,
        CONTAINER;

    }
}

