/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.inventory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jglrxavpok.mods.decraft.event.ItemUncraftedEvent;
import org.jglrxavpok.mods.decraft.inventory.InventoryUncraftResult;
import org.jglrxavpok.mods.decraft.inventory.SlotBook;
import org.jglrxavpok.mods.decraft.inventory.SlotUncraftResult;
import org.jglrxavpok.mods.decraft.inventory.SlotUncrafting;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingManager;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingResult;

public class ContainerUncraftingTable
extends Container {
    public InventoryBasic calculInput = new InventoryBasic(null, false, 1);
    public InventoryCrafting uncraftIn = new InventoryCrafting((Container)this, 1, 1);
    public InventoryUncraftResult uncraftOut = new InventoryUncraftResult(this);
    private InventoryPlayer playerInventory;
    private World world;
    public UncraftingResult uncraftingResult = new UncraftingResult();

    public ContainerUncraftingTable(InventoryPlayer playerInventory, World world) {
        int col;
        int row;
        this.playerInventory = playerInventory;
        this.world = world;
        this.func_75146_a(new SlotBook((IInventory)this.calculInput, 0, 20, 35, this));
        this.func_75146_a(new SlotUncrafting((IInventory)this.uncraftIn, 0, 45, 35, this));
        int offsetX = 106;
        int offsetY = 17;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.func_75146_a(new SlotUncraftResult(this.uncraftOut, col + row * 3, offsetX + col * 18, offsetY + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, col2, 8 + col2 * 18, 142));
        }
    }

    private void populateOutputInventory() {
        this.uncraftOut.clear(InventoryUncraftResult.StackType.RECIPE);
        if (this.uncraftingResult.resultType != UncraftingResult.ResultType.VALID && !this.uncraftOut.isEmpty()) {
            this.returnContainerItemsToPlayer();
        }
        int minStackSize = this.uncraftingResult.getMinStackSize();
        ItemStack[] craftingGrid = this.uncraftingResult.getCraftingGrid();
        int multiplier = this.uncraftIn.func_70301_a((int)0).field_77994_a / minStackSize;
        for (int index = 0; index < craftingGrid.length; ++index) {
            if (craftingGrid[index] != null) {
                if (this.uncraftingResult.resultType != UncraftingResult.ResultType.VALID && (this.uncraftingResult.resultType != UncraftingResult.ResultType.NEED_CONTAINER_ITEMS || !craftingGrid[index].func_77973_b().hasContainerItem(craftingGrid[index]))) continue;
                int amount = craftingGrid[index].field_77994_a * multiplier;
                if (amount > craftingGrid[index].func_77976_d()) {
                    amount = craftingGrid[index].func_77976_d();
                }
                ItemStack newStack = new ItemStack(craftingGrid[index].func_77973_b(), amount, craftingGrid[index].func_77952_i());
                if (craftingGrid[index].func_77942_o()) {
                    newStack.func_77982_d(craftingGrid[index].func_77978_p());
                }
                this.uncraftOut.setInventorySlotContents(index, newStack, InventoryUncraftResult.StackType.RECIPE);
                continue;
            }
            this.uncraftOut.setInventorySlotContents(index, null, InventoryUncraftResult.StackType.RECIPE);
        }
    }

    private void doUncraft() {
        if (!this.playerInventory.field_70458_d.field_71075_bZ.field_75098_d) {
            if (this.playerInventory.field_70458_d.field_71068_ca < this.uncraftingResult.experienceCost) {
                this.uncraftingResult.resultType = UncraftingResult.ResultType.NOT_ENOUGH_XP;
                return;
            }
            this.playerInventory.field_70458_d.field_71068_ca -= this.uncraftingResult.experienceCost;
        }
        if (this.uncraftIn.func_70301_a(0).func_77948_v() && this.calculInput.func_70301_a(0) != null && this.calculInput.func_70301_a(0).func_77973_b() == Items.field_151122_aG) {
            List<ItemStack> enchantedBooks = this.getItemEnchantments(this.uncraftIn.func_70301_a(0), this.calculInput.func_70301_a(0));
            for (ItemStack enchantedBook : enchantedBooks) {
                if (this.playerInventory.func_70441_a(enchantedBook)) continue;
                this.playerInventory.field_70458_d.func_71019_a(enchantedBook, false);
            }
            this.calculInput.func_70298_a(0, enchantedBooks.size());
        }
        int minStackSize = this.uncraftingResult.getMinStackSize();
        ItemStack[] craftingGrid = this.uncraftingResult.getCraftingGrid();
        int multiplier = this.uncraftIn.func_70301_a((int)0).field_77994_a / minStackSize;
        MinecraftForge.EVENT_BUS.post((Event)new ItemUncraftedEvent(this.playerInventory.field_70458_d, this.uncraftIn.func_70301_a(0), minStackSize * multiplier));
        this.uncraftingResult.resultType = UncraftingResult.ResultType.UNCRAFTED;
        this.uncraftIn.func_70298_a(0, minStackSize * multiplier);
        this.func_75139_a(1).func_75218_e();
    }

    private List<ItemStack> getItemEnchantments(ItemStack itemStack, ItemStack containerItems) {
        ArrayList<ItemStack> enchantedBooks = new ArrayList<ItemStack>();
        if (itemStack.func_77948_v() && containerItems != null && containerItems.func_77973_b() == Items.field_151122_aG) {
            Map itemEnchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
            if (itemEnchantments.size() > 1 && itemEnchantments.size() <= containerItems.field_77994_a) {
                for (Enchantment bookEnchantment : itemEnchantments.keySet()) {
                    LinkedHashMap<Enchantment, Integer> bookEnchantments = new LinkedHashMap<Enchantment, Integer>();
                    bookEnchantments.put(bookEnchantment, (Integer)itemEnchantments.get(bookEnchantment));
                    ItemStack enchantedBook = new ItemStack((Item)Items.field_151134_bR, 1);
                    EnchantmentHelper.func_82782_a(bookEnchantments, (ItemStack)enchantedBook);
                    enchantedBooks.add(enchantedBook);
                    bookEnchantments.clear();
                }
            } else {
                ItemStack enchantedBook = new ItemStack((Item)Items.field_151134_bR, 1);
                EnchantmentHelper.func_82782_a((Map)itemEnchantments, (ItemStack)enchantedBook);
                enchantedBooks.add(enchantedBook);
            }
        }
        return enchantedBooks;
    }

    private void returnContainerItemsToPlayer() {
        for (int i = 0; i < this.uncraftOut.func_70302_i_(); ++i) {
            ItemStack stack = this.uncraftOut.getStackInSlot(i, InventoryUncraftResult.StackType.CONTAINER);
            if (stack == null || this.playerInventory.func_70441_a(stack)) continue;
            this.playerInventory.field_70458_d.func_71019_a(stack, false);
        }
        this.uncraftOut.clear(InventoryUncraftResult.StackType.CONTAINER);
    }

    private void returnUncraftingOutputItemsToPlayer() {
        for (int i = 0; i < this.uncraftOut.func_70302_i_(); ++i) {
            ItemStack stack = this.uncraftOut.getStackInSlot(i, InventoryUncraftResult.StackType.RECIPE);
            if (stack == null || this.playerInventory.func_70441_a(stack)) continue;
            this.playerInventory.field_70458_d.func_71019_a(stack, false);
        }
        this.uncraftOut.clear(InventoryUncraftResult.StackType.RECIPE);
    }

    public void switchRecipe() {
        this.uncraftOut.clear(InventoryUncraftResult.StackType.RECIPE);
        if (!this.uncraftOut.isEmpty()) {
            this.returnContainerItemsToPlayer();
        }
        UncraftingManager.recalculateResultType(this.uncraftingResult, this.playerInventory.field_70458_d, this.uncraftIn.func_70301_a(0));
        if (this.uncraftingResult.canPopulateInventory()) {
            this.populateOutputInventory();
        }
    }

    public void onInputItemChanged() {
        ItemStack inputStack = this.uncraftIn.func_70301_a(0);
        if (inputStack != null) {
            if (this.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED && !this.uncraftOut.isEmpty()) {
                this.returnUncraftingOutputItemsToPlayer();
            }
            this.uncraftingResult = UncraftingManager.getUncraftingResult(this.playerInventory.field_70458_d, inputStack);
            this.uncraftingResult.experienceCost = UncraftingManager.recalculateExperienceCost(inputStack, this.calculInput.func_70301_a(0));
        }
        this.func_75130_a((IInventory)this.uncraftIn);
    }

    public void func_75130_a(IInventory inventory) {
        if (inventory == this.calculInput) {
            this.uncraftingResult.experienceCost = UncraftingManager.recalculateExperienceCost(this.uncraftIn.func_70301_a(0), this.calculInput.func_70301_a(0));
        } else {
            if (inventory == this.uncraftIn) {
                ItemStack inputStack = this.uncraftIn.func_70301_a(0);
                if (inputStack == null) {
                    if (this.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED && this.uncraftOut.isEmpty()) {
                        this.uncraftingResult = new UncraftingResult();
                    }
                    if (this.uncraftingResult.resultType != UncraftingResult.ResultType.UNCRAFTED) {
                        this.uncraftOut.clear(InventoryUncraftResult.StackType.RECIPE);
                        this.uncraftingResult = new UncraftingResult();
                    }
                } else if (this.uncraftingResult.resultType != UncraftingResult.ResultType.UNCRAFTED) {
                    if (this.uncraftingResult.resultType == UncraftingResult.ResultType.INACTIVE) {
                        this.uncraftingResult = UncraftingManager.getUncraftingResult(this.playerInventory.field_70458_d, inputStack);
                    } else {
                        UncraftingManager.recalculateResultType(this.uncraftingResult, this.playerInventory.field_70458_d, inputStack);
                    }
                    if (this.uncraftingResult.canPopulateInventory()) {
                        this.populateOutputInventory();
                    } else {
                        this.uncraftOut.clear(InventoryUncraftResult.StackType.RECIPE);
                        if (!this.uncraftOut.isEmpty()) {
                            this.returnContainerItemsToPlayer();
                        }
                    }
                }
                return;
            }
            if (inventory == this.uncraftOut) {
                if (this.uncraftingResult.resultType == UncraftingResult.ResultType.NEED_CONTAINER_ITEMS && !this.uncraftOut.missingContainerItems()) {
                    this.uncraftingResult.resultType = UncraftingResult.ResultType.VALID;
                    this.populateOutputInventory();
                } else if (this.uncraftingResult.resultType == UncraftingResult.ResultType.VALID) {
                    this.doUncraft();
                } else if (this.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED) {
                    this.uncraftOut.clear(InventoryUncraftResult.StackType.CONTAINER);
                }
                if (this.uncraftOut.isEmpty()) {
                    if (this.uncraftIn.func_70301_a(0) == null) {
                        this.uncraftingResult = new UncraftingResult();
                    } else {
                        UncraftingManager.recalculateResultType(this.uncraftingResult, this.playerInventory.field_70458_d, this.uncraftIn.func_70301_a(0));
                    }
                }
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            ItemStack itemstack = this.calculInput.func_70304_b(0);
            if (itemstack != null) {
                player.func_71019_a(itemstack, false);
            }
            if ((itemstack = this.uncraftIn.func_70304_b(0)) != null) {
                player.func_71019_a(itemstack, false);
            }
            for (int i = 0; i < this.uncraftOut.func_70302_i_(); ++i) {
                itemstack = this.uncraftOut.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            if (slot.field_75224_c.equals(this.calculInput)) {
                if (!this.playerInventory.func_70441_a(slot.func_75211_c())) {
                    return null;
                }
                slot.func_75215_d(null);
            } else if (slot.field_75224_c.equals(this.uncraftIn)) {
                if (!this.playerInventory.func_70441_a(slot.func_75211_c())) {
                    return null;
                }
                slot.func_75215_d(null);
            } else if (slot.field_75224_c.equals(this.uncraftOut)) {
                if (this.uncraftingResult.resultType == UncraftingResult.ResultType.VALID) {
                    this.doUncraft();
                }
                if (this.uncraftOut.isEmpty()) {
                    this.uncraftingResult = new UncraftingResult();
                    if (this.uncraftIn.func_70301_a(0) != null) {
                        this.func_75130_a((IInventory)this.uncraftIn);
                    }
                }
                if (this.uncraftingResult.resultType == UncraftingResult.ResultType.UNCRAFTED) {
                    ItemStack stack1 = this.uncraftOut.getStackInSlot(slot.getSlotIndex(), InventoryUncraftResult.StackType.RECIPE);
                    ItemStack stack = stack1.func_77946_l();
                    if (!this.func_75135_a(stack1, 11, 47, true)) {
                        return null;
                    }
                    slot.func_75215_d(null);
                    return stack;
                }
                ItemStack stack = this.uncraftOut.getStackInSlot(slot.getSlotIndex(), InventoryUncraftResult.StackType.CONTAINER);
                if (!this.playerInventory.func_70441_a(stack)) {
                    return null;
                }
                this.uncraftOut.setInventorySlotContents(slot.getSlotIndex(), null, InventoryUncraftResult.StackType.CONTAINER);
            } else if (slot.field_75224_c.equals(this.playerInventory)) {
                int targetIndex = slot.func_75211_c().func_77973_b() == Items.field_151122_aG ? 0 : 1;
                Slot targetSlot = (Slot)this.field_75151_b.get(index);
                if (targetSlot.func_75211_c() == null) {
                    targetSlot.func_75215_d(slot.func_75211_c());
                    slot.func_75215_d(null);
                } else {
                    ItemStack itemstack1 = slot.func_75211_c();
                    ItemStack itemstack = itemstack1.func_77946_l();
                    if (!this.func_75135_a(itemstack1, targetIndex, targetIndex + 1, false)) {
                        return null;
                    }
                    if (itemstack1.field_77994_a == 0) {
                        slot.func_75215_d(null);
                    } else {
                        slot.func_75218_e();
                    }
                    if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                        return null;
                    }
                    slot.func_82870_a(player, itemstack1);
                    return itemstack;
                }
            }
        }
        return null;
    }

    public void func_75141_a(int slotId, ItemStack stack) {
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return !slotIn.field_75224_c.equals(this.uncraftOut);
    }
}

