/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.init;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jglrxavpok.mods.decraft.common.config.ModConfiguration;
import org.jglrxavpok.mods.decraft.item.ItemNugget;

@Mod.EventBusSubscriber
public class ModItems {
    public static final Item NUGGET = ((Item)new ItemNugget().setRegistryName("nugget")).func_77655_b("nugget");

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        if (!ModConfiguration.registerNuggets) {
            return;
        }
        event.getRegistry().register((IForgeRegistryEntry)NUGGET);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        if (!ModConfiguration.registerNuggets) {
            return;
        }
        for (ItemNugget.EnumNuggetType nuggetType : ItemNugget.EnumNuggetType.values()) {
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("uncraftingTable:" + nuggetType.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)NUGGET, (int)nuggetType.getMetadata(), (ModelResourceLocation)itemModelResourceLocation);
        }
    }

    public static void registerOreDictionaryEntries() {
        if (!ModConfiguration.registerNuggets) {
            return;
        }
        OreDictionary.registerOre((String)"nuggetDiamond", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.DIAMOND.getMetadata()));
        OreDictionary.registerOre((String)"shardDiamond", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.DIAMOND.getMetadata()));
        OreDictionary.registerOre((String)"nuggetEmerald", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.EMERALD.getMetadata()));
        OreDictionary.registerOre((String)"shardEmerald", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.EMERALD.getMetadata()));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.IRON.getMetadata()));
        OreDictionary.registerOre((String)"nuggetLeather", (ItemStack)new ItemStack(NUGGET, 1, ItemNugget.EnumNuggetType.LEATHER.getMetadata()));
    }

    public static void registerCraftingRecipes() {
        if (!ModConfiguration.registerNuggets) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NUGGET, 9, ItemNugget.EnumNuggetType.DIAMOND.getMetadata()), new Object[]{Items.field_151045_i}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NUGGET, 9, ItemNugget.EnumNuggetType.EMERALD.getMetadata()), new Object[]{Items.field_151166_bC}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NUGGET, 9, ItemNugget.EnumNuggetType.IRON.getMetadata()), new Object[]{Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(NUGGET, 9, ItemNugget.EnumNuggetType.LEATHER.getMetadata()), new Object[]{Items.field_151116_aA}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Items.field_151045_i, new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), "nuggetDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Items.field_151166_bC, new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), "nuggetEmerald"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Items.field_151042_j, new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), "nuggetIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Items.field_151116_aA, new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), "nuggetLeather"}));
    }
}

