/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.common.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.common.config.ModConfiguration;

public class ConfigSyncMessage
implements IMessage {
    private int standardLevel = ModConfiguration.standardLevel;
    private int maxUsedLevel = ModConfiguration.maxUsedLevel;
    private int enchantmentCost = ModConfiguration.enchantmentCost;
    private int uncraftMethod = ModConfiguration.uncraftMethod;
    private String[] excludedItems = ModConfiguration.excludedItems;
    private boolean useNuggets = ModConfiguration.useNuggets;
    private boolean registerNuggets = ModConfiguration.registerNuggets;
    private boolean useRabbitHide = ModConfiguration.useRabbitHide;
    private boolean ensureReturn = ModConfiguration.ensureReturn;

    public void fromBytes(ByteBuf buf) {
        this.standardLevel = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.maxUsedLevel = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.enchantmentCost = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.uncraftMethod = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.excludedItems = ByteBufUtils.readUTF8String((ByteBuf)buf).split("\\|");
        this.useNuggets = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
        this.registerNuggets = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
        this.useRabbitHide = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
        this.ensureReturn = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.standardLevel);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.maxUsedLevel);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.enchantmentCost);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.uncraftMethod);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)String.join((CharSequence)"|", this.excludedItems));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.useNuggets ? 1 : 0));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.registerNuggets ? 1 : 0));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.useRabbitHide ? 1 : 0));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.ensureReturn ? 1 : 0));
    }

    public static final class MessageHandler
    implements IMessageHandler<ConfigSyncMessage, IMessage> {
        private IThreadListener getThreadListener(MessageContext ctx) {
            try {
                if (ctx.side == Side.SERVER) {
                    return (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                }
                if (ctx.side == Side.CLIENT) {
                    return Minecraft.func_71410_x();
                }
                return null;
            }
            catch (Exception ex) {
                ModUncrafting.LOGGER.catching((Throwable)ex);
                return null;
            }
        }

        public IMessage onMessage(final ConfigSyncMessage message, MessageContext ctx) {
            IThreadListener threadListener = this.getThreadListener(ctx);
            threadListener.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ModConfiguration.maxUsedLevel = message.maxUsedLevel;
                    ModConfiguration.standardLevel = message.standardLevel;
                    ModConfiguration.enchantmentCost = message.enchantmentCost;
                    ModConfiguration.uncraftMethod = message.uncraftMethod;
                    ModConfiguration.excludedItems = message.excludedItems;
                    ModConfiguration.useNuggets = message.useNuggets;
                    ModConfiguration.registerNuggets = message.registerNuggets;
                    ModConfiguration.useRabbitHide = message.useRabbitHide;
                    ModConfiguration.ensureReturn = message.ensureReturn;
                }
            });
            return null;
        }
    }
}

