/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.common.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.IOUtils;
import org.jglrxavpok.mods.decraft.ModUncrafting;

public class ModJsonConfiguration {
    public static final ItemMappingMap ITEM_MAPPINGS = new ItemMappingMap();

    public static void loadItemMappings() {
        String fileContents = ModJsonConfiguration.readFileContentsFromMod("assets/" + "uncraftingTable".toLowerCase() + "/data/item-mappings.json");
        JsonObject jsonObject = new JsonParser().parse(fileContents).getAsJsonObject();
        Gson gson = new Gson();
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            ItemMapping itemMapping = new ItemMapping();
            String itemName = (String)entry.getKey();
            JsonObject jsonMapping = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (jsonMapping.has("singleRecipe")) {
                itemMapping.singleRecipe = jsonMapping.get("singleRecipe").getAsBoolean();
            }
            if (jsonMapping.has("recipeType")) {
                itemMapping.recipeType = jsonMapping.get("recipeType").getAsString();
            }
            if (jsonMapping.has("replaceSlots")) {
                itemMapping.replaceSlots = (int[])gson.fromJson((JsonElement)jsonMapping.get("replaceSlots").getAsJsonArray(), int[].class);
            }
            if (jsonMapping.has("matchTag")) {
                itemMapping.matchTag = jsonMapping.get("matchTag").getAsBoolean();
            }
            if (jsonMapping.has("tagName")) {
                itemMapping.tagName = jsonMapping.get("tagName").getAsString();
            }
            if (jsonMapping.has("matchField")) {
                itemMapping.matchField = jsonMapping.get("matchField").getAsBoolean();
            }
            if (jsonMapping.has("fieldNames")) {
                itemMapping.fieldNames = (String[])gson.fromJson((JsonElement)jsonMapping.get("fieldNames").getAsJsonArray(), String[].class);
            }
            ITEM_MAPPINGS.put(itemName, itemMapping);
        }
    }

    private static String readFileContentsFromMod(String fileName) {
        String fileContents = "";
        try {
            InputStream stream = ModUncrafting.instance.getClass().getClassLoader().getResourceAsStream(fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            fileContents = IOUtils.toString((InputStream)stream);
            reader.close();
            stream.close();
        }
        catch (Exception ex) {
            ModUncrafting.LOGGER.catching((Throwable)ex);
        }
        return fileContents;
    }

    public static class ItemMappingMap
    extends HashMap<String, ItemMapping> {
        public ItemMapping get(ItemStack stack) {
            String registryName = stack.func_77973_b().getRegistryName().toString();
            int meta = stack.func_77960_j();
            ItemMapping result = (ItemMapping)this.get(registryName + "," + meta);
            if (result == null) {
                result = (ItemMapping)this.get(registryName);
            }
            return result;
        }
    }

    public static class ItemMapping {
        public boolean singleRecipe = false;
        public String recipeType = null;
        public int[] replaceSlots = null;
        public boolean matchTag = false;
        public String tagName = null;
        public boolean matchField = false;
        public String[] fieldNames = null;
    }
}

