/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.common.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.client.config.ModGuiConfigEntries;
import org.jglrxavpok.mods.decraft.common.network.message.ConfigSyncMessage;

public class ModConfiguration {
    private static Configuration config = null;
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_NUGGETS = "nuggets";
    public static int standardLevel = 5;
    public static int maxUsedLevel = 30;
    public static int enchantmentCost = 1;
    public static int uncraftMethod = 0;
    public static String[] excludedItems = DefaultValues.access$000();
    public static boolean useNuggets = true;
    public static boolean registerNuggets = true;
    public static boolean useRabbitHide = false;
    public static boolean ensureReturn = true;

    public static Configuration getConfig() {
        return config;
    }

    public static void initializeConfiguration() {
        File configFile = new File(Loader.instance().getConfigDir(), "uncraftingTable.cfg");
        config = new Configuration(configFile);
        config.load();
        ModConfiguration.syncFromFile();
    }

    public static void syncFromFile() {
        ModConfiguration.syncConfig(true, true);
    }

    public static void syncFromGUI() {
        ModConfiguration.syncConfig(false, true);
    }

    private static void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            config.load();
        }
        Property propStandardLevel = config.get(CATEGORY_GENERAL, "standardLevel", 5, "Minimum required level to uncraft an item", 0, 50);
        propStandardLevel.setLanguageKey("uncrafting.options.standardLevel");
        propStandardLevel.setRequiresMcRestart(false);
        Property propMaxLevel = config.get(CATEGORY_GENERAL, "maxUsedLevel", 30, "Maximum required level to uncraft an item", 0, 50);
        propMaxLevel.setLanguageKey("uncrafting.options.maxUsedLevel");
        propMaxLevel.setRequiresMcRestart(false);
        Property propEnchantmentCost = config.get(CATEGORY_GENERAL, "enchantmentCost", 1, "Cost per enchantment when removing enchantments onto books", 0, 10);
        propEnchantmentCost.setLanguageKey("uncrafting.options.enchantmentCost");
        propEnchantmentCost.setRequiresMcRestart(false);
        Property propUncraftMethod = config.get(CATEGORY_GENERAL, "uncraftMethod", 0, "ID of the used uncrafting equation.");
        propUncraftMethod.setLanguageKey("uncrafting.options.method");
        propUncraftMethod.setValidValues(new String[]{"jglrxavpok", "Xell75 & zenen"});
        propUncraftMethod.setRequiresMcRestart(false);
        Property propExcludedItems = config.get(CATEGORY_GENERAL, "excludedItems", DefaultValues.excludedItems, "List of items which cannot be uncrafted");
        propExcludedItems.setLanguageKey("uncrafting.options.excludedItems");
        propExcludedItems.setRequiresMcRestart(false);
        Property propUseNuggets = config.get(CATEGORY_NUGGETS, "useNuggets", true, "Use available nuggets for partial returns of damaged items");
        propUseNuggets.setLanguageKey("uncrafting.options.nuggets.useNuggets");
        propUseNuggets.setRequiresMcRestart(false);
        Property propRegisterNuggets = config.get(CATEGORY_NUGGETS, "registerNuggets", true, "Register additional nuggets to use for partial returns of damaged Vanilla items");
        propRegisterNuggets.setLanguageKey("uncrafting.options.nuggets.registerNuggets");
        propRegisterNuggets.setRequiresMcRestart(true);
        Property propUseRabbitHide = config.get(CATEGORY_NUGGETS, "useRabbitHide", false, "Use Rabbit Hide for partial returns of damaged Leather items");
        propUseRabbitHide.setLanguageKey("uncrafting.options.nuggets.useRabbitHide");
        propUseRabbitHide.setRequiresMcRestart(false);
        Property propEnsureReturn = config.get(CATEGORY_NUGGETS, "ensureReturn", true, "Ensure that at least one nugget is returned, even for items with 0% durability");
        propEnsureReturn.setLanguageKey("uncrafting.options.nuggets.ensureReturn");
        propEnsureReturn.setRequiresMcRestart(false);
        ArrayList<String> propOrderGeneral = new ArrayList<String>();
        propOrderGeneral.add(propStandardLevel.getName());
        propOrderGeneral.add(propMaxLevel.getName());
        propOrderGeneral.add(propEnchantmentCost.getName());
        propOrderGeneral.add(propUncraftMethod.getName());
        propOrderGeneral.add(propExcludedItems.getName());
        config.setCategoryPropertyOrder(CATEGORY_GENERAL, propOrderGeneral);
        ArrayList<String> propOrderNuggets = new ArrayList<String>();
        propOrderNuggets.add(propUseNuggets.getName());
        propOrderNuggets.add(propRegisterNuggets.getName());
        propOrderNuggets.add(propUseRabbitHide.getName());
        propOrderNuggets.add(propEnsureReturn.getName());
        config.setCategoryPropertyOrder(CATEGORY_NUGGETS, propOrderNuggets);
        try {
            propStandardLevel.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
            propMaxLevel.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
            propEnchantmentCost.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
            propUncraftMethod.setConfigEntryClass(ModGuiConfigEntries.UncraftingMethodCycleEntry.class);
            propExcludedItems.setConfigEntryClass(ModGuiConfigEntries.ExcludedItemsArrayEntry.class);
            propUseNuggets.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            propRegisterNuggets.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            propUseRabbitHide.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            propEnsureReturn.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (readFieldsFromConfig) {
            standardLevel = propStandardLevel.getInt();
            maxUsedLevel = propMaxLevel.getInt();
            enchantmentCost = propEnchantmentCost.getInt();
            uncraftMethod = propUncraftMethod.getInt();
            excludedItems = propExcludedItems.getStringList();
            useNuggets = propUseNuggets.getBoolean();
            registerNuggets = propRegisterNuggets.getBoolean();
            useRabbitHide = propUseRabbitHide.getBoolean();
            ensureReturn = propEnsureReturn.getBoolean();
        }
        propStandardLevel.set(standardLevel);
        propMaxLevel.set(maxUsedLevel);
        propEnchantmentCost.set(enchantmentCost);
        propUncraftMethod.set(uncraftMethod);
        propExcludedItems.set(excludedItems);
        propUseNuggets.set(useNuggets);
        propRegisterNuggets.set(registerNuggets);
        propUseRabbitHide.set(useRabbitHide);
        propEnsureReturn.set(ensureReturn);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventBusSubscriber
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.player.field_70170_p.field_72995_K) {
                ModUncrafting.NETWORK.sendTo((IMessage)new ConfigSyncMessage(), (EntityPlayerMP)event.player);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("uncraftingTable") && (!event.isWorldRunning() || Minecraft.func_71410_x().func_71356_B())) {
                ModConfiguration.syncFromGUI();
                if (event.isWorldRunning() && Minecraft.func_71410_x().func_71356_B()) {
                    ModUncrafting.NETWORK.sendToServer((IMessage)new ConfigSyncMessage());
                }
            }
        }
    }

    private static class DefaultValues {
        private static final int standardLevel = 5;
        private static final int maxUsedLevel = 30;
        private static final int enchantmentCost = 1;
        private static final int uncraftMethod = 0;
        private static final String[] excludedItems = new String[0];
        private static final boolean useNuggets = true;
        private static final boolean registerNuggets = true;
        private static final boolean useRabbitHide = false;
        private static final boolean ensureReturn = true;

        private DefaultValues() {
        }
    }
}

