/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.client.gui.inventory;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jglrxavpok.mods.decraft.ModUncrafting;
import org.jglrxavpok.mods.decraft.common.network.message.RecipeNavigationMessage;
import org.jglrxavpok.mods.decraft.inventory.ContainerUncraftingTable;
import org.jglrxavpok.mods.decraft.item.uncrafting.UncraftingResult;
import org.lwjgl.opengl.GL11;

public class GuiUncraftingTable
extends GuiContainer {
    private static final ResourceLocation UNCRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("uncraftingTable", "textures/gui/container/uncrafting_table.png");
    public ContainerUncraftingTable container;
    private World worldObj;
    private EntityPlayer player;
    private GuiButton previousRecipeButton;
    private GuiButton nextRecipeButton;

    public GuiUncraftingTable(InventoryPlayer playerInventory, World world) {
        super((Container)new ContainerUncraftingTable(playerInventory, world));
        this.container = (ContainerUncraftingTable)this.field_147002_h;
        this.worldObj = world;
        this.player = playerInventory.field_70458_d;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        this.nextRecipeButton = new GuiButton(1, guiX + 162, guiY + 20, ButtonFacing.RIGHT);
        this.field_146292_n.add(this.nextRecipeButton);
        this.previousRecipeButton = new GuiButton(2, guiX + 95, guiY + 20, ButtonFacing.LEFT);
        this.field_146292_n.add(this.previousRecipeButton);
        this.previousRecipeButton.field_146125_m = false;
        this.nextRecipeButton.field_146125_m = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        boolean haveMultipleRecipes = this.container.uncraftingResult.getRecipeCount() > 1;
        boolean hasNextRecipe = this.container.uncraftingResult.selectedCraftingGrid < this.container.uncraftingResult.getRecipeCount() - 1;
        boolean hasPreviousRecipe = this.container.uncraftingResult.selectedCraftingGrid > 0;
        boolean canChangeRecipe = this.container.uncraftingResult.resultType != UncraftingResult.ResultType.UNCRAFTED;
        this.nextRecipeButton.field_146124_l = this.nextRecipeButton.field_146125_m = haveMultipleRecipes && canChangeRecipe && hasNextRecipe;
        this.previousRecipeButton.field_146125_m = haveMultipleRecipes && canChangeRecipe && hasPreviousRecipe;
        this.nextRecipeButton.field_146124_l = this.nextRecipeButton.field_146125_m;
    }

    protected void func_146284_a(net.minecraft.client.gui.GuiButton button) {
        if (button == this.previousRecipeButton || button == this.nextRecipeButton) {
            if (button == this.previousRecipeButton) {
                if (this.container.uncraftingResult.selectedCraftingGrid == 0) {
                    return;
                }
                --this.container.uncraftingResult.selectedCraftingGrid;
            }
            if (button == this.nextRecipeButton) {
                if (this.container.uncraftingResult.selectedCraftingGrid == this.container.uncraftingResult.getRecipeCount() - 1) {
                    return;
                }
                ++this.container.uncraftingResult.selectedCraftingGrid;
            }
            this.container.switchRecipe();
            int recipeIndex = this.container.uncraftingResult.selectedCraftingGrid;
            ModUncrafting.NETWORK.sendToServer((IMessage)new RecipeNavigationMessage(recipeIndex));
        }
    }

    private void drawUncraftingStatusMessage() {
        String statusMessage = "";
        int quantityNeeded = 0;
        switch (this.container.uncraftingResult.resultType) {
            case VALID: {
                if (this.container.uncraftingResult.experienceCost <= 0) break;
                statusMessage = I18n.func_135052_a((String)"container.uncrafting.cost", (Object[])new Object[]{this.container.uncraftingResult.experienceCost});
                break;
            }
            case NOT_UNCRAFTABLE: {
                statusMessage = I18n.func_135052_a((String)"uncrafting.result.impossible", (Object[])new Object[0]);
                break;
            }
            case NOT_ENOUGH_ITEMS: {
                quantityNeeded = this.container.uncraftingResult.getMinStackSize() - this.container.uncraftIn.func_70301_a((int)0).field_77994_a;
                statusMessage = I18n.func_135052_a((String)"uncrafting.result.needMoreStacks", (Object[])new Object[]{quantityNeeded});
                break;
            }
            case NOT_ENOUGH_XP: {
                statusMessage = I18n.func_135052_a((String)"container.uncrafting.cost", (Object[])new Object[]{this.container.uncraftingResult.experienceCost});
                break;
            }
            case NEED_CONTAINER_ITEMS: {
                quantityNeeded = this.container.uncraftOut.missingContainerItemCount();
                statusMessage = I18n.func_135052_a((String)"uncrafting.result.needMoreStacks", (Object[])new Object[]{quantityNeeded});
                break;
            }
        }
        if (!statusMessage.equals("")) {
            int textX = 8;
            int textY = this.field_147000_g - 96 + 2 - this.field_146289_q.field_78288_b - 4;
            int textColor = this.container.uncraftingResult.isError() ? 0xFF6060 : 8453920;
            int shadowColor = 0xFF000000 | (textColor & 0xFCFCFC) >> 2 | textColor & 0xFF000000;
            this.field_146289_q.func_78276_b(statusMessage, textX, textY + 1, shadowColor);
            this.field_146289_q.func_78276_b(statusMessage, textX + 1, textY, shadowColor);
            this.field_146289_q.func_78276_b(statusMessage, textX + 1, textY + 1, shadowColor);
            this.field_146289_q.func_78276_b(statusMessage, textX, textY, textColor);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        String title = I18n.func_135052_a((String)"container.uncrafting", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.drawUncraftingStatusMessage();
        GlStateManager.func_179145_e();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(UNCRAFTING_TABLE_GUI_TEXTURES);
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiX, guiY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.container.uncraftingResult.isError()) {
            this.func_73729_b(guiX + 71, guiY + 33, 176, 0, 28, 21);
        }
        RenderHelper.func_74520_c();
        int slotX = 20;
        int slotY = 35;
        this.field_146296_j.func_175042_a(new ItemStack(Items.field_151122_aG), guiX + slotX, guiY + slotY);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GuiUncraftingTable.func_73734_a((int)(guiX + slotX), (int)(guiY + slotY), (int)(guiX + slotX + 16), (int)(guiY + slotY + 16), (int)-1618244725);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        if (this.container.uncraftingResult.renderBackgroundItems()) {
            ItemStack[] craftingGrid = this.container.uncraftingResult.getCraftingGrid();
            for (int i = 0; i < craftingGrid.length; ++i) {
                ItemStack itemStack = craftingGrid[i];
                if (itemStack == null) continue;
                Slot renderSlot = this.container.func_75147_a(this.container.uncraftOut, i);
                slotX = renderSlot.field_75223_e;
                slotY = renderSlot.field_75221_f;
                if (renderSlot.func_75216_d()) continue;
                this.field_146296_j.func_180450_b(itemStack, guiX + slotX, guiY + slotY);
                if (itemStack.field_77994_a > 1) {
                    this.field_146296_j.func_180453_a(this.field_146289_q, itemStack, guiX + slotX, guiY + slotY, String.valueOf(itemStack.field_77994_a));
                }
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int color = -1618244725;
                if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                    Item slotItem;
                    Item containerItem = itemStack.func_77973_b().func_77668_q();
                    Item item = slotItem = renderSlot.func_75216_d() ? renderSlot.func_75211_c().func_77973_b() : null;
                    if (slotItem == null || slotItem != null && containerItem != slotItem) {
                        color = -2130736245;
                    }
                }
                GuiUncraftingTable.func_73734_a((int)(guiX + slotX), (int)(guiY + slotY), (int)(guiX + slotX + 16), (int)(guiY + slotY + 16), (int)color);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private static enum ButtonFacing {
        LEFT,
        RIGHT;

    }

    private class GuiButton
    extends net.minecraft.client.gui.GuiButton {
        private final ButtonFacing facing;

        public GuiButton(int buttonId, int x, int y, ButtonFacing facing) {
            super(buttonId, x, y, 7, 11, "");
            this.facing = facing;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(UNCRAFTING_TABLE_GUI_TEXTURES);
                boolean mouseOnButton = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int textureX = this.facing == ButtonFacing.LEFT ? 177 : 185;
                int textureY = mouseOnButton ? 35 : 23;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, this.field_146120_f, this.field_146121_g);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
            }
        }
    }
}

