/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.mods.decraft.client.config;

import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModGuiConfigEntries {

    public static class UncraftingMethodCycleEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final int beforeIndex;
        protected final int defaultIndex;
        protected int currentIndex;

        public UncraftingMethodCycleEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeIndex = Integer.valueOf((String)configElement.get());
            this.defaultIndex = Integer.valueOf((String)configElement.getDefault());
            this.currentIndex = this.beforeIndex;
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.configElement.getValidValues()[this.currentIndex];
        }

        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                if (++this.currentIndex >= this.configElement.getValidValues().length) {
                    this.currentIndex = 0;
                }
                this.updateValueButtonText();
            }
        }

        public boolean isDefault() {
            return this.currentIndex == this.defaultIndex;
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.currentIndex = this.defaultIndex;
                this.updateValueButtonText();
            }
        }

        public boolean isChanged() {
            return this.currentIndex != this.beforeIndex;
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.currentIndex = this.beforeIndex;
                this.updateValueButtonText();
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentIndex);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public String getCurrentValue() {
            return this.configElement.get().toString();
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class BooleanEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        public BooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
        }

        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }
    }

    public static class ExcludedItemsArrayEntry
    extends GuiConfigEntries.ArrayEntry {
        public ExcludedItemsArrayEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.currentValues.length + " item(s)";
        }
    }
}

