/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.MinimapTile;
import xaero.common.settings.ModSettings;
import xaero.map.Events;
import xaero.map.MapLoader;
import xaero.map.MapRegion;
import xaero.map.MapSaveLoad;
import xaero.map.WorldMap;
import xaero.map.gui.ChunksChunk;
import xaero.map.gui.GuiWorldMapSettings;

public class SupportXaeroWorldmap {
    private IXaeroMinimap modMain;
    public boolean test;
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color slime = new Color(82, 241, 64, 128);
    private static final HashMap<ChunksChunk, Long> seedsUsed = new HashMap();

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.test = WorldMap.instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(int xFloored, int zFloored, int radius, boolean zooming, double zoom) {
        if (MapLoader.currentDimension == null) {
            return;
        }
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        Gui.func_73734_a((int)-256, (int)-256, (int)256, (int)256, (int)black.hashCode());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int minX = (mapX >> 2) - 4;
        int maxX = (mapX >> 2) + 4;
        int minZ = (mapZ >> 2) - 4;
        int maxZ = (mapZ >> 2) + 4;
        int minViewX = (mapX >> 2) - radius - 1;
        int maxViewX = (mapX >> 2) + radius + 1;
        int minViewZ = (mapZ >> 2) - radius - 1;
        int maxViewZ = (mapZ >> 2) + radius + 1;
        Events.rendering = true;
        for (int i = minX; i < maxX + 1; ++i) {
            for (int j = minZ; j < maxZ + 1; ++j) {
                boolean newSeed;
                ChunksChunk chunk;
                MapRegion region;
                MapRegion mapRegion = region = MapLoader.getMapRegion((String)MapLoader.currentWorld, (String)MapLoader.currentDimension, (int)(i >> 3), (int)(j >> 3), (boolean)true);
                synchronized (mapRegion) {
                    if (region.version != MapLoader.globalVersion) {
                        if (region.changed && region.loadState == 2) {
                            region.refresh();
                        } else {
                            MapSaveLoad.requestLoad((MapRegion)region, null);
                        }
                    }
                }
                if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.chunks[i & 7][j & 7]) == null) continue;
                int textureSize = chunk.getTexture(16, MapLoader.lightLevel) == -1 ? 8 : 16;
                chunk.bindGlTexture(false, textureSize, MapLoader.lightLevel);
                if (chunk.getTexture(textureSize, MapLoader.lightLevel) == -1) continue;
                if (!zooming) {
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                } else {
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                }
                int drawX = 64 * (chunk.X - chunkX) - 16 * tileX - insideX;
                int drawZ = 64 * (chunk.Z - chunkZ) - 16 * tileZ - insideZ - 1;
                SupportXaeroWorldmap.drawMyTexturedModalRect(drawX, drawZ, 0, 0, 64.0f, 64.0f);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                int r = 0;
                int g = 0;
                int b = 0;
                if (this.modMain.getSettings().chunkGrid > -1) {
                    int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                    r = grid >> 16 & 0xFF;
                    g = grid >> 8 & 0xFF;
                    b = grid & 0xFF;
                }
                Long seed = this.modMain.getSettings().getSlimeChunksSeed();
                Long savedSeed = seedsUsed.get(chunk);
                boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                if (newSeed) {
                    seedsUsed.put(chunk, seed);
                }
                for (int t = 0; t < 16; ++t) {
                    if (newSeed || (chunk.tileGridsCache[t % 4][t / 4] & 1) == 0) {
                        chunk.tileGridsCache[t % 4][t / 4] = 1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.X * 4 + t % 4, chunk.Z * 4 + t / 4, seed) ? 2 : 0) | ((t % 4 & 1) == (t / 4 & 1) ? 4 : 0);
                    }
                    if (this.modMain.getSettings().getSlimeChunks() && (chunk.tileGridsCache[t % 4][t / 4] & 2) != 0) {
                        int slimeDrawX = drawX + 16 * (t % 4);
                        int slimeDrawZ = drawZ + 16 * (t / 4);
                        Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)slime.hashCode());
                    }
                    if (this.modMain.getSettings().chunkGrid <= -1 || (chunk.tileGridsCache[t % 4][t / 4] & 4) == 0) continue;
                    int gridDrawX = drawX + 16 * (t % 4);
                    int gridDrawZ = drawZ + 16 * (t / 4);
                    Gui.func_73734_a((int)gridDrawX, (int)gridDrawZ, (int)(gridDrawX + 16), (int)(gridDrawZ + 16), (int)new Color(r, g, b, 64).hashCode());
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public boolean getWorldMapTerrainSlopes() {
        return WorldMap.settings.terrainSlopes;
    }

    public void openSettings() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldMapSettings(Minecraft.func_71410_x().field_71462_r));
    }
}

