/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import craftwp.CraftableWP;
import craftwp.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemDye;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.Minimap;

public class SupportCraftableWP {
    public static final Color white = new Color(255, 255, 255);
    public static final Color[] convertedDyeColours = new Color[ItemDye.field_150922_c.length];

    public SupportCraftableWP() {
        ArrayList test = CraftableWP.waypoints;
        for (int i = 0; i < convertedDyeColours.length; ++i) {
            int c = ItemDye.field_150922_c[i];
            int l = c >> 16 & 0xFF;
            int i1 = c >> 8 & 0xFF;
            int j1 = c & 0xFF;
            SupportCraftableWP.convertedDyeColours[i] = new Color(l, i1, j1, 255);
        }
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy) {
        double X;
        double Y = (pc * offx + ps * offy) * Minimap.zoom;
        double borderedX = X = (ps * offx - pc * offy) * Minimap.zoom;
        double borderedY = Y;
        if (borderedX > (double)specW) {
            borderedX = specW;
            borderedY = Y * (double)specW / X;
        } else if (borderedX < (double)(-specW)) {
            borderedX = -specW;
            borderedY = -Y * (double)specW / X;
        }
        if (borderedY > (double)specH) {
            borderedY = specH;
            borderedX = X * (double)specH / Y;
        } else if (borderedY < (double)(-specH)) {
            borderedY = -specH;
            borderedX = -X * (double)specH / Y;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)borderedX, (double)borderedY, (double)0.0);
    }

    public void renderCraftableWaypoints(double playerX, double playerZ, int specW, int specH, double ps, double pc) {
        this.renderWaypointsList((ArrayList)CraftableWP.waypoints.get(0), playerX, playerZ, specW, specH, ps, pc);
        this.renderWaypointsList((ArrayList)CraftableWP.waypoints.get(1), playerX, playerZ, specW, specH, ps, pc);
    }

    private void renderWaypointsList(ArrayList<Waypoint> waypoints, double playerX, double playerZ, int specW, int specH, double ps, double pc) {
        for (Waypoint w : waypoints) {
            if (w == null) continue;
            double offx = (double)w.x - playerX;
            double offy = (double)w.z - playerZ;
            this.translatePosition(specW, specH, ps, pc, offx, offy);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            this.drawIconOnGUI(w, -4, -4);
            GL11.glPopMatrix();
        }
    }

    public void drawIconOnGUI(Waypoint w, int drawX, int drawY) {
        int rectX2 = drawX + 9;
        int rectY2 = drawY + 9;
        Gui.func_73734_a((int)drawX, (int)drawY, (int)rectX2, (int)rectY2, (int)convertedDyeColours[w.color].hashCode());
        int j = Minecraft.func_71410_x().field_71466_p.func_78256_a(w.symbol) / 2;
        Minecraft.func_71410_x().field_71466_p.func_175063_a(w.symbol, (float)(drawX + 5 - j), (float)(drawY + 1), white.hashCode());
    }
}

