/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.waypoints.WaypointWorld;

public class WaypointWorldContainer {
    private IXaeroMinimap modMain;
    private String key;
    public HashMap<String, WaypointWorldContainer> subContainers;
    public HashMap<String, WaypointWorld> worlds;
    private HashMap<String, String> multiworldNames;

    public WaypointWorldContainer(IXaeroMinimap modMain, String key) {
        this.modMain = modMain;
        this.key = key;
        this.worlds = new HashMap();
        this.subContainers = new HashMap();
        this.multiworldNames = new HashMap();
    }

    public void setKey(String key) {
        this.key = key;
        for (WaypointWorldContainer s : this.subContainers.values()) {
            String[] subKeySplit = s.getKey().split("/");
            s.setKey(key + "/" + subKeySplit[subKeySplit.length - 1]);
        }
    }

    public WaypointWorldContainer addSubContainer(String subID) {
        WaypointWorldContainer c = this.subContainers.get(subID);
        if (c == null) {
            c = new WaypointWorldContainer(this.modMain, this.key + "/" + subID);
            this.subContainers.put(subID, c);
        }
        return c;
    }

    public WaypointWorld addWorld(String multiworldId) {
        WaypointWorld world = this.worlds.get(multiworldId);
        if (world == null) {
            WaypointWorld defaultWorld = this.worlds.get("waypoints");
            if (defaultWorld == null) {
                world = new WaypointWorld(this, multiworldId);
                this.worlds.put(multiworldId, world);
            } else {
                this.worlds.put(multiworldId, defaultWorld);
                try {
                    File defaultFile = this.modMain.getSettings().getWaypointsFile(defaultWorld);
                    defaultWorld.id = multiworldId;
                    File fixedFile = this.modMain.getSettings().getWaypointsFile(defaultWorld);
                    Files.move(defaultFile.toPath(), fixedFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.worlds.remove("waypoints");
                world = defaultWorld;
            }
        }
        return world;
    }

    public void addName(String id, String name) {
        String current = this.multiworldNames.get(id);
        if (current != null && !current.equals(name)) {
            this.worlds.get((Object)id).toRemoveOnSave.add(current);
        }
        this.multiworldNames.put(id, name);
    }

    public String getName(String id) {
        if (id.equals("waypoints")) {
            return null;
        }
        String name = this.multiworldNames.get(id);
        if (name == null) {
            name = "" + (this.multiworldNames.size() + 1);
            this.addName(id, name);
        }
        return name;
    }

    public void removeName(String id) {
        this.multiworldNames.remove(id);
    }

    public String getFullName(String id) {
        String subID;
        String name = this.getName(id);
        String string = subID = this.key.contains("/") ? this.key.substring(this.key.lastIndexOf("/") + 1) : "";
        if (name == null || this.worlds.size() < 2 && !subID.isEmpty()) {
            return subID;
        }
        return subID.length() > 0 ? name + " - " + subID : name;
    }

    public String getKey() {
        return this.key;
    }

    public WaypointWorld getFirstWorld() {
        if (!this.worlds.isEmpty()) {
            return this.worlds.values().toArray(new WaypointWorld[0])[0];
        }
        WaypointWorldContainer[] subs = this.subContainers.values().toArray(new WaypointWorldContainer[0]);
        for (int i = 0; i < subs.length; ++i) {
            WaypointWorld subFirst = subs[i].getFirstWorld();
            if (subFirst == null) continue;
            return subFirst;
        }
        return null;
    }

    public String toString() {
        return this.key + " sc:" + this.subContainers.size() + " w:" + this.worlds.size();
    }

    public ArrayList<WaypointWorld> getAllWorlds() {
        ArrayList<WaypointWorld> allWorlds = new ArrayList<WaypointWorld>(this.worlds.values());
        WaypointWorldContainer[] subs = this.subContainers.values().toArray(new WaypointWorldContainer[0]);
        for (int i = 0; i < subs.length; ++i) {
            allWorlds.addAll(subs[i].getAllWorlds());
        }
        return allWorlds;
    }
}

