/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorldContainer;

public class WaypointWorld {
    public String id;
    public HashMap<String, WaypointSet> sets;
    public HashMap<Integer, Waypoint> serverWaypoints;
    public HashMap<String, Boolean> serverWaypointsDisabled;
    public String current = "gui.xaero_default";
    public WaypointWorldContainer container;
    public List<String> toRemoveOnSave;

    public WaypointWorld(WaypointWorldContainer container, String id) {
        this.container = container;
        this.id = id;
        this.sets = new HashMap();
        this.serverWaypoints = new HashMap();
        this.serverWaypointsDisabled = new HashMap();
        this.addSet("gui.xaero_default");
        this.toRemoveOnSave = new ArrayList<String>();
    }

    public WaypointSet getCurrentSet() {
        return this.sets.get(this.current);
    }

    public void addSet(String s) {
        this.sets.put(s, new WaypointSet(s, this));
    }

    public void onSaveCleanup(File worldFile) throws IOException {
        Path folder = worldFile.toPath().getParent();
        for (int i = 0; i < this.toRemoveOnSave.size(); ++i) {
            String s = this.toRemoveOnSave.get(i);
            Path path = folder.resolve(this.id + "_" + s + ".txt");
            Files.deleteIfExists(path);
        }
    }
}

