/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import xaero.common.interfaces.InterfaceHandler;
import xaero.common.minimap.MinimapEntities;
import xaero.common.settings.ModSettings;

public class Waypoint {
    public int x;
    public int y;
    public int z;
    public String name;
    public String symbol;
    public int color;
    private boolean disabled = false;
    public int type = 0;
    public boolean rotation = false;
    public int yaw = 0;
    public double lastDistance = 0.0;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public void drawIconInWorld(ModSettings settings, VertexBuffer vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        GlStateManager.func_179152_a((float)settings.waypointsScale, (float)settings.waypointsScale, (float)1.0f);
        if (this.type == 0) {
            int c = ModSettings.COLORS[this.color];
            float l = (float)(c >> 16 & 0xFF) / 255.0f;
            float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
            float j1 = (float)(c & 0xFF) / 255.0f;
            int s = fontrenderer.func_78256_a(this.symbol) / 2;
            GlStateManager.func_179090_x();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            GlStateManager.func_179131_c((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(this.symbol, -s, -8, 0x20FFFFFF);
            fontrenderer.func_78276_b(this.symbol, -s, -8, -1);
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(250.0f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_187315_a(0.0, (double)(78.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_187315_a(0.0, (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_187315_a((double)(9.0f * f), (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_187315_a((double)(9.0f * f), (double)(78.0f * f1)).func_181675_d();
            tessellator.func_78381_a();
            if (!showDistance) {
                name = this.getName();
                if (!settings.keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        if (Minecraft.func_71410_x().func_152349_b()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            int t = fontrenderer.func_78256_a(distance) / 2;
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), 0x20FFFFFF);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), -1);
        }
        if (showingName) {
            int t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_78276_b(name, -t, 1, 0x20FFFFFF);
            fontrenderer.func_78276_b(name, -t, 1, -1);
        }
    }

    public void drawIconOnGUI(ModSettings settings, int drawX, int drawY) {
        if (this.type == 0) {
            int rectX2 = drawX + 9;
            int rectY2 = drawY + 9;
            int c = ModSettings.COLORS[this.color];
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
            c = a << 24 | r << 16 | g << 8 | b;
            Gui.func_73734_a((int)drawX, (int)drawY, (int)rectX2, (int)rectY2, (int)c);
            int j = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.symbol) / 2;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.symbol, (float)(drawX + 5 - j), (float)(drawY + 1), MinimapEntities.radarPlayers.hashCode());
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(drawX, drawY, 0, 78, 9, 9);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }
}

