/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.MinimapGraphics;
import xaero.common.util.OptimizedMath;

public class MinimapSafeMode {
    private IXaeroMinimap modMain;
    private Minimap minimap;
    private byte[] bytes;
    private byte drawYState = 0;
    private final int[] tempColor = new int[3];

    public MinimapSafeMode(IXaeroMinimap modMain, Minimap minimap) {
        this.modMain = modMain;
        this.minimap = minimap;
    }

    public void updateMapFrameSafeMode(EntityPlayer player, int bufferSize, int mapW, float partial, int level) {
        EntityPlayer p = player;
        long before = System.currentTimeMillis();
        if (this.minimap.toResetImage) {
            this.bytes = new byte[bufferSize * bufferSize * 3];
            this.minimap.toResetImage = false;
        }
        boolean motionBlur = Minecraft.func_175610_ah() >= 35;
        int increaseY = motionBlur ? 2 : 1;
        int mapH = mapW;
        int halfW = (mapW + 1) / 2;
        int halfH = (mapH + 1) / 2;
        double halfWZoomed = (double)halfW / Minimap.zoom;
        double halfHZoomed = (double)halfH / Minimap.zoom;
        int currentState = this.drawYState;
        double angle = Math.toRadians(this.minimap.getRenderAngle(player));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        double playerX = this.minimap.entities.getEntityX((Entity)player, partial);
        double playerZ = this.minimap.entities.getEntityZ((Entity)player, partial);
        for (int currentX = 0; currentX <= mapW + 1; ++currentX) {
            int currentY;
            double currentXZoomed = (double)currentX / Minimap.zoom;
            double offx = currentXZoomed - halfWZoomed;
            double psx = ps * offx;
            double pcx = pc * offx;
            int n = currentY = motionBlur ? currentState : 0;
            while (currentY <= mapH + 1) {
                double offy = (double)currentY / Minimap.zoom - halfHZoomed;
                this.minimap.getLoadedBlockColor(this.tempColor, OptimizedMath.myFloor(playerX + psx + pc * offy), OptimizedMath.myFloor(playerZ + ps * offy - pcx), level);
                MinimapGraphics.putColor(this.bytes, currentX, currentY, this.tempColor[0], this.tempColor[1], this.tempColor[2], bufferSize);
                currentY += increaseY;
            }
            currentState = (byte)(currentState != 1 ? 1 : 0);
        }
        this.renderEntityListSafeMode(p, this.minimap.loadedEntities, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        this.renderEntityListSafeMode(p, this.minimap.loadedItems, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        this.renderEntityListSafeMode(p, this.minimap.loadedHostile, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        this.renderEntityListSafeMode(p, this.minimap.loadedLiving, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        this.renderEntityListSafeMode(p, this.minimap.loadedPlayers, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        if (!this.modMain.getSettings().alwaysArrow) {
            this.renderEntityDotSafeMode(p, (Entity)p, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
        }
        this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
        ByteBuffer buffer = this.minimap.mapTexture.getBuffer(bufferSize);
        buffer.put(this.bytes);
        buffer.flip();
    }

    public void renderEntityListSafeMode(EntityPlayer p, ArrayList<Entity> list, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial) {
        for (int i = 0; i < list.size(); ++i) {
            Entity e = list.get(i);
            if (p != e && this.renderEntityDotSafeMode(p, e, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial)) continue;
        }
    }

    public boolean renderEntityDotSafeMode(EntityPlayer p, Entity e, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial) {
        if (!this.minimap.entities.shouldRenderEntity(e)) {
            return false;
        }
        double offx = this.minimap.entities.getEntityX(e, partial) - playerX;
        double offz = this.minimap.entities.getEntityZ(e, partial) - playerZ;
        double offh = p.field_70163_u - e.field_70163_u;
        double Z = pc * offx + ps * offz;
        double X = ps * offx - pc * offz;
        int drawX = OptimizedMath.myFloor((double)halfW + X * Minimap.zoom);
        int drawY = OptimizedMath.myFloor((double)halfH + Z * Minimap.zoom);
        this.modMain.getSettings();
        int color = this.minimap.entities.getEntityColour(p, e, offh);
        for (int a = drawX - 2; a < drawX + 4; ++a) {
            if (a < 0 || a > mapW) continue;
            for (int b = drawY - 2; b < drawY + 4; ++b) {
                if (b < 0 || b > mapW || (a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                    MinimapGraphics.putColor(this.bytes, a, b, 0, 0, 0, bufferSize);
                    continue;
                }
                MinimapGraphics.putColor(this.bytes, a, b, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, bufferSize);
            }
        }
        return true;
    }
}

