/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceHandler;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.MinimapEntities;
import xaero.common.minimap.MinimapGraphics;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.settings.ModOptions;
import xaero.common.util.OptimizedMath;

public class MinimapInterface
extends Interface {
    private IXaeroMinimap modMain;
    private Minimap minimap;
    private Minecraft mc = Minecraft.func_71410_x();
    int lastMinimapSize = 0;
    private ArrayList<String> underText = new ArrayList();

    public MinimapInterface(IXaeroMinimap modMain, InterfaceHandler interfaces) {
        super(interfaces, "gui.xaero_minimap", 128, 128, ModOptions.MINIMAP);
        this.modMain = modMain;
        this.minimap = new Minimap(modMain);
    }

    public Minimap getMinimap() {
        return this.minimap;
    }

    @Override
    public int getW(int scale) {
        return (int)((float)(this.getSize() / scale) * this.modMain.getSettings().getMinimapScale());
    }

    @Override
    public int getH(int scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(int scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(int scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(int scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(int scale) {
        return this.getH(scale);
    }

    @Override
    public int getSize() {
        return this.minimap.getMinimapWidthAndBuffer()[0] + 36 + 2;
    }

    public void translatePosition(int specW, int specH, double ps, double pc, double offx, double offy) {
        double X;
        double Y = (pc * offx + ps * offy) * Minimap.zoom;
        double borderedX = X = (ps * offx - pc * offy) * Minimap.zoom;
        double borderedY = Y;
        if (borderedX > (double)specW) {
            borderedX = specW;
            borderedY = Y * (double)specW / X;
        } else if (borderedX < (double)(-specW)) {
            borderedX = -specW;
            borderedY = -Y * (double)specW / X;
        }
        if (borderedY > (double)specH) {
            borderedY = specH;
            borderedX = X * (double)specH / Y;
        } else if (borderedY < (double)(-specH)) {
            borderedY = -specH;
            borderedX = -X * (double)specH / Y;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)borderedX, (double)borderedY, (double)0.0);
    }

    public boolean canUseFrameBuffer() {
        return GLContext.getCapabilities().OpenGL14 && (GLContext.getCapabilities().GL_ARB_framebuffer_object || GLContext.getCapabilities().GL_EXT_framebuffer_object || GLContext.getCapabilities().OpenGL30);
    }

    @Override
    public void drawInterface(int width, int height, int scale, float partial) {
        int specW;
        int mapW;
        if (this.minimap.crashedWith != null) {
            FMLCommonHandler.instance().getSidedDelegate().haltGame("The minimap has failed! Please contact me at planetminecraft.com/member/xaero96 or minecraftforum.net/members/xaero96", (Throwable)this.minimap.crashedWith);
            return;
        }
        if (this.minimap.loadedFBO && !this.canUseFrameBuffer()) {
            this.minimap.loadedFBO = false;
            this.minimap.scalingFrameBuffer.func_147608_a();
            this.minimap.rotationFrameBuffer.func_147608_a();
            this.minimap.resetImage();
        }
        if (!this.minimap.loadedFBO && !this.modMain.getSettings().mapSafeMode && this.canUseFrameBuffer()) {
            this.minimap.loadFrameBuffer();
        }
        if (this.modMain.getSettings().getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = this.modMain.getSettings().getMinimapSize();
            this.minimap.resetImage();
        }
        long before = System.currentTimeMillis();
        int[] mapAndBuffer = this.minimap.getMinimapWidthAndBuffer();
        if (this.minimap.usingFBO()) {
            mapAndBuffer[1] = this.minimap.getFBOBufferSize();
        }
        float mapScale = (float)scale / 2.0f / this.modMain.getSettings().getMinimapScale();
        int mapH = this.minimap.minimapHeight = (mapW = (this.minimap.minimapWidth = mapAndBuffer[0]));
        this.minimap.updateZoom();
        Minimap.zoom = this.minimap.getZoom();
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float sizeFix = (float)mapAndBuffer[1] / 512.0f;
        int lightLevel = (int)((1.0f - this.mc.field_71441_e.getSunBrightnessFactor(1.0f)) * (float)(this.minimap.loadedLevels - 1));
        if (this.minimap.usingFBO()) {
            this.minimap.renderChunksToFBO((EntityPlayer)this.mc.field_71439_g, mapAndBuffer[1], mapW, sizeFix, partial, lightLevel, true);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().func_147110_a().field_147621_c, (int)Minecraft.func_71410_x().func_147110_a().field_147618_d);
            this.minimap.rotationFrameBuffer.func_147612_c();
            sizeFix = 1.0f;
        } else {
            this.minimap.safeMode.updateMapFrameSafeMode((EntityPlayer)this.mc.field_71439_g, mapAndBuffer[1], mapW, partial, lightLevel);
            GL11.glScalef((float)sizeFix, (float)sizeFix, (float)1.0f);
            MinimapGraphics.bindTextureBuffer(this.minimap.mapTexture.getBuffer(mapAndBuffer[1]), mapAndBuffer[1], mapAndBuffer[1], this.minimap.mapTexture.func_110552_b());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.modMain.getSettings().minimapOpacity / 100.0f));
        }
        GL11.glEnable((int)3008);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)this.x * mapScale);
        int scaledY = (int)((float)this.y * mapScale);
        this.mc.field_71456_v.func_73729_b((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 0, (int)((float)(mapW / 2 + 1) / sizeFix), (int)((float)(mapH / 2 + 1) / sizeFix));
        if (!this.minimap.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int specH = specW = mapW / 2 + 6;
        double angle = Math.toRadians(this.minimap.getRenderAngle((EntityPlayer)this.mc.field_71439_g));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        this.mc.func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
        if (this.modMain.getSettings().getLockNorth() || this.modMain.getSettings().alwaysArrow) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            double arrowX = (double)(2 * scaledX + 18 + (mapW + 1) / 2) + 0.5;
            double arrowY = (double)(2 * scaledY + 18 + (mapH + 1) / 2) + 0.5;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float arrowAngle = this.modMain.getSettings().getLockNorth() ? this.mc.field_71439_g.field_70177_z : 180.0f;
            this.drawArrow(arrowAngle, arrowX, arrowY + 1.0, new float[]{0.0f, 0.0f, 0.0f, 0.5f});
            float[] c = new float[4];
            if (this.modMain.getSettings().arrowColour != -1) {
                c = this.modMain.getSettings().arrowColours[this.modMain.getSettings().arrowColour];
            } else {
                int rgb = this.minimap.entities.getPlayerTeamColour((EntityPlayer)this.mc.field_71439_g);
                if (rgb != -1) {
                    c[0] = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    c[1] = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    c[2] = (float)(rgb & 0xFF) / 255.0f;
                    c[3] = 1.0f;
                } else {
                    c = this.modMain.getSettings().arrowColours[0];
                }
            }
            this.drawArrow(arrowAngle, arrowX, arrowY, c);
            GL11.glPopMatrix();
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
        this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4, 0, 15, 17, 15);
        this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + mapH / 2 - 6, 0, 30, 17, 15);
        this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4 + mapH / 2 - 6, 0, 45, 17, 15);
        int horLineLength = (mapW / 2 - 16) / 16;
        for (int i = 0; i < horLineLength; ++i) {
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4, 0, 60, 16, 4);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4 + mapH / 2 + 9 - 4, 0, 64, 16, 4);
        }
        int vertLineLength = (mapH / 2 - 14) / 5;
        for (int i = 0; i < vertLineLength; ++i) {
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 68, 4, 5);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 73, 4, 5);
        }
        GL11.glPushMatrix();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179109_b((float)(2 * scaledX + specW - 6 + 18), (float)(2 * scaledY + specH - 6 + 18), (float)0.0f);
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(specW, specH, ps, pc, partial);
            this.drawCompass(specW, specH, ps, pc);
        } else {
            this.drawCompass(specW, specH, ps, pc);
            this.drawWaypoints(specW, specH, ps, pc, partial);
        }
        GL11.glPopMatrix();
        if (this.modMain.getSettings().getShowCoords()) {
            int interfaceSize = this.getSize() / 2;
            String coords = OptimizedMath.myFloor(this.mc.field_71439_g.field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.field_71439_g.field_70163_u) + ", " + OptimizedMath.myFloor(this.mc.field_71439_g.field_70161_v);
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + OptimizedMath.myFloor(this.mc.field_71439_g.field_70163_u);
                coords = OptimizedMath.myFloor(this.mc.field_71439_g.field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.field_71439_g.field_70161_v);
                this.underText.add(coords);
                this.underText.add(stringLevel);
            } else {
                this.underText.add(coords);
            }
        }
        if (this.modMain.getSettings().showBiome) {
            BlockPos pos = new BlockPos(this.mc.func_175606_aa().field_70165_t, this.mc.func_175606_aa().func_174813_aQ().field_72338_b, this.mc.func_175606_aa().field_70161_v);
            this.underText.add(this.mc.field_71441_e.func_175726_f(pos).func_177411_a(pos, this.mc.field_71441_e.func_72959_q()).func_185359_l());
        }
        this.drawTextUnderMinimap(scaledX, scaledY, height, mapScale);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
        super.drawInterface(width, height, scale, partial);
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float[] colour) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)(0.5f * this.modMain.getSettings().arrowScale), (float)(0.5f * this.modMain.getSettings().arrowScale), (float)1.0f);
        GL11.glTranslated((double)-13.0, (double)-6.0, (double)0.0);
        GL11.glColor4f((float)colour[0], (float)colour[1], (float)colour[2], (float)colour[3]);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, 0, 26, 27);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(int scaledX, int scaledY, int height, float mapScale) {
        int interfaceSize = this.getSize() / 2;
        int scaledHeight = (int)((float)height * mapScale);
        for (int i = 0; i < this.underText.size(); ++i) {
            String s = this.underText.get(i);
            int stringWidth = this.mc.field_71466_p.func_78256_a(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 9 * (under ? 1 : -1);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(scaledX + interfaceSize / 2 - stringWidth / 2), (float)stringY, MinimapEntities.radarPlayers.hashCode());
        }
        this.underText.clear();
    }

    private void drawWaypoints(int specW, int specH, double ps, double pc, float partial) {
        double playerZ;
        double playerX;
        if (this.modMain.getSettings().getShowWaypoints() && this.minimap.waypoints != null) {
            playerX = this.minimap.entities.getEntityX((Entity)this.mc.field_71439_g, partial);
            playerZ = this.minimap.entities.getEntityZ((Entity)this.mc.field_71439_g, partial);
            this.renderWaypointsList(this.minimap.waypoints.list, playerX, playerZ, specW, specH, ps, pc);
        }
        if (this.modMain.getSettings().getShowWaypoints() && ServerWaypointStorage.working() && this.minimap.serverWaypoints != null) {
            playerX = this.minimap.entities.getEntityX((Entity)this.mc.field_71439_g, partial);
            playerZ = this.minimap.entities.getEntityZ((Entity)this.mc.field_71439_g, partial);
            this.renderWaypointsList(this.minimap.serverWaypoints, playerX, playerZ, specW, specH, ps, pc);
        }
        if (this.modMain.getSupportMods().craftableWPSupport != null) {
            playerX = this.minimap.entities.getEntityX((Entity)this.mc.field_71439_g, partial);
            playerZ = this.minimap.entities.getEntityZ((Entity)this.mc.field_71439_g, partial);
            this.modMain.getSupportMods().craftableWPSupport.renderCraftableWaypoints(playerX, playerZ, specW, specH, ps, pc);
        }
    }

    private void renderWaypointsList(List<Waypoint> waypoints, double playerX, double playerZ, int specW, int specH, double ps, double pc) {
        for (int i = 0; i < waypoints.size(); ++i) {
            Waypoint w = waypoints.get(i);
            if (w == null || w.isDisabled() || w.type == 1 && !this.modMain.getSettings().getDeathpoints() || this.modMain.getSettings().waypointsDistance != 0.0f && w.lastDistance > (double)this.modMain.getSettings().waypointsDistance) continue;
            double offx = (double)w.x - playerX;
            double offy = (double)w.z - playerZ;
            this.translatePosition(specW, specH, ps, pc, offx, offy);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            w.drawIconOnGUI(this.modMain.getSettings(), -4, -4);
            GL11.glPopMatrix();
        }
    }

    private void drawCompass(int specW, int specH, double ps, double pc) {
        String[] nesw = new String[]{"N", "E", "S", "W"};
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            this.translatePosition(specW, specH, ps, pc, offx, offy);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(nesw[i], (float)(1 - this.mc.field_71466_p.func_78256_a(nesw[i]) / 2), -3.0f, MinimapEntities.radarPlayers.hashCode());
            GL11.glPopMatrix();
        }
    }
}

