/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.ScorePlayerTeam;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.MinimapGraphics;
import xaero.common.settings.ModSettings;

public class MinimapEntities {
    public static final Color radarPlayers = new Color(255, 255, 255);
    public static final Color radarShadow = new Color(0, 0, 0);
    private IXaeroMinimap modMain;

    public MinimapEntities(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e) {
        return !e.func_70093_af() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(EntityPlayer p) {
        int teamColour = -1;
        if (p.func_96124_cp() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e().length() >= 2) {
            String prefix = ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e();
            try {
                teamColour = Minecraft.func_71410_x().field_71466_p.func_175064_b(prefix.charAt(prefix.length() - 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return teamColour;
    }

    public int getEntityColour(EntityPlayer p, Entity e, double offh) {
        int color = ModSettings.COLORS[this.modMain.getSettings().otherColor];
        if (e instanceof EntityPlayer) {
            int teamColour = this.getPlayerTeamColour(p);
            int entityTeamColour = this.getPlayerTeamColour((EntityPlayer)e);
            color = this.modMain.getSettings().otherTeamColor != -1 && entityTeamColour != teamColour ? ModSettings.COLORS[this.modMain.getSettings().otherTeamColor] : (this.modMain.getSettings().playersColor != -1 ? ModSettings.COLORS[this.modMain.getSettings().playersColor] : (entityTeamColour != -1 ? entityTeamColour : radarPlayers.hashCode()));
        } else if (e instanceof EntityMob || e instanceof IMob) {
            color = ModSettings.COLORS[this.modMain.getSettings().hostileColor];
        } else if (e instanceof EntityLiving) {
            color = ModSettings.COLORS[this.modMain.getSettings().mobsColor];
        } else if (e instanceof EntityItem) {
            color = ModSettings.COLORS[this.modMain.getSettings().itemsColor];
        }
        int l = color >> 16 & 0xFF;
        int i1 = color >> 8 & 0xFF;
        int j1 = color & 0xFF;
        double brightness = this.getEntityBrightness(offh);
        if (brightness < 1.0) {
            if ((l = (int)((double)l * brightness)) > 255) {
                l = 255;
            }
            if ((i1 = (int)((double)i1 * brightness)) > 255) {
                i1 = 255;
            }
            if ((j1 = (int)((double)j1 * brightness)) > 255) {
                j1 = 255;
            }
            color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        }
        return color;
    }

    public double getEntityBrightness(double offh) {
        double level = (double)this.modMain.getSettings().heightLimit - offh;
        if (level < 0.0) {
            level = 0.0;
        }
        double brightness = 1.0;
        if (level <= (double)(this.modMain.getSettings().heightLimit / 2) && this.modMain.getSettings().showEntityHeight) {
            brightness = level / (double)this.modMain.getSettings().heightLimit;
        }
        return brightness;
    }

    public void renderEntityListToFBO(EntityPlayer p, ArrayList<Entity> list, float angle, double playerX, double playerZ, float partial) {
        for (int i = 0; i < list.size(); ++i) {
            Entity e = list.get(i);
            if (p == e) continue;
            if ((Keyboard.isKeyDown((int)15) || this.modMain.getSettings().getPlayerHeads()) && e instanceof AbstractClientPlayer) {
                this.renderPlayerHeadToFBO(p, (AbstractClientPlayer)e, angle, playerX, playerZ, partial);
                continue;
            }
            this.renderEntityDotToFBO(p, e, angle, playerX, playerZ, partial);
        }
    }

    public void renderPlayerHeadToFBO(EntityPlayer mainPlayer, AbstractClientPlayer e, float angle, double playerX, double playerZ, float partial) {
        if (!this.shouldRenderEntity((Entity)e)) {
            return;
        }
        double offx = this.getEntityX((Entity)e, partial) - playerX;
        double offz = playerZ - this.getEntityZ((Entity)e, partial);
        double offh = mainPlayer.field_70163_u - e.field_70163_u;
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)(offx * Minimap.zoom), (double)(offz * Minimap.zoom), (double)0.0);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)0.0f);
        double brightness = this.getEntityBrightness(offh);
        GL11.glColor3d((double)brightness, (double)brightness, (double)brightness);
        boolean flag1 = e != null && e.func_175148_a(EnumPlayerModelParts.CAPE) && (e.func_146103_bH().getName().equals("Dinnerbone") || e.func_146103_bH().getName().equals("Grumm"));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        Gui.func_152125_a((int)0, (int)0, (float)8.0f, (float)((float)l2 + (float)i3), (int)8, (int)(-i3), (int)8, (int)8, (float)64.0f, (float)64.0f);
        if (e != null && e.func_175148_a(EnumPlayerModelParts.HAT)) {
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a((int)0, (int)0, (float)40.0f, (float)((float)j3 + (float)k3), (int)8, (int)(-k3), (int)8, (int)8, (float)64.0f, (float)64.0f);
        }
        GL11.glPopMatrix();
    }

    public void renderEntityDotToFBO(EntityPlayer p, Entity e, float angle, double playerX, double playerZ, float partial) {
        if (!this.shouldRenderEntity(e)) {
            return;
        }
        double offx = this.getEntityX(e, partial) - playerX;
        double offz = playerZ - this.getEntityZ(e, partial);
        double offh = p.field_70163_u - e.field_70163_u;
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)(offx * Minimap.zoom), (double)(offz * Minimap.zoom), (double)0.0);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
        int color = this.getEntityColour(p, e, offh);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
        GL11.glScalef((float)this.modMain.getSettings().dotsScale, (float)this.modMain.getSettings().dotsScale, (float)1.0f);
        MinimapGraphics.drawMyTexturedModalRect(-2.0f, -3.0f, this.modMain.getSettings().getSmoothDots() ? 2 : 10, this.modMain.getSettings().getSmoothDots() ? 89 : 78, 6.0f, 6.0f, 256.0f);
        GL11.glPopMatrix();
    }
}

