/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.MinimapTile;

public class MinimapChunk {
    public static final int LIGHT_LEVELS = 5;
    public int X;
    public int Z;
    public boolean hasSomething = false;
    public MinimapTile[][] tiles = new MinimapTile[4][4];
    public int[] glTexture = new int[5];
    public boolean[] refreshRequired = new boolean[5];
    private boolean refreshed = false;
    public ByteBuffer[] buffer = null;
    public int[][] lastHeights = new int[4][16];
    public boolean changed = false;
    public int levelsBuffered = 0;

    public MinimapChunk(int X, int Z) {
        this.X = X;
        this.Z = Z;
        this.buffer = new ByteBuffer[5];
    }

    public int getLevelToRefresh(int currentLevel) {
        if (this.refreshed || this.levelsBuffered == 0) {
            return -1;
        }
        int prev = currentLevel - 1;
        if (prev < 0) {
            prev = this.levelsBuffered - 1;
        }
        int i = currentLevel;
        while (true) {
            if (this.refreshRequired[i]) {
                return i;
            }
            if (i == prev) break;
            i = (i + 1) % this.levelsBuffered;
        }
        this.refreshed = true;
        return -1;
    }

    public void bindTexture(int level) {
        if (!this.hasSomething) {
            return;
        }
        int levelToRefresh = this.getLevelToRefresh(Math.min(level, this.levelsBuffered - 1));
        if (levelToRefresh != -1) {
            boolean result = false;
            if (this.glTexture[levelToRefresh] == 0) {
                this.glTexture[levelToRefresh] = GL11.glGenTextures();
                result = true;
            }
            GlStateManager.func_179144_i((int)this.glTexture[levelToRefresh]);
            if (result) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)0);
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            }
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)64, (int)64, (int)0, (int)6407, (int)5121, (ByteBuffer)this.buffer[levelToRefresh]);
            this.buffer[levelToRefresh].clear();
            this.refreshRequired[levelToRefresh] = false;
        }
        if (this.glTexture[level] != 0) {
            GlStateManager.func_179144_i((int)this.glTexture[level]);
        }
    }

    public void updateBuffers(int levelsToLoad) {
        this.refreshed = true;
        for (int l = 0; l < levelsToLoad; ++l) {
            this.refreshRequired[l] = false;
            if (this.buffer[l] != null) continue;
            this.buffer[l] = BufferUtils.createByteBuffer((int)(768 * this.tiles.length * this.tiles.length));
        }
        byte[][] bytes = new byte[levelsToLoad][768 * this.tiles.length * this.tiles.length];
        for (int o = 0; o < this.tiles.length; ++o) {
            int offX = o * 16;
            for (int p = 0; p < this.tiles.length; ++p) {
                MinimapTile tile = this.tiles[o][p];
                if (tile == null) continue;
                int offZ = p * 16;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        for (int i = 0; i < levelsToLoad; ++i) {
                            this.putColour(offX + x, offZ + z, tile.red[i][x][z], tile.green[i][x][z], tile.blue[i][x][z], bytes[i], 64);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < levelsToLoad; ++i) {
            this.buffer[i].put(bytes[i]);
            this.buffer[i].flip();
            this.refreshRequired[i] = true;
        }
        this.refreshed = false;
    }

    public void putColour(int x, int y, int red, int green, int blue, byte[] texture, int size) {
        int pos = (y * size + x) * 3;
        texture[pos] = (byte)red;
        texture[++pos] = (byte)green;
        texture[++pos] = (byte)blue;
    }
}

