/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.realmsclient.dto.RealmsServer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.OldAnimation;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.interfaces.InterfaceHandler;
import xaero.common.minimap.DynamicTexture;
import xaero.common.minimap.ImprovedFramebuffer;
import xaero.common.minimap.MinimapChunk;
import xaero.common.minimap.MinimapEntities;
import xaero.common.minimap.MinimapGraphics;
import xaero.common.minimap.MinimapSafeMode;
import xaero.common.minimap.MinimapTile;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.settings.ModSettings;
import xaero.common.util.BlockStateUtil;
import xaero.common.util.OptimizedMath;

public class Minimap {
    private static final boolean DEBUG = false;
    public static final int FRAME = 9;
    public static final ResourceLocation mapTextures = new ResourceLocation("xaeromaptexture");
    private IXaeroMinimap modMain;
    public Exception crashedWith;
    public Thread loadingThread;
    public MinimapEntities entities;
    public MinimapSafeMode safeMode;
    private int loadingSideInChunks = 16;
    private int updateRadius = 16;
    public boolean enlargedMap = false;
    private Minecraft mc = Minecraft.func_71410_x();
    private int loadedCaving = -1;
    private int loadingCaving = -1;
    public ArrayList<Entity> loadedPlayers = new ArrayList();
    public ArrayList<Entity> loadedLiving = new ArrayList();
    public ArrayList<Entity> loadedHostile = new ArrayList();
    public ArrayList<Entity> loadedItems = new ArrayList();
    public ArrayList<Entity> loadedEntities = new ArrayList();
    private int loadingMapChunkX = 0;
    private int loadingMapChunkZ = 0;
    private int loadedMapChunkX = 0;
    private int loadedMapChunkZ = 0;
    public double minimapZoom = 1.0;
    public int minimapWidth = 0;
    public int minimapHeight = 0;
    public HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    public WaypointSet waypoints = null;
    public List<Waypoint> serverWaypoints = null;
    private String containerID = null;
    public String customContainerID = null;
    private String worldID = null;
    public String customWorldID = null;
    public BlockPos currentSpawn;
    public RealmsServer latestRealm;
    private Long seedForLoading;
    private MinimapChunk[][] currentBlocks = new MinimapChunk[16][16];
    private MinimapChunk[][] loadingBlocks = new MinimapChunk[16][16];
    public ArrayList<Integer> texturesToDelete = new ArrayList();
    private boolean forcedRefresh = false;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private int updateChunkX = 0;
    private int updateChunkZ = 0;
    private int tileInsideX = 0;
    private int tileInsideZ = 0;
    private int runNumber = 0;
    private MinimapChunk oldChunk = null;
    private int updates = 0;
    private int loads = 0;
    private long before = 0L;
    private int processingTime = 0;
    private int loadingLevels = 0;
    public int loadedLevels = 0;
    private HashMap<String, Integer> textureColours = new HashMap();
    private HashMap<Integer, Integer> blockColours = new HashMap();
    public boolean clearBlockColours = false;
    boolean isglowing = false;
    public int[][] lastBlockY = new int[4][16];
    private Integer previousTransparentBlock = null;
    private int underRed;
    private int underGreen;
    private int underBlue;
    private float divider = 1.0f;
    private int sun;
    private int blockY = 0;
    private int blockColor = 0;
    private final int[] red = new int[5];
    private final int[] green = new int[5];
    private final int[] blue = new int[5];
    private final float[] brightness = new float[5];
    private final float[] postBrightness = new float[5];
    private final int[] tempColor = new int[3];
    private double secondaryB;
    boolean toResetImage = true;
    public static double zoom = 1.0;
    public static final int[] minimapSizes = new int[]{112, 168, 224, 336};
    public static final int[] bufferSizes = new int[]{128, 256, 256, 512};
    public boolean triedFBO = false;
    public boolean loadedFBO = false;
    public DynamicTexture mapTexture = new DynamicTexture(mapTextures);
    private int lastCaving = -1;
    public ImprovedFramebuffer scalingFrameBuffer;
    public ImprovedFramebuffer rotationFrameBuffer;
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color slime = new Color(82, 241, 64, 128);
    public long setChanged;

    public Minimap(IXaeroMinimap modMain1) {
        this.modMain = modMain1;
        this.entities = new MinimapEntities(this.modMain);
        this.safeMode = new MinimapSafeMode(this.modMain, this);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: while (true) {
                    try {
                        while (true) {
                            long startTime = System.currentTimeMillis();
                            int totalTime = 3000000;
                            int sleepTime = 10;
                            while (totalTime > 0) {
                                try {
                                    EntityPlayerSP player = ((Minimap)Minimap.this).mc.field_71439_g;
                                    WorldClient world = ((Minimap)Minimap.this).mc.field_71441_e;
                                    if (Minimap.this.modMain.getSettings() == null || !Minimap.this.modMain.getSettings().getMinimap() || player == null || world == null) {
                                        sleepTime = 100;
                                        break;
                                    }
                                    WorldClient worldClient = world;
                                    synchronized (worldClient) {
                                        int time = Minimap.this.updateAChunk((EntityPlayer)player, (World)world);
                                        totalTime -= time;
                                    }
                                    if (Minimap.this.tileInsideX != 0 || Minimap.this.tileInsideZ != 0 || Minimap.this.updateChunkX != 0 || Minimap.this.updateChunkZ != 0) continue;
                                    sleepTime = 300;
                                    break;
                                }
                                catch (ConcurrentModificationException player) {
                                }
                            }
                            int passed = (int)(System.currentTimeMillis() - startTime);
                            try {
                                if (passed >= sleepTime) continue block9;
                                Thread.sleep(sleepTime - passed);
                                continue block9;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Minimap.this.crashedWith = e;
                        return;
                    }
                }
            }
        }).start();
    }

    public int getLoadSide() {
        return 9;
    }

    public int getUpdateRadiusInChunks() {
        return (int)Math.ceil((double)this.loadingSideInChunks / Math.sqrt(2.0) / 2.0 / (double)this.modMain.getSettings().zooms[this.modMain.getSettings().zoom]);
    }

    public static String getDimensionName(DimensionType dt) {
        String dim = dt.func_186065_b();
        if (dim == null || dim.length() == 0) {
            dim = Integer.toString(dt.func_186068_a());
        }
        return dim;
    }

    private String getContainer(World world) {
        String dim = Minimap.getDimensionName(world.field_73011_w.func_186058_p());
        if (this.mc.func_71401_C() != null) {
            return this.mc.func_71401_C().func_71270_I().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%") + "/" + dim;
        }
        if (this.mc.func_147104_D() != null && this.currentSpawn != null) {
            String serverIP = this.mc.func_147104_D().field_78845_b;
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            if (this.mc.func_147104_D() != null && ServerWaypointStorage.autoWorldUID != null) {
                return ServerWaypointStorage.getAutoContainer();
            }
            return "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%") + "/" + dim;
        }
        if (this.mc.func_181540_al() && this.latestRealm != null && this.currentSpawn != null) {
            return "Realms_" + this.latestRealm.ownerUUID + "." + this.latestRealm.id + "/" + dim;
        }
        return "Unknown_null";
    }

    private String getWorld(World world) {
        if (this.mc.func_71401_C() != null) {
            return "waypoints";
        }
        if (this.currentSpawn != null) {
            if (this.mc.func_147104_D() != null && ServerWaypointStorage.autoWorldUID != null) {
                return ServerWaypointStorage.getAutoWorld();
            }
            return "mw" + (this.currentSpawn.func_177958_n() >> 6) + "," + (this.currentSpawn.func_177956_o() >> 6) + "," + (this.currentSpawn.func_177952_p() >> 6);
        }
        return "null";
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerID() + "_" + this.getCurrentWorldID();
    }

    public String getCurrentContainerID() {
        if (this.customContainerID == null) {
            return this.containerID;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID() {
        if (this.customWorldID == null) {
            return this.worldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld() {
        return this.getWorld(this.getCurrentContainerID(), this.getCurrentWorldID());
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getCurrentOriginContainerID() {
        if (this.getCurrentContainerID() == null) {
            return null;
        }
        return this.getCurrentContainerID().split("/")[0];
    }

    public String getAutoOriginContainerID() {
        if (this.containerID == null) {
            return null;
        }
        return this.containerID.split("/")[0];
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldContainer(this.modMain, subs[i]);
                this.waypointMap.put(subs[i], container);
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public void updateWaypoints() {
        this.containerID = this.getContainer((World)this.mc.field_71441_e);
        this.worldID = this.getWorld((World)this.mc.field_71441_e);
        this.addWorld(this.containerID, this.worldID);
        WaypointWorld world = this.getCurrentWorld();
        if (this.getCurrentContainerID() != null && this.getCurrentWorldID() != null) {
            this.seedForLoading = this.modMain.getSettings().getSlimeChunksSeed();
        }
        this.waypoints = world.getCurrentSet();
        this.serverWaypoints = !world.serverWaypoints.isEmpty() ? new ArrayList<Waypoint>(world.serverWaypoints.values()) : null;
    }

    private boolean ignoreWorld(World world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(world.field_73011_w.func_186058_p().func_186065_b())) continue;
            return true;
        }
        return false;
    }

    private int updateAChunk(EntityPlayer player, World world) throws ConcurrentModificationException {
        MinimapChunk mchunk;
        long processStart = System.nanoTime();
        if (!(this.ignoreWorld(world) || this.modMain.getSupportMods().shouldUseWorldMapChunks() && this.loadingCaving == -1 && this.getCaving(player, world) == -1)) {
            if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
                if (this.updateChunkX == 0 && this.updateChunkZ == 0) {
                    if (this.clearBlockColours) {
                        this.clearBlockColours = false;
                        if (!this.blockColours.isEmpty()) {
                            this.blockColours.clear();
                            this.textureColours.clear();
                            System.out.println("Minimap block colour cache cleaned.");
                        }
                    }
                    this.loadingSideInChunks = this.getLoadSide();
                    this.updateRadius = this.getUpdateRadiusInChunks();
                    this.loadingMapChunkX = this.getMapCoord(this.loadingSideInChunks, player.field_70165_t);
                    this.loadingMapChunkZ = this.getMapCoord(this.loadingSideInChunks, player.field_70161_v);
                    this.loadingCaving = this.getCaving(player, world);
                    if (this.loadingCaving != this.loadedCaving) {
                        this.runNumber = 0;
                    }
                    this.loadingLevels = this.modMain.getSettings().getLighting() ? 5 : 1;
                    this.loadingBlocks = new MinimapChunk[this.loadingSideInChunks][this.loadingSideInChunks];
                    if (this.usingFBO() && this.toResetImage) {
                        this.forcedRefresh = true;
                        this.toResetImage = false;
                    }
                }
                this.oldChunk = null;
                if (this.currentBlocks != null) {
                    int updateChunkXOld = this.loadingMapChunkX + this.updateChunkX - this.loadedMapChunkX;
                    int updateChunkZOld = this.loadingMapChunkZ + this.updateChunkZ - this.loadedMapChunkZ;
                    if (updateChunkXOld > -1 && updateChunkXOld < this.currentBlocks.length && updateChunkZOld > -1 && updateChunkZOld < this.currentBlocks.length) {
                        this.oldChunk = this.currentBlocks[updateChunkXOld][updateChunkZOld];
                    }
                }
            }
            if (this.loadingBlocks[this.updateChunkX][this.updateChunkZ] == null) {
                this.loadingBlocks[this.updateChunkX][this.updateChunkZ] = new MinimapChunk(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
            }
            mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ];
            this.updateTile(player, world, mchunk, this.oldChunk, this.updateChunkX, this.updateChunkZ, this.tileInsideX, this.tileInsideZ, this.runNumber % 5 != 0);
        }
        ++this.tileInsideZ;
        if (this.tileInsideZ >= 4) {
            this.tileInsideZ = 0;
            ++this.tileInsideX;
            if (this.tileInsideX >= 4) {
                this.tileInsideX = 0;
                mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ];
                if (mchunk != null && !mchunk.hasSomething) {
                    this.loadingBlocks[this.updateChunkX][this.updateChunkZ] = null;
                    mchunk = null;
                }
                if (this.usingFBO() && mchunk != null && mchunk.changed) {
                    mchunk.updateBuffers(this.loadingLevels);
                    mchunk.changed = false;
                }
                if (mchunk != null) {
                    mchunk.levelsBuffered = this.loadingLevels;
                }
                if (this.updateChunkX == this.loadingSideInChunks - 1 && this.updateChunkZ == this.loadingSideInChunks - 1) {
                    for (int i = 0; i < this.currentBlocks.length; ++i) {
                        for (int j = 0; j < this.currentBlocks.length; ++j) {
                            MinimapChunk m = this.currentBlocks[i][j];
                            MinimapChunk lm = null;
                            int loadingX = this.loadedMapChunkX + i - this.loadingMapChunkX;
                            int loadingZ = this.loadedMapChunkZ + j - this.loadingMapChunkZ;
                            if (loadingX > -1 && loadingZ > -1 && loadingX < this.loadingSideInChunks && loadingZ < this.loadingSideInChunks) {
                                lm = this.loadingBlocks[loadingX][loadingZ];
                            }
                            if (m == null || m.levelsBuffered <= 0) continue;
                            boolean shouldTransfer = m.levelsBuffered == this.loadingLevels && lm != null;
                            for (int l = 0; l < m.levelsBuffered; ++l) {
                                if (m.glTexture[l] != 0) {
                                    if (shouldTransfer) {
                                        lm.glTexture[l] = m.glTexture[l];
                                        continue;
                                    }
                                    this.texturesToDelete.add(m.glTexture[l]);
                                    continue;
                                }
                                if (!shouldTransfer || lm.refreshRequired[l] || !m.refreshRequired[l]) continue;
                                lm.buffer[l] = m.buffer[l];
                                lm.refreshRequired[l] = true;
                            }
                        }
                    }
                    this.currentBlocks = this.loadingBlocks;
                    this.loadedMapChunkX = this.loadingMapChunkX;
                    this.loadedMapChunkZ = this.loadingMapChunkZ;
                    this.loadedCaving = this.loadingCaving;
                    this.loadedLevels = this.loadingLevels;
                    this.forcedRefresh = false;
                    ++this.runNumber;
                }
                ++this.updateChunkZ;
                if (this.updateChunkZ >= this.loadingSideInChunks) {
                    this.updateChunkZ = 0;
                    this.updateChunkX = (this.updateChunkX + 1) % this.loadingSideInChunks;
                    this.lastBlockY = new int[4][16];
                    EntityPlayer p = player;
                    ArrayList loadingPlayers = new ArrayList();
                    ArrayList loadingHostile = new ArrayList();
                    ArrayList loadingLiving = new ArrayList();
                    ArrayList loadingItems = new ArrayList();
                    ArrayList<Entity> loadingEntities = new ArrayList<Entity>();
                    for (int i = 0; i < world.field_72996_f.size(); ++i) {
                        try {
                            Entity e = (Entity)world.field_72996_f.get(i);
                            int type = 0;
                            if (e instanceof EntityPlayer) {
                                if (e != p && (!this.modMain.getSettings().getShowPlayers() || !this.modMain.getSettings().getShowOtherTeam() && p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp())) continue;
                                type = 1;
                            } else if (e.getEntityData().func_74764_b("hostileMinimap") ? e.getEntityData().func_74767_n("hostileMinimap") : e instanceof EntityMob || e instanceof IMob) {
                                if (!this.modMain.getSettings().getShowHostile()) continue;
                                type = 2;
                            } else if (e instanceof EntityLiving) {
                                if (!this.modMain.getSettings().getShowMobs()) continue;
                                type = 3;
                            } else if (e instanceof EntityItem) {
                                if (!this.modMain.getSettings().getShowItems()) continue;
                                type = 4;
                            } else if (!this.modMain.getSettings().getShowOther()) continue;
                            double offx = e.field_70165_t - p.field_70165_t;
                            double offy = e.field_70161_v - p.field_70161_v;
                            double offh = p.field_70163_u - e.field_70163_u;
                            double offheight2 = offh * offh;
                            double offx2 = offx * offx;
                            double offy2 = offy * offy;
                            double maxDistance = 31250.0 / (this.getZoom() * this.getZoom());
                            if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(this.modMain.getSettings().heightLimit * this.modMain.getSettings().heightLimit)) continue;
                            ArrayList<Entity> typeList = loadingEntities;
                            switch (type) {
                                case 1: {
                                    typeList = loadingPlayers;
                                    break;
                                }
                                case 2: {
                                    typeList = loadingHostile;
                                    break;
                                }
                                case 3: {
                                    typeList = loadingLiving;
                                    break;
                                }
                                case 4: {
                                    typeList = loadingItems;
                                }
                            }
                            typeList.add(e);
                            if (this.modMain.getSettings().entityAmount == 0 || typeList.size() < 100 * this.modMain.getSettings().entityAmount) continue;
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.loadedPlayers = loadingPlayers;
                    this.loadedHostile = loadingHostile;
                    this.loadedLiving = loadingLiving;
                    this.loadedItems = loadingItems;
                    this.loadedEntities = loadingEntities;
                }
            }
        }
        int passed = (int)(System.nanoTime() - processStart);
        return passed;
    }

    private void updateTile(EntityPlayer player, World world, MinimapChunk mchunk, MinimapChunk oldChunk, int canvasX, int canvasZ, int insideX, int insideZ, boolean onlyLoad) {
        Chunk bchunk;
        int tileX = mchunk.X * 4 + insideX;
        int tileZ = mchunk.Z * 4 + insideZ;
        int halfSide = this.loadingSideInChunks / 2;
        int tileFromCenterX = canvasX - halfSide;
        int tileFromCenterZ = canvasZ - halfSide;
        MinimapTile oldTile = null;
        if (oldChunk != null) {
            oldTile = oldChunk.tiles[insideX][insideZ];
        }
        if (!(bchunk = world.func_72964_e(tileX, tileZ)).func_177410_o() || (onlyLoad || tileFromCenterX > this.updateRadius || tileFromCenterZ > this.updateRadius || tileFromCenterX < -this.updateRadius || tileFromCenterZ < -this.updateRadius) && oldTile != null && oldTile.success && oldChunk.levelsBuffered == this.loadingLevels) {
            if (oldTile != null && oldChunk.levelsBuffered == this.loadingLevels) {
                mchunk.tiles[insideX][insideZ] = oldTile;
                for (int j = 0; j < 16; ++j) {
                    this.lastBlockY[insideX][j] = mchunk.lastHeights[insideX][j];
                }
                mchunk.hasSomething = true;
                if (this.forcedRefresh) {
                    mchunk.changed = true;
                }
            } else {
                this.lastBlockY = new int[4][16];
            }
            return;
        }
        if (oldTile != null && oldChunk.levelsBuffered != this.loadingLevels) {
            oldTile = null;
        }
        int x1 = tileX * 16;
        int z1 = tileZ * 16;
        for (int blockX = x1; blockX < x1 + 16; ++blockX) {
            for (int blockZ = z1; blockZ < z1 + 16; ++blockZ) {
                this.loadBlockColor(player, world, blockX, blockZ, bchunk, canvasX, canvasZ, tileX, tileZ, insideX, insideZ, oldTile);
                if ((blockZ & 0xF) != 15) continue;
                mchunk.lastHeights[insideX][blockX & 0xF] = this.lastBlockY[insideX][blockX & 0xF];
            }
        }
    }

    private int loadBlockColourFromTexture(World world, IBlockState state, IBlockState extended, Block b, BlockPos pos, boolean convert) {
        int stateHash = BlockStateUtil.getHashCode(extended);
        Integer c = this.blockColours.get(stateHash);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                TextureAtlasSprite texture;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                IBakedModel model = bms.func_178125_b(state);
                if (convert) {
                    upQuads = model.func_188616_a(extended, EnumFacing.UP, 0L);
                }
                if (upQuads == null || upQuads.isEmpty()) {
                    texture = bms.func_178122_a(extended);
                    if (texture == bms.func_178126_b().func_174952_b().func_174944_f()) {
                        List quads;
                        for (int i = EnumFacing.field_82609_l.length - 1; i >= 0 && (i == 1 || (quads = model.func_188616_a(extended, EnumFacing.field_82609_l[i], 0L)).isEmpty() || (texture = ((BakedQuad)quads.get(0)).func_187508_a()) == bms.func_178126_b().func_174952_b().func_174944_f()); --i) {
                        }
                    }
                } else {
                    texture = ((BakedQuad)upQuads.get(0)).func_187508_a();
                }
                name = texture.func_94215_i() + ".png";
                if (b instanceof BlockOre && b != Blocks.field_150449_bY) {
                    name = "minecraft:blocks/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    args = new String[]{"minecraft", args[0]};
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                    InputStream input = resource.func_110527_b();
                    BufferedImage img = TextureUtil.func_177053_a((InputStream)input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            if (rgb == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    c = 0xFF000000 | (red /= total) << 16 | (green /= total) << 8 | (blue /= total);
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(world, state, extended, b, pos, false);
                }
                c = 0;
                if (state != null && state.func_185909_g() != null) {
                    c = state.func_185909_g().field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + Block.field_149771_c.func_177774_c((Object)b));
            }
            catch (Exception e) {
                c = state.func_185909_g().field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Exception when loading " + Block.field_149771_c.func_177774_c((Object)b) + " texture, using material colour.");
            }
            if (c != null) {
                this.blockColours.put(stateHash, c);
            }
        }
        int grassColor = 0xFFFFFF;
        try {
            grassColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (grassColor != 0xFFFFFF) {
            float rMultiplier = (float)(c >> 16 & 0xFF) / 255.0f;
            float gMultiplier = (float)(c >> 8 & 0xFF) / 255.0f;
            float bMultiplier = (float)(c & 0xFF) / 255.0f;
            red = (int)((float)(grassColor >> 16 & 0xFF) * rMultiplier);
            green = (int)((float)(grassColor >> 8 & 0xFF) * gMultiplier);
            blue = (int)((float)(grassColor & 0xFF) * bMultiplier);
            c = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return c;
    }

    private boolean applyTransparentBlock(World world, Chunk bchunk, Block b, IBlockState state, IBlockState extended, BlockPos globalPos, BlockPos pos) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int intensity = 1;
        boolean skip = false;
        if (b instanceof BlockLiquid && b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), globalPos) != 255 && b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), globalPos) != 0) {
            switch (this.modMain.getSettings().getBlockColours()) {
                case 1: {
                    red = 0;
                    green = 100;
                    blue = 225;
                    break;
                }
                case 0: {
                    int waterColor = this.loadBlockColourFromTexture(world, state, extended, b, globalPos, true);
                    red = waterColor >> 16 & 0xFF;
                    green = waterColor >> 8 & 0xFF;
                    blue = waterColor & 0xFF;
                }
            }
            intensity = 2;
            skip = true;
        } else if (this.modMain.getSettings().getBlockColours() == 0 && (b.func_180664_k() == BlockRenderLayer.TRANSLUCENT || b instanceof BlockGlass)) {
            int glassColor = this.loadBlockColourFromTexture(world, state, extended, b, globalPos, true);
            red = glassColor >> 16 & 0xFF;
            green = glassColor >> 8 & 0xFF;
            blue = glassColor & 0xFF;
            skip = true;
        } else if (this.modMain.getSettings().getBlockColours() == 1 && b instanceof BlockStainedGlass) {
            int color = state.func_185909_g().field_76291_p;
            red = color >> 16 & 0xFF;
            green = color >> 8 & 0xFF;
            blue = color & 0xFF;
            skip = true;
        }
        if (skip) {
            if (this.previousTransparentBlock == null) {
                for (int i = 0; i < this.loadingLevels; ++i) {
                    this.postBrightness[i] = this.getBlockBrightness(bchunk, new BlockPos(pos.func_177958_n(), Math.min(pos.func_177956_o() + 1, 255), pos.func_177952_p()), 5.0f, this.sun, i);
                }
            }
            int rgb = red << 16 | green << 8 | blue;
            if (this.previousTransparentBlock == null || this.previousTransparentBlock != rgb) {
                this.previousTransparentBlock = rgb;
                float overlayIntensity = (float)intensity * this.getBlockBrightness(bchunk, new BlockPos(pos.func_177958_n(), Math.min(pos.func_177956_o() + 1, 255), pos.func_177952_p()), 5.0f, this.sun, -1);
                if (this.isGlowing(state, bchunk.func_177412_p(), globalPos)) {
                    MinimapGraphics.getBrightestColour(red, green, blue, this.tempColor);
                    red = this.tempColor[0];
                    green = this.tempColor[1];
                    blue = this.tempColor[2];
                }
                this.divider += overlayIntensity;
                this.underRed = (int)((float)this.underRed + (float)red * overlayIntensity);
                this.underGreen = (int)((float)this.underGreen + (float)green * overlayIntensity);
                this.underBlue = (int)((float)this.underBlue + (float)blue * overlayIntensity);
            }
            this.sun -= b.getLightOpacity(state, (IBlockAccess)bchunk.func_177412_p(), globalPos);
            if (this.sun < 0) {
                this.sun = 0;
            }
        }
        return skip;
    }

    public Block findBlock(World world, Chunk bchunk, int insideX, int insideZ, int highY, int lowY) {
        boolean underair = false;
        for (int i = highY; i >= lowY; --i) {
            IBlockState state = bchunk.func_186032_a(insideX, i, insideZ);
            if (state == null) continue;
            Block got = state.func_177230_c();
            if (!(got instanceof BlockAir) && (underair || this.loadingCaving == -1)) {
                if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE || got == Blocks.field_150478_aa || got == Blocks.field_150329_H || got == Blocks.field_150398_cm || !this.modMain.getSettings().showFlowers && (got instanceof BlockFlower || got instanceof BlockDoublePlant || got instanceof BlockDeadBush) || !this.modMain.getSettings().displayRedstone && (got == Blocks.field_150429_aA || got == Blocks.field_150488_af || got instanceof BlockRedstoneRepeater || got instanceof BlockRedstoneComparator)) continue;
                this.blockY = i;
                BlockPos pos = new BlockPos(insideX, this.blockY, insideZ);
                BlockPos globalPos = this.getGlobalBlockPos(bchunk.field_76635_g, bchunk.field_76647_h, insideX, this.blockY, insideZ);
                IBlockState extended = null;
                if (this.modMain.getSettings().getBlockColours() == 0) {
                    try {
                        extended = got.getExtendedState(state, (IBlockAccess)world, globalPos);
                    }
                    catch (RuntimeException e) {
                        extended = state;
                    }
                }
                if (this.modMain.getSettings().blockTransparency && this.applyTransparentBlock(world, bchunk, got, state, extended, globalPos, pos)) continue;
                if (this.modMain.getSettings().getBlockColours() == 1) {
                    MapColor minimapColor = state.func_185909_g();
                    this.blockColor = minimapColor.field_76291_p;
                } else {
                    this.blockColor = this.loadBlockColourFromTexture(world, state, extended, got, globalPos, true);
                }
                if (this.blockColor == 0) continue;
                this.isglowing = this.isGlowing(state, bchunk.func_177412_p(), globalPos);
                return got;
            }
            if (!(got instanceof BlockAir)) continue;
            underair = true;
        }
        return null;
    }

    public BlockPos getGlobalBlockPos(int chunkX, int chunkZ, int x, int y, int z) {
        return new BlockPos(chunkX * 16 + x, y, chunkZ * 16 + z);
    }

    public float getBlockBrightness(Chunk c, BlockPos pos, float min, int sun, int lightLevel) {
        if (!this.modMain.getSettings().getLighting()) {
            return (min + (float)sun) / (15.0f + min);
        }
        return (min + Math.max((lightLevel == -1 || lightLevel == 0 ? 1.0f : ((float)this.loadingLevels - 1.0f - (float)lightLevel) / ((float)this.loadingLevels - 1.0f)) * (float)c.func_177413_a(EnumSkyBlock.SKY, pos), (float)c.func_177413_a(EnumSkyBlock.BLOCK, pos))) / (15.0f + min);
    }

    public boolean isGlowing(IBlockState state, World world, BlockPos pos) {
        return (double)state.getLightValue((IBlockAccess)world, pos) >= 0.5;
    }

    public void loadBlockColor(EntityPlayer player, World world, int par1, int par2, Chunk bchunk, int canvasX, int canvasZ, int tileX, int tileZ, int tileInsideX, int tileInsideZ, MinimapTile oldTile) {
        MinimapTile tile;
        int lowY;
        int insideX = par1 & 0xF;
        int insideZ = par2 & 0xF;
        int playerY = (int)player.field_70163_u;
        int height = bchunk.func_76611_b(insideX, insideZ);
        int highY = this.loadingCaving != -1 ? this.loadingCaving : height + 3;
        int n = lowY = this.loadingCaving != -1 ? playerY - 30 : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        this.blockY = 0;
        this.underRed = 0;
        this.underGreen = 0;
        this.underBlue = 0;
        this.divider = 1.0f;
        this.sun = 15;
        this.previousTransparentBlock = null;
        this.blockColor = 0;
        this.isglowing = false;
        this.secondaryB = 1.0;
        Block block = this.findBlock(world, bchunk, insideX, insideZ, highY, lowY);
        this.isglowing = block != null && !(block instanceof BlockOre) && this.isglowing;
        boolean success = true;
        if (this.lastBlockY[tileInsideX][insideX] <= 0) {
            this.lastBlockY[tileInsideX][insideX] = this.blockY;
            try {
                Chunk prevChunk = world.func_72964_e(tileX, tileZ - 1);
                if (prevChunk != null && prevChunk.func_177410_o()) {
                    this.lastBlockY[tileInsideX][insideX] = prevChunk.func_76611_b(insideX, 15) - 1;
                } else {
                    success = false;
                }
            }
            catch (IllegalStateException e) {
                success = false;
            }
        }
        if (!this.isglowing) {
            BlockPos pos = new BlockPos(insideX, Math.min(this.blockY + 1, 255), insideZ);
            boolean lighting = this.modMain.getSettings().getLighting();
            for (int i = 0; i < this.loadingLevels; ++i) {
                if (!lighting && this.loadingCaving != -1) {
                    int n2 = i;
                    this.brightness[n2] = (float)((double)this.brightness[n2] * Math.min((double)this.blockY / (double)height, 1.0));
                } else {
                    this.brightness[i] = this.getBlockBrightness(bchunk, pos, 5.0f, this.sun, this.previousTransparentBlock == null ? i : -1);
                }
                if (this.previousTransparentBlock != null) continue;
                this.postBrightness[i] = 1.0f;
            }
            if (this.loadingCaving == -1 && this.modMain.getSettings().getTerrainDepth()) {
                this.secondaryB = (double)this.blockY / 63.0;
                if (this.secondaryB > 1.15) {
                    this.secondaryB = 1.15;
                } else if (this.secondaryB < 0.7) {
                    this.secondaryB = 0.7;
                }
            }
            if (this.modMain.getSettings().getTerrainSlopes()) {
                if (this.blockY < this.lastBlockY[tileInsideX][insideX]) {
                    this.secondaryB *= 0.85;
                }
                if (this.blockY > this.lastBlockY[tileInsideX][insideX]) {
                    this.secondaryB *= 1.15;
                }
            }
        }
        this.lastBlockY[tileInsideX][insideX] = this.blockY;
        if (this.isglowing) {
            MinimapGraphics.getBrightestColour(this.blockColor >> 16 & 0xFF, this.blockColor >> 8 & 0xFF, this.blockColor & 0xFF, this.tempColor);
        }
        for (int i = 0; i < this.loadingLevels; ++i) {
            float b;
            if (this.isglowing) {
                this.red[i] = this.tempColor[0];
                this.green[i] = this.tempColor[1];
                this.blue[i] = this.tempColor[2];
                b = 1.0f;
            } else {
                this.red[i] = this.blockColor >> 16 & 0xFF;
                this.green[i] = this.blockColor >> 8 & 0xFF;
                this.blue[i] = this.blockColor & 0xFF;
                b = this.brightness[i];
            }
            this.red[i] = (int)(((double)((float)this.red[i] * b) * this.secondaryB + (double)this.underRed) / (double)this.divider * (double)this.postBrightness[i]);
            if (this.red[i] > 255) {
                this.red[i] = 255;
            }
            this.green[i] = (int)(((double)((float)this.green[i] * b) * this.secondaryB + (double)this.underGreen) / (double)this.divider * (double)this.postBrightness[i]);
            if (this.green[i] > 255) {
                this.green[i] = 255;
            }
            this.blue[i] = (int)(((double)((float)this.blue[i] * b) * this.secondaryB + (double)this.underBlue) / (double)this.divider * (double)this.postBrightness[i]);
            if (this.blue[i] <= 255) continue;
            this.blue[i] = 255;
        }
        if (canvasX < 0 || canvasX >= this.loadingSideInChunks || canvasZ < 0 || canvasZ >= this.loadingSideInChunks) {
            return;
        }
        MinimapChunk chunk = this.loadingBlocks[canvasX][canvasZ];
        if (this.notEmptyColor()) {
            chunk.hasSomething = true;
        }
        if ((tile = chunk.tiles[tileInsideX][tileInsideZ]) == null) {
            chunk.tiles[tileInsideX][tileInsideZ] = tile = new MinimapTile(this.modMain.getSettings(), tileX, tileZ, this.seedForLoading);
        }
        if (insideZ == 0) {
            tile.success = success;
        }
        if (this.notEmptyColor() && (oldTile == null || oldTile.red[0][insideX][insideZ] != this.red[0] || oldTile.green[0][insideX][insideZ] != this.green[0] || oldTile.blue[0][insideX][insideZ] != this.blue[0])) {
            chunk.changed = true;
        }
        for (int i = 0; i < this.loadingLevels; ++i) {
            tile.red[i][insideX][insideZ] = this.red[i];
            tile.green[i][insideX][insideZ] = this.green[i];
            tile.blue[i][insideX][insideZ] = this.blue[i];
        }
    }

    private boolean notEmptyColor() {
        return this.red[0] != 0 || this.green[0] != 0 || this.blue[0] != 0;
    }

    public int getMapCoord(int side, double coord) {
        return (OptimizedMath.myFloor(coord) >> 6) - side / 2;
    }

    void getLoadedBlockColor(int[] result, int par1, int par2, int level) {
        int tileX = par1 >> 4;
        int tileZ = par2 >> 4;
        int chunkX = (tileX >> 2) - this.loadedMapChunkX;
        int chunkZ = (tileZ >> 2) - this.loadedMapChunkZ;
        if (chunkX < 0 || chunkX >= this.currentBlocks.length || chunkZ < 0 || chunkZ >= this.currentBlocks.length) {
            result[2] = 1;
            result[1] = 1;
            result[0] = 1;
            return;
        }
        try {
            MinimapTile tile;
            MinimapChunk current = this.currentBlocks[chunkX][chunkZ];
            if (current != null && (tile = current.tiles[tileX & 3][tileZ & 3]) != null) {
                int insideX = par1 & 0xF;
                int insideZ = par2 & 0xF;
                this.chunkOverlay(result, tile.red[level][insideX][insideZ], tile.green[level][insideX][insideZ], tile.blue[level][insideX][insideZ], tile);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        result[2] = 1;
        result[1] = 1;
        result[0] = 1;
    }

    public void chunkOverlay(int[] result, int red, int green, int blue, MinimapTile c) {
        if (this.modMain.getSettings().getSlimeChunks() && c.slimeChunk) {
            MinimapGraphics.slimeOverlay(result, red, green, blue);
        } else if (this.modMain.getSettings().chunkGrid > -1 && c.chunkGrid) {
            MinimapGraphics.gridOverlay(result, ModSettings.COLORS[this.modMain.getSettings().chunkGrid], red, green, blue);
        } else {
            result[0] = red;
            result[1] = green;
            result[2] = blue;
        }
    }

    public double getRenderAngle(EntityPlayer player) {
        if (this.modMain.getSettings().getLockNorth()) {
            return 90.0;
        }
        return this.getActualAngle(player);
    }

    public double getActualAngle(EntityPlayer player) {
        double angle;
        double rotation = player.field_70177_z;
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    public double getZoom() {
        return this.minimapZoom;
    }

    public void updateZoom() {
        double off;
        double target = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom] * (this.modMain.getSettings().caveZoom && this.loadedCaving != -1 ? 3.0f : 1.0f);
        if (target > (double)this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        off = (off = target - this.minimapZoom) > 0.01 || off < -0.01 ? (double)((float)OldAnimation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public void resetImage() {
        this.toResetImage = true;
    }

    public int[] getMinimapWidthAndBuffer() {
        int[] nArray;
        if (this.enlargedMap) {
            int[] nArray2 = new int[2];
            nArray2[0] = 448;
            nArray = nArray2;
            nArray2[1] = 512;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = minimapSizes[this.modMain.getSettings().getMinimapSize()];
            nArray = nArray3;
            nArray3[1] = bufferSizes[this.modMain.getSettings().getMinimapSize()];
        }
        return nArray;
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public boolean usingFBO() {
        return this.loadedFBO && !this.modMain.getSettings().mapSafeMode;
    }

    private int getCaving(EntityPlayer player, World world) {
        if (!this.modMain.getSettings().getCaveMaps()) {
            return -1;
        }
        if (this.ignoreWorld(world)) {
            return this.lastCaving;
        }
        int x = OptimizedMath.myFloor(player.field_70165_t);
        int y = Math.max((int)player.field_70163_u + 1, 0);
        int z = OptimizedMath.myFloor(player.field_70161_v);
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int insideX = x & 0xF;
        int insideZ = z & 0xF;
        Chunk bchunk = world.func_72964_e(chunkX, chunkZ);
        int top = bchunk.func_76611_b(insideX, insideZ);
        if (y < top) {
            for (int i = y; i < top; ++i) {
                IBlockState state = bchunk.func_186032_a(insideX, i, insideZ);
                if (!state.func_185904_a().func_76218_k()) continue;
                this.lastCaving = Math.min(y + 3, i);
                return this.lastCaving;
            }
        }
        return -1;
    }

    public void loadFrameBuffer() {
        if (!GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            System.out.println("FBO not supported! Using minimap safe mode.");
        } else {
            if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                System.out.println("FBO is supported but off. Turning it on.");
            }
            this.scalingFrameBuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFrameBuffer = new ImprovedFramebuffer(512, 512, false);
            this.loadedFBO = this.scalingFrameBuffer.field_147616_f != -1;
        }
        this.triedFBO = true;
    }

    public void renderChunksToFBO(EntityPlayer player, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError) {
        double zInsidePixel;
        int radius = (int)((double)viewW / Math.sqrt(2.0) / 2.0 / zoom) / 64 + 1;
        double playerX = this.entities.getEntityX((Entity)player, partial);
        double playerZ = this.entities.getEntityZ((Entity)player, partial);
        int xFloored = OptimizedMath.myFloor(playerX);
        int zFloored = OptimizedMath.myFloor(playerZ);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)zoom) != zoom;
        this.scalingFrameBuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GL11.glEnable((int)3553);
        RenderHelper.func_74518_a();
        long before = System.currentTimeMillis();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GL11.glPushMatrix();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GL11.glPushMatrix();
        GlStateManager.func_179096_D();
        before = System.currentTimeMillis();
        double xInsidePixel = this.entities.getEntityX((Entity)player, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = this.entities.getEntityZ((Entity)player, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        zInsidePixel = 1.0 - zInsidePixel;
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(player));
        GlStateManager.func_179147_l();
        GlStateManager.func_179109_b((float)256.0f, (float)256.0f, (float)-2000.0f);
        GlStateManager.func_179139_a((double)zoom, (double)zoom, (double)1.0);
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks() && this.loadedCaving == -1) {
            this.modMain.getSupportMods().worldmapSupport.drawMinimap(xFloored, zFloored, radius, zooming, zoom);
        } else {
            Gui.func_73734_a((int)-256, (int)-256, (int)256, (int)256, (int)black.hashCode());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int minX = playerChunkX - radius - 1;
            int minZ = playerChunkZ - radius - 1;
            int maxX = playerChunkX + radius + 1;
            int maxZ = playerChunkZ + radius + 1;
            for (int X = minX; X <= maxX; ++X) {
                int canvasX = X - this.loadedMapChunkX;
                if (canvasX < 0 || canvasX >= this.currentBlocks.length) continue;
                for (int Z = minZ; Z <= maxZ; ++Z) {
                    MinimapChunk mchunk;
                    int canvasZ = Z - this.loadedMapChunkZ;
                    if (canvasZ < 0 || canvasZ >= this.currentBlocks.length || (mchunk = this.currentBlocks[canvasX][canvasZ]) == null) continue;
                    mchunk.bindTexture(level);
                    if (level >= mchunk.levelsBuffered || mchunk.glTexture[level] == 0) continue;
                    if (!zooming) {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    }
                    int drawX = (mchunk.X - playerChunkX) * 64 - offsetX;
                    int drawZ = (mchunk.Z - playerChunkZ) * 64 - offsetZ - 1;
                    MinimapGraphics.drawMyTexturedModalRect(drawX, drawZ, 0, 0, 64.0f, 64.0f, 64.0f);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (this.modMain.getSettings().chunkGrid > -1) {
                        int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                        r = grid >> 16 & 0xFF;
                        g = grid >> 8 & 0xFF;
                        b = grid & 0xFF;
                    }
                    for (int t = 0; t < 16; ++t) {
                        if (mchunk.tiles[t % 4][t / 4] == null) continue;
                        if (this.modMain.getSettings().getSlimeChunks() && mchunk.tiles[t % 4][t / 4].slimeChunk) {
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)slime.hashCode());
                        }
                        if (this.modMain.getSettings().chunkGrid <= -1 || !mchunk.tiles[t % 4][t / 4].chunkGrid) continue;
                        int gridDrawX = drawX + 16 * (t % 4);
                        int gridDrawZ = drawZ + 16 * (t / 4);
                        Gui.func_73734_a((int)gridDrawX, (int)gridDrawZ, (int)(gridDrawX + 16), (int)(gridDrawZ + 16), (int)new Color(r, g, b, 64).hashCode());
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
        this.scalingFrameBuffer.func_147609_e();
        this.rotationFrameBuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        this.scalingFrameBuffer.func_147612_c();
        GlStateManager.func_179096_D();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179109_b((float)(halfWView + 0.5f), (float)(511.5f - halfWView), (float)-2000.0f);
        if (!this.modMain.getSettings().getLockNorth()) {
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)(-xInsidePixel * zoom), (double)(-zInsidePixel * zoom), (double)0.0);
        GlStateManager.func_179084_k();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.modMain.getSettings().minimapOpacity / 100.0f));
        MinimapGraphics.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        this.mc.func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
        if (this.modMain.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        EntityPlayer p = player;
        this.entities.renderEntityListToFBO(p, this.loadedEntities, angle, playerX, playerZ, partial);
        this.entities.renderEntityListToFBO(p, this.loadedItems, angle, playerX, playerZ, partial);
        this.entities.renderEntityListToFBO(p, this.loadedLiving, angle, playerX, playerZ, partial);
        this.entities.renderEntityListToFBO(p, this.loadedHostile, angle, playerX, playerZ, partial);
        this.entities.renderEntityListToFBO(p, this.loadedPlayers, angle, playerX, playerZ, partial);
        this.mc.func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
        if (!this.modMain.getSettings().alwaysArrow) {
            this.entities.renderEntityDotToFBO(p, (Entity)p, angle, playerX, playerZ, partial);
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        this.rotationFrameBuffer.func_147609_e();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179128_n((int)5889);
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5888);
        GL11.glPopMatrix();
    }

    public static boolean hasMinimapItem(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != ModSettings.minimapItem) continue;
            return true;
        }
        return false;
    }

    public void drawSetChange(ScaledResolution res) {
        if (this.waypoints != null && this.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - this.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)this.waypoints.getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, new Color(255, 255, 255, alpha).hashCode());
            } else {
                this.setChanged = 0L;
            }
        }
    }
}

