/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.nio.IntBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class ImprovedFramebuffer
extends Framebuffer {
    private int type;
    private static final int GL_FB_INCOMPLETE_ATTACHMENT = 36054;
    private static final int GL_FB_INCOMPLETE_MISS_ATTACH = 36055;
    private static final int GL_FB_INCOMPLETE_DRAW_BUFFER = 36059;
    private static final int GL_FB_INCOMPLETE_READ_BUFFER = 36060;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(width, height, useDepthIn);
    }

    public void func_147613_a(int width, int height) {
        GlStateManager.func_179126_j();
        if (this.field_147616_f >= 0) {
            this.func_147608_a();
        }
        this.func_147605_b(width, height);
        this.func_147611_b();
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
    }

    public void func_147605_b(int width, int height) {
        this.field_147621_c = width;
        this.field_147618_d = height;
        this.field_147622_a = width;
        this.field_147620_b = height;
        this.field_147616_f = this.genFrameBuffers();
        if (this.field_147616_f == -1) {
            this.func_147614_f();
            return;
        }
        this.field_147617_g = TextureUtil.func_110996_a();
        if (this.field_147617_g == -1) {
            this.func_147614_f();
            return;
        }
        if (this.field_147619_e) {
            this.field_147624_h = this.genRenderbuffers();
            if (this.field_147617_g == -1) {
                this.func_147614_f();
                return;
            }
        }
        this.func_147607_a(9728);
        GlStateManager.func_179144_i((int)this.field_147617_g);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, this.field_147616_f);
        ImprovedFramebuffer.framebufferTexture2D(this.type, 36160, 36064, 3553, this.field_147617_g, 0);
        if (this.field_147619_e) {
            ImprovedFramebuffer.bindRenderbuffer(this.type, 36161, this.field_147624_h);
            if (!this.isStencilEnabled()) {
                ImprovedFramebuffer.renderbufferStorage(this.type, 36161, 33190, this.field_147622_a, this.field_147620_b);
                ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36096, 36161, this.field_147624_h);
            } else {
                ImprovedFramebuffer.renderbufferStorage(this.type, 36161, 35056, this.field_147622_a, this.field_147620_b);
                ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36096, 36161, this.field_147624_h);
                ImprovedFramebuffer.framebufferRenderbuffer(this.type, 36160, 36128, 36161, this.field_147624_h);
            }
        }
        this.func_147614_f();
        this.func_147606_d();
    }

    private int genFrameBuffers() {
        int fbo = -1;
        this.type = -1;
        if (GLContext.getCapabilities().OpenGL30) {
            fbo = GL30.glGenFramebuffers();
            this.type = 0;
        } else if (GLContext.getCapabilities().GL_ARB_framebuffer_object) {
            fbo = ARBFramebufferObject.glGenFramebuffers();
            this.type = 1;
        } else if (GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            fbo = EXTFramebufferObject.glGenFramebuffersEXT();
            this.type = 2;
        }
        return fbo;
    }

    public int genRenderbuffers() {
        int rbo = -1;
        switch (this.type) {
            case 0: {
                rbo = GL30.glGenRenderbuffers();
                break;
            }
            case 1: {
                rbo = ARBFramebufferObject.glGenRenderbuffers();
                break;
            }
            case 2: {
                rbo = EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return rbo;
    }

    public void func_147608_a() {
        this.func_147606_d();
        this.func_147609_e();
        if (this.field_147624_h > -1) {
            this.deleteRenderbuffers(this.field_147624_h);
            this.field_147624_h = -1;
        }
        if (this.field_147617_g > -1) {
            TextureUtil.func_147942_a((int)this.field_147617_g);
            this.field_147617_g = -1;
        }
        if (this.field_147616_f > -1) {
            ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
            this.deleteFramebuffers(this.field_147616_f);
            this.field_147616_f = -1;
        }
    }

    private void deleteFramebuffers(int framebufferIn) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteFramebuffers((int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebufferIn);
            }
        }
    }

    private void deleteRenderbuffers(int renderbuffer) {
        switch (this.type) {
            case 0: {
                GL30.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
            }
        }
    }

    public void func_147611_b() {
        int i = this.checkFramebufferStatus(36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    private int checkFramebufferStatus(int target) {
        switch (this.type) {
            case 0: {
                return GL30.glCheckFramebufferStatus((int)target);
            }
            case 1: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)target);
            }
            case 2: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
            }
        }
        return -1;
    }

    public static void bindFramebuffer(int type, int target, int framebufferIn) {
        switch (type) {
            case 0: {
                GL30.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebufferIn);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebufferIn);
            }
        }
    }

    public static void framebufferTexture2D(int type, int target, int attachment, int textarget, int texture, int level) {
        switch (type) {
            case 0: {
                GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void bindRenderbuffer(int type, int target, int renderbuffer) {
        switch (type) {
            case 0: {
                GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
            }
        }
    }

    public static void renderbufferStorage(int type, int target, int internalFormat, int width, int height) {
        switch (type) {
            case 0: {
                GL30.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 1: {
                ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                break;
            }
            case 2: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalFormat, (int)width, (int)height);
            }
        }
    }

    public static void framebufferRenderbuffer(int type, int target, int attachment, int renderBufferTarget, int renderBuffer) {
        switch (type) {
            case 0: {
                GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 1: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                break;
            }
            case 2: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
            }
        }
    }

    public void func_147610_a(boolean p_147610_1_) {
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, this.field_147616_f);
        if (p_147610_1_) {
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_147621_c, (int)this.field_147618_d);
        }
    }

    public void func_147609_e() {
        ImprovedFramebuffer.bindFramebuffer(this.type, 36160, 0);
    }

    public void func_147612_c() {
        GlStateManager.func_179144_i((int)this.field_147617_g);
    }

    public void func_147606_d() {
        GlStateManager.func_179144_i((int)0);
    }

    public void func_147607_a(int framebufferFilterIn) {
        this.field_147623_j = framebufferFilterIn;
        GlStateManager.func_179144_i((int)this.field_147617_g);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)framebufferFilterIn);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)framebufferFilterIn);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
        GlStateManager.func_179144_i((int)0);
    }
}

