/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces;

import java.util.ConcurrentModificationException;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import xaero.common.interfaces.CursorBox;
import xaero.common.interfaces.InterfaceHandler;
import xaero.common.interfaces.Preset;
import xaero.common.settings.ModOptions;

public abstract class Interface {
    public CursorBox cBox;
    public String iname;
    public int id;
    public int bx;
    public int by;
    public int x;
    public int y;
    public int actualx;
    public int actualy;
    public int w0;
    public int h0;
    public int w;
    public int h;
    public int wc;
    public int hc;
    public boolean multi;
    public boolean centered;
    public boolean bcentered;
    public boolean flipped;
    public boolean bflipped;
    public boolean cflipped;
    public boolean fromRight;
    public boolean bfromRight;
    public ModOptions option;

    public Interface(InterfaceHandler interfaceHandler, String name, int w, int h, ModOptions option) {
        this(interfaceHandler, name, w, h, w, h, option);
    }

    public Interface(InterfaceHandler interfaceHandler, String name, int w, int h, int wc, int hc, ModOptions option) {
        this.iname = name;
        this.w0 = this.w = w;
        this.h0 = this.h = h;
        this.wc = wc;
        this.hc = hc;
        this.multi = wc != w || hc != h;
        this.flipped = false;
        this.cflipped = false;
        this.bflipped = false;
        interfaceHandler.list.add(this);
        this.id = interfaceHandler.list.indexOf(this);
        Preset preset = interfaceHandler.presets.get(0);
        this.actualx = this.x = preset.coords[this.id][0];
        this.bx = this.x;
        this.actualy = this.y = preset.coords[this.id][1];
        this.by = this.y;
        this.bcentered = this.centered = preset.types[this.id][0];
        this.bfromRight = this.fromRight = preset.types[this.id][1];
        this.option = option;
        this.cBox = new CursorBox(3){

            @Override
            public String getString(int line) {
                switch (line) {
                    case 0: {
                        return I18n.func_135052_a((String)Interface.this.iname, (Object[])new Object[0]);
                    }
                    case 1: {
                        return I18n.func_135052_a((String)"gui.xaero_centered", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)(Interface.this.centered ? "gui.xaero_true" : "gui.xaero_false"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"gui.xaero_press_c", (Object[])new Object[0]);
                    }
                    case 2: {
                        return I18n.func_135052_a((String)"gui.xaero_flipped", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)(Interface.this.flipped ? "gui.xaero_true" : "gui.xaero_false"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"gui.xaero_press_f", (Object[])new Object[0]);
                    }
                }
                return "";
            }
        };
    }

    public int getW(int scale) {
        return this.w;
    }

    public int getH(int scale) {
        return this.h;
    }

    public int getWC(int scale) {
        return this.wc;
    }

    public int getHC(int scale) {
        return this.hc;
    }

    public int getW0(int scale) {
        return this.w0;
    }

    public int getH0(int scale) {
        return this.h0;
    }

    public int getSize() {
        return this.w * this.h;
    }

    public void drawInterface(int width, int height, int scale, float partial) throws ConcurrentModificationException {
        if (this.fromRight) {
            this.x = width - this.x;
        }
        GL11.glEnable((int)3008);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public boolean shouldFlip(int width) {
        return this.flipped && this.x + this.w / 2 < width / 2 || !this.flipped && this.x + this.w / 2 > width / 2;
    }
}

