/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.MySmallButton;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;

public class GuiTransfer
extends GuiScreen {
    public GuiScreen parentScreen;
    public MySmallButton transferButton;
    public ArrayList<GuiDropDown> dropDowns = new ArrayList();
    public GuiWaypointContainers containers1;
    public GuiWaypointWorlds worlds1;
    public GuiWaypointContainers containers2;
    public GuiWaypointWorlds worlds2;
    private IXaeroMinimap modMain;
    private Minimap minimap;
    private boolean dropped = false;

    public GuiTransfer(IXaeroMinimap modMain, GuiScreen par1) {
        this.modMain = modMain;
        this.minimap = modMain.getInterfaces().getMinimap();
        this.parentScreen = par1;
        this.containers1 = new GuiWaypointContainers(modMain, this.minimap);
        this.containers2 = new GuiWaypointContainers(modMain, this.minimap);
        this.worlds1 = new GuiWaypointWorlds(this.minimap.getWorldContainer(this.containers1.getCurrentKey()), this.minimap);
        this.worlds2 = new GuiWaypointWorlds(this.minimap.getWorldContainer(this.containers2.getCurrentKey()), this.minimap);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.transferButton = new MySmallButton(5, this.field_146294_l / 2 - 155, this.field_146295_m / 7 + 120, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0]));
        this.field_146292_n.add(this.transferButton);
        this.transferButton.field_146124_l = false;
        this.field_146292_n.add(new MySmallButton(6, this.field_146294_l / 2 + 5, this.field_146295_m / 7 + 120, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.dropDowns.clear();
        this.dropDowns.add(new GuiDropDown(this.worlds1.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 20, 200, this.worlds1.current));
        this.dropDowns.add(new GuiDropDown(this.worlds2.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 50, 200, this.worlds2.current));
        this.dropDowns.add(new GuiDropDown(this.containers1.options, this.field_146294_l / 2 - 202, this.field_146295_m / 7 + 20, 200, this.containers1.current));
        this.dropDowns.add(new GuiDropDown(this.containers2.options, this.field_146294_l / 2 - 202, this.field_146295_m / 7 + 50, 200, this.containers2.current));
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.closed && d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.closed = true;
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.closed = true;
        }
        if (this.dropped) {
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146124_l) {
            switch (p_146284_1_.field_146127_k) {
                case 5: {
                    this.transfer();
                    break;
                }
                case 6: {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                }
            }
        }
    }

    public void transfer() {
        try {
            WaypointWorld currentWorld = this.minimap.getCurrentWorld();
            String[] keys1 = this.worlds1.getCurrentKeys();
            String[] keys2 = this.worlds2.getCurrentKeys();
            WaypointWorld from = this.minimap.getWorld(keys1[0], keys1[1]);
            WaypointWorld to = this.minimap.getWorld(keys2[0], keys2[1]);
            Object[] keys = from.sets.keySet().toArray();
            Object[] values = from.sets.values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String setName = (String)keys[i];
                WaypointSet fromSet = (WaypointSet)values[i];
                WaypointSet toSet = to.sets.get(setName);
                if (toSet == null) {
                    toSet = new WaypointSet(setName, currentWorld);
                }
                for (Waypoint w : fromSet.list) {
                    Waypoint copy = new Waypoint(w.x, w.y, w.z, w.name, w.symbol, w.color, w.type);
                    copy.rotation = w.rotation;
                    copy.setDisabled(w.isDisabled());
                    copy.yaw = w.yaw;
                    toSet.list.add(copy);
                }
                to.sets.put(setName, toSet);
            }
            if (keys2[0] != null && !keys2[0].equals(this.minimap.customContainerID)) {
                this.minimap.customContainerID = keys2[0];
            }
            if (keys2[1] != null && !keys2[1].equals(this.minimap.customWorldID)) {
                this.minimap.customWorldID = keys2[1];
            }
            this.minimap.updateWaypoints();
            if (this.parentScreen instanceof GuiWaypoints) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypoints(this.modMain, ((GuiWaypoints)this.parentScreen).parentScreen));
            }
            this.modMain.getSettings().saveWaypoints(to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        super.func_146276_q_();
        this.updateSelections();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_transfer_all", (Object[])new Object[0]), this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_from", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 10, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_to", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 40, 0xFFFFFF);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get((int)k).closed) {
                this.dropDowns.get(k).drawButton(par1, par2);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get((int)k).closed) continue;
            this.dropDowns.get(k).drawButton(par1, par2);
        }
    }

    private void updateSelections() {
        if (this.containers1.current != this.dropDowns.get((int)2).selected) {
            this.containers1.current = this.dropDowns.get((int)2).selected;
            this.worlds1 = new GuiWaypointWorlds(this.minimap.getWorldContainer(this.containers1.getCurrentKey()), this.minimap);
            this.dropDowns.set(0, new GuiDropDown(this.worlds1.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 20, 200, this.worlds1.current));
        }
        if (this.containers2.current != this.dropDowns.get((int)3).selected) {
            this.containers2.current = this.dropDowns.get((int)3).selected;
            this.worlds2 = new GuiWaypointWorlds(this.minimap.getWorldContainer(this.containers2.getCurrentKey()), this.minimap);
            this.dropDowns.set(1, new GuiDropDown(this.worlds2.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 50, 200, this.worlds2.current));
        }
        this.worlds1.current = this.dropDowns.get((int)0).selected;
        this.worlds2.current = this.dropDowns.get((int)1).selected;
        this.transferButton.field_146124_l = this.containers1.current != this.containers2.current || this.worlds1.current != this.worlds2.current;
    }
}

