/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.OldAnimation;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiMisc;
import xaero.common.gui.GuiUpdate;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.settings.ModSettings;
import xaero.common.util.OptimizedMath;
import xaero.patreon.GuiUpdateAll;
import xaero.patreon.Patreon3;

public class Events {
    private IXaeroMinimap modMain;
    public Object lastGuiOpen;
    int deathCounter = 0;
    public static Field realmsTaskField = null;
    public static Field realmsTaskServerField = null;
    private static boolean askedToUpdate = false;

    public Events(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void drawPost(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiOptions) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((GuiScreen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void drawPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modMain.getInterfaces().drawInterfaces(event.getPartialTicks());
            this.modMain.getInterfaces().getMinimap().drawSetChange(event.getResolution());
            OldAnimation.tick();
        }
    }

    @SubscribeEvent
    public void renderPre(RenderGameOverlayEvent.Pre event) {
        if (Keyboard.isKeyDown((int)1)) {
            this.modMain.getInterfaces().cancel();
        }
        this.drawPre(event);
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu || event.getGui() instanceof GuiMultiplayer) {
            this.modMain.getSettings().resetServerSettings();
        }
        if (event.getGui() instanceof GuiGameOver) {
            ++this.deathCounter;
            if ((this.deathCounter & 1) == 0) {
                this.createDeathpoint((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
        if (event.getGui() instanceof GuiScreenRealmsProxy && ((GuiScreenRealmsProxy)event.getGui()).func_154321_a() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (realmsTaskField == null) {
                    realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("task");
                    realmsTaskField.setAccessible(true);
                }
                if (realmsTaskServerField == null) {
                    realmsTaskServerField = RealmsTasks.RealmsGetServerDetailsTask.class.getDeclaredField("server");
                    realmsTaskServerField.setAccessible(true);
                }
                if ((task = realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((GuiScreenRealmsProxy)event.getGui()).func_154321_a())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.modMain.getInterfaces().getMinimap().latestRealm == null || realm.id != this.modMain.getInterfaces().getMinimap().latestRealm.id)) {
                    this.modMain.getInterfaces().getMinimap().latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createDeathpoint(EntityPlayer p) {
        Minimap minimap = this.modMain.getInterfaces().getMinimap();
        boolean disabled = false;
        if (minimap.waypoints == null) {
            return;
        }
        for (Waypoint w : minimap.waypoints.list) {
            if (w.type != 1) continue;
            disabled = w.isDisabled();
            if (!this.modMain.getSettings().getDeathpoints() || !this.modMain.getSettings().getOldDeathpoints()) {
                minimap.waypoints.list.remove(w);
                break;
            }
            w.type = 0;
            w.name = "gui.xaero_deathpoint_old";
            break;
        }
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor(p.field_70165_t), OptimizedMath.myFloor(p.field_70163_u), OptimizedMath.myFloor(p.field_70161_v), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            minimap.waypoints.list.add(deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(minimap.getCurrentWorld());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chatMessage(ClientChatReceivedEvent e) {
        String text = e.getMessage().func_150254_d();
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replace("\u00a7", "").replace("r", "").replace(" ", "");
            this.modMain.getSettings().resetServerSettings();
            this.modMain.getSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            System.out.println("Code: " + code);
        }
    }

    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        Minimap minimap = this.modMain.getInterfaces().getMinimap();
        if (this.modMain.getSettings().getShowIngameWaypoints() && minimap.waypoints != null) {
            int i;
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.getPartialTicks();
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.getPartialTicks();
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.getPartialTicks();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexBuffer = tessellator.func_178180_c();
            for (i = 0; i < minimap.waypoints.list.size(); ++i) {
                Waypoint w = minimap.waypoints.list.get(i);
                this.renderIngameWaypoint(w, 12.0, d3, d4, d5, entity, vertexBuffer, tessellator);
            }
            if (ServerWaypointStorage.working() && minimap.serverWaypoints != null) {
                for (i = 0; i < minimap.serverWaypoints.size(); ++i) {
                    this.renderIngameWaypoint(minimap.serverWaypoints.get(i), 12.0, d3, d4, d5, entity, vertexBuffer, tessellator);
                }
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    protected void renderIngameWaypoint(Waypoint w, double radius, double d3, double d4, double d5, Entity entity, VertexBuffer vertexBuffer, Tessellator tessellator) {
        double distance;
        if (w.isDisabled() || w.type == 1 && !this.modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)w.x - (float)d3 + 0.5f;
        float offY = (float)w.y - (float)d4 + 1.0f;
        float offZ = (float)w.z - (float)d5 + 0.5f;
        w.lastDistance = distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if (this.modMain.getSettings().waypointsDistance != 0.0f && distance > (double)this.modMain.getSettings().waypointsDistance || this.modMain.getSettings().waypointsDistanceMin != 0.0f && distance < (double)this.modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        float textSize = 1.0f;
        String name = w.getName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (this.modMain.getSettings().keepWaypointNames) {
            textSize = 1.6f;
        }
        if (distance > radius) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                float zoomer = (float)(maxDistance / distance);
                offX *= zoomer;
                offY *= zoomer;
                offY += entity.func_70047_e() * (1.0f - zoomer);
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(distance / radius);
            }
            if (distance > 20.0) {
                textSize = 1.6f;
                if (this.modMain.getSettings().distance == 1) {
                    float cameraAngle;
                    float offset;
                    float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                    float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                    if (offZ < 0.0f) {
                        angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                    }
                    showDistance = (offset = MathHelper.func_76142_g((float)(angle - (cameraAngle = MathHelper.func_76142_g((float)entity.field_70177_z))))) > -20.0f && offset < 20.0f;
                } else if (this.modMain.getSettings().distance == 2) {
                    showDistance = true;
                }
                if (showDistance) {
                    distanceText = GuiMisc.simpleFormat.format(distance) + "m";
                    if (!this.modMain.getSettings().keepWaypointNames) {
                        name = "";
                    }
                } else {
                    name = "";
                }
            }
        }
        GlStateManager.func_179109_b((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179152_a((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        w.drawIconInWorld(this.modMain.getSettings(), vertexBuffer, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    protected void onOutdated() {
        if (Patreon3.patronPledge >= 5) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdateAll());
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdate(this.modMain, "A newer version of Xaero's Minimap is available!"));
        }
        System.out.println("Minimap is outdated!");
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiUpdate) {
            askedToUpdate = true;
        } else if (!askedToUpdate && this.modMain.isOutdated() && event.getGui() instanceof GuiMainMenu) {
            this.onOutdated();
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) {
        this.modMain.getInterfaces().getMinimap().clearBlockColours = true;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Patreon3.renderCape(this.modMain.getFileLayoutID(), event);
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        this.modMain.getInterfaces().getMinimap().currentSpawn = event.getNewSpawn();
    }
}

