/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.minimap.Minimap;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.util.OptimizedMath;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected Minimap minimap;
    public static final KeyBinding[] toAdd = new KeyBinding[]{ModSettings.keySwitchSet, ModSettings.keyInstantWaypoint, ModSettings.keyToggleSlimes, ModSettings.keyToggleGrid, ModSettings.keyToggleWaypoints, ModSettings.keyToggleMap, ModSettings.keyLargeMap, ModSettings.keyWaypoints, ModSettings.keyBindZoom, ModSettings.keyBindZoom1, ModSettings.newWaypoint};

    public ControlsHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.minimap = modMain.getInterfaces().getMinimap();
        for (KeyBinding kb : toAdd) {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
    }

    public void setKeyState(KeyBinding kb, boolean pressed) {
        KeyBinding.func_74510_a((int)kb.func_151463_i(), (boolean)pressed);
    }

    public boolean isDown(KeyBinding kb) {
        return GameSettings.func_100015_a((KeyBinding)kb);
    }

    public void keyDownPre(KeyBinding kb) {
    }

    public void keyDownPost(KeyBinding kb) {
    }

    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd && !mc.field_71442_b.func_78747_a()) {
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI()) {
                mc.func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, null, null));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI()) {
                mc.func_147108_a((GuiScreen)new GuiWaypoints(this.modMain, null));
            }
            if (kb == ModSettings.keyLargeMap) {
                this.minimap.enlargedMap = true;
                this.minimap.resetImage();
            }
            if (kb == ModSettings.keyToggleMap) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.MINIMAP, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.INGAME_WAYPOINTS, 0);
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded() && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(this.modMain, Minecraft.func_71410_x().field_71462_r));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyInstantWaypoint && this.modMain.getSettings().waypointsGUI() && this.minimap.waypoints.list != null) {
                Waypoint instant = new Waypoint(OptimizedMath.myFloor(mc.field_71439_g.field_70165_t), OptimizedMath.myFloor(mc.field_71439_g.field_70163_u), OptimizedMath.myFloor(mc.field_71439_g.field_70161_v), "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length));
                this.minimap.waypoints.list.add(instant);
                try {
                    this.modMain.getSettings().saveWaypoints(this.minimap.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keySwitchSet) {
                WaypointWorld currentWorld = this.minimap.getCurrentWorld();
                String[] keys = currentWorld.sets.keySet().toArray(new String[0]);
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null || !keys[i].equals(currentWorld.current)) continue;
                    currentWorld.current = keys[(i + 1) % keys.length];
                    break;
                }
                this.minimap.updateWaypoints();
                this.minimap.setChanged = System.currentTimeMillis();
                try {
                    this.modMain.getSettings().saveWaypoints(currentWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyBinding kb) {
    }

    public void keyUpPost(KeyBinding kb) {
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (kb == ModSettings.keyBindZoom) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.ZOOM, 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyBindZoom1) {
                --this.modMain.getSettings().zoom;
                if (this.modMain.getSettings().zoom == -1) {
                    this.modMain.getSettings().zoom = this.modMain.getSettings().zooms.length - 1;
                }
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (kb == ModSettings.keyLargeMap) {
                this.minimap.enlargedMap = false;
                this.minimap.resetImage();
            }
            this.keyUpPost(kb);
        }
    }
}

