/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.world.aura;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.Thaumcraft;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.aura.AuraWorld;

public class AuraThread
implements Runnable {
    public int dim;
    private final long INTERVAL = 1000L;
    private boolean stop = false;
    Random rand = new Random(System.currentTimeMillis());
    private float phaseVis = 0.0f;
    private float phaseFlux = 0.0f;
    private long lastWorldTime = 0L;
    private float[] phaseTable = new float[]{0.25f, 0.15f, 0.1f, 0.05f, 0.0f, 0.05f, 0.1f, 0.15f};

    public AuraThread(int dim2) {
        this.dim = dim2;
    }

    @Override
    public void run() {
        Thaumcraft.log.info("Starting aura thread for dim " + this.dim);
        while (!this.stop) {
            if (AuraHandler.auras.isEmpty()) {
                Thaumcraft.log.warn("No auras found!");
                break;
            }
            long startTime = System.currentTimeMillis();
            AuraWorld auraWorld = AuraHandler.getAuraWorld(this.dim);
            if (auraWorld != null) {
                WorldServer world = DimensionManager.getWorld((int)this.dim);
                if (this.lastWorldTime != world.func_72820_D()) {
                    this.lastWorldTime = world.func_72820_D();
                    if (world != null) {
                        this.phaseVis = this.phaseTable[world.field_73011_w.func_76559_b(world.func_72912_H().func_76073_f())];
                        this.phaseFlux = 0.25f - this.phaseVis;
                    }
                    for (AuraChunk auraChunk : auraWorld.auraChunks.values()) {
                        this.processAuraChunk(auraWorld, auraChunk);
                    }
                }
            } else {
                this.stop();
            }
            long executionTime = System.currentTimeMillis() - startTime;
            try {
                if (executionTime > 1000L) {
                    Thaumcraft.log.warn("AURAS TAKING " + (executionTime - 1000L) + " ms LONGER THAN NORMAL IN DIM " + this.dim);
                }
                Thread.sleep(Math.max(1L, 1000L - executionTime));
            }
            catch (InterruptedException interruptedException) {}
        }
        Thaumcraft.log.info("Stopping aura thread for dim " + this.dim);
        ServerEvents.auraThreads.remove(this.dim);
    }

    private void processAuraChunk(AuraWorld auraWorld, AuraChunk auraChunk) {
        List<Integer> directions = Arrays.asList(0, 1, 2, 3);
        Collections.shuffle(directions, this.rand);
        int x = auraChunk.loc.field_77276_a;
        int y = auraChunk.loc.field_77275_b;
        short base = auraChunk.getBase();
        boolean dirty = false;
        float currentVis = auraChunk.getVis();
        float currentFlux = auraChunk.getFlux();
        AuraChunk neighbourVisChunk = null;
        AuraChunk neighbourFluxChunk = null;
        float lowestVis = Float.MAX_VALUE;
        float lowestFlux = Float.MAX_VALUE;
        for (Integer a : directions) {
            EnumFacing dir = EnumFacing.func_176731_b((int)a);
            AuraChunk n = auraWorld.getAuraChunkAt(x + dir.func_82601_c(), y + dir.func_82599_e());
            if (n == null) continue;
            if ((neighbourVisChunk == null || lowestVis > n.getVis()) && n.getVis() + n.getFlux() < (float)n.getBase()) {
                neighbourVisChunk = n;
                lowestVis = n.getVis();
            }
            if (neighbourFluxChunk != null && !(lowestFlux > n.getFlux())) continue;
            neighbourFluxChunk = n;
            lowestFlux = n.getFlux();
        }
        if (neighbourVisChunk != null && lowestVis < currentVis && (double)(lowestVis / currentVis) < 0.75) {
            float inc = Math.min(currentVis - lowestVis, 1.0f);
            currentVis -= inc;
            neighbourVisChunk.setVis(lowestVis + inc);
            dirty = true;
            this.markChunkAsDirty(neighbourVisChunk, auraWorld.dim);
        }
        if (neighbourFluxChunk != null && currentFlux > 1.0f && (double)lowestFlux < (double)currentFlux / 1.75) {
            float inc = Math.min(currentFlux - lowestFlux, 1.0f);
            currentFlux -= inc;
            neighbourFluxChunk.setFlux(lowestFlux + inc);
            dirty = true;
            this.markChunkAsDirty(neighbourFluxChunk, auraWorld.dim);
        }
        if (currentVis + currentFlux < (float)base) {
            float inc = Math.min((float)base - (currentVis + currentFlux), this.phaseVis);
            currentVis += inc;
            dirty = true;
        } else if ((double)currentVis > (double)base * 1.1 && (double)this.rand.nextFloat() < 0.1) {
            currentFlux += this.phaseFlux;
            currentVis -= this.phaseFlux;
            dirty = true;
        } else if ((double)currentVis <= (double)base * 0.1 && currentVis >= currentFlux && (double)this.rand.nextFloat() < 0.1) {
            currentFlux += this.phaseFlux;
            dirty = true;
        }
        if (dirty) {
            auraChunk.setVis(currentVis);
            auraChunk.setFlux(currentFlux);
            this.markChunkAsDirty(auraChunk, auraWorld.dim);
        }
        if ((double)currentFlux > (double)base * 0.75 && this.rand.nextFloat() < currentFlux / 500.0f / 10.0f) {
            AuraHandler.taintTrigger.put(auraWorld.dim, new BlockPos(x * 16, 0, y * 16));
        }
    }

    private void markChunkAsDirty(AuraChunk chunk, int dim) {
        CopyOnWriteArrayList<ChunkPos> dc;
        if (chunk.isModified()) {
            return;
        }
        ChunkPos pos = new ChunkPos(chunk.loc.field_77276_a, chunk.loc.field_77275_b);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }

    public void stop() {
        this.stop = true;
    }
}

