/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.HexUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileThaumcraftInventory;
import thaumcraft.common.tiles.crafting.FocalData;
import thaumcraft.common.world.aura.AuraHandler;

public class TileFocalManipulator
extends TileThaumcraftInventory
implements ITickable {
    public float vis = 0.0f;
    public FocalData data = null;
    int ticks = 0;
    public float visCost = 0.0f;
    public int xpCost = 0;
    public float castCost = 0.0f;
    private AspectList crystals = new AspectList();
    public AspectList crystalsSync = new AspectList();
    public static final int XP_MULT = 3;
    public static final int VIS_MULT = 100;
    public boolean doGuiReset = false;

    public TileFocalManipulator() {
        this.syncedSlots = new int[]{0};
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        super.readSyncNBT(nbttagcompound);
        this.vis = nbttagcompound.func_74760_g("vis");
        this.crystalsSync = new AspectList();
        this.crystalsSync.readFromNBT(nbttagcompound, "crystals");
        this.deserializeData(nbttagcompound);
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        super.writeSyncNBT(nbttagcompound);
        nbttagcompound.func_74776_a("vis", this.vis);
        if (this.data != null) {
            this.serializeData(nbttagcompound, this.data);
        }
        this.crystalsSync.writeToNBT(nbttagcompound, "crystals");
        return nbttagcompound;
    }

    public void serializeData(NBTTagCompound nbt, FocalData data) {
        NBTTagList gridtag = new NBTTagList();
        for (String hex : data.hexes.keySet()) {
            String key = data.hexes.get(hex);
            if (hex == null || hex.isEmpty() || key == null || key.isEmpty()) continue;
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74778_a("hex", hex);
            gt.func_74778_a("key", key);
            gridtag.func_74742_a((NBTBase)gt);
        }
        nbt.func_74782_a("hexgrid", (NBTBase)gridtag);
    }

    public void deserializeData(NBTTagCompound nbt) {
        this.generateHexes(false);
        if (nbt == null) {
            return;
        }
        NBTTagList grid = nbt.func_150295_c("hexgrid", 10);
        for (int x = 0; x < grid.func_74745_c(); ++x) {
            NBTTagCompound gt = grid.func_150305_b(x);
            this.data.hexes.put(gt.func_74779_i("hex"), gt.func_74779_i("key"));
        }
    }

    public void placePart(int q, int r, String part, EntityPlayer player) {
        if (this.data == null) {
            return;
        }
        HexUtils.Hex h = new HexUtils.Hex(q, r);
        this.data.hexes.put(h.toString(), part);
        this.func_70296_d();
    }

    private void generateHexes(boolean sync) {
        this.data = new FocalData();
        HashMap<String, HexUtils.Hex> hexLocs = HexUtils.generateHexes(1);
        HashMap<String, String> hexes = new HashMap<String, String>();
        for (HexUtils.Hex hex : hexLocs.values()) {
            hexes.put(hex.toString(), "");
        }
        this.data.hexes = hexes;
        if (sync) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Override
    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        super.func_70299_a(par1, par2ItemStack);
        if (this.field_145850_b.field_72995_K) {
            this.doGuiReset = true;
        } else {
            this.vis = 0.0f;
        }
    }

    public float spendAura(float vis) {
        if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
            float q = vis;
            float z = vis / 9.0f;
            block0: for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (z > q) {
                        z = q;
                    }
                    if ((q -= AuraHandler.drainVis(this.func_145831_w(), this.func_174877_v().func_177982_a(xx * 16, 0, zz * 16), z, false)) <= 0.0f) break block0;
                }
            }
            return vis - q;
        }
        return AuraHandler.drainVis(this.func_145831_w(), this.func_174877_v(), vis, false);
    }

    public void func_73660_a() {
        boolean complete = false;
        ++this.ticks;
        if (!this.field_145850_b.field_72995_K) {
            if (this.data == null) {
                this.generateHexes(false);
                this.syncTile(false);
            }
            if (this.ticks % 20 == 0) {
                if (this.vis > 0.0f && (this.func_70301_a(0) == null || this.func_70301_a(0).func_77973_b() != ItemsTC.focusBlank)) {
                    complete = true;
                    this.vis = 0.0f;
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wandfail, SoundCategory.BLOCKS, 0.33f, 1.0f);
                }
                if (!complete && this.vis > 0.0f) {
                    float amt = this.spendAura(Math.min(20.0f, this.vis));
                    if (amt > 0.0f) {
                        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 5, 1);
                        this.vis -= amt;
                        this.syncTile(false);
                        this.func_70296_d();
                    }
                    if (this.vis <= 0.0f && this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == ItemsTC.focusBlank) {
                        complete = true;
                        this.endCraft();
                    }
                }
            }
        } else {
            if (this.ticks % 20 == 0) {
                this.doGuiReset = true;
            }
            if (this.vis > 0.0f) {
                FXDispatcher.INSTANCE.drawGenericParticles((double)this.field_174879_c.func_177958_n() + 0.5 + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f), (double)this.field_174879_c.func_177956_o() + 1.4 + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f), 0.0, 0.0, 0.0, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f, 1.0f - this.field_145850_b.field_73012_v.nextFloat() * 0.4f, 1.0f - this.field_145850_b.field_73012_v.nextFloat() * 0.4f, 0.8f, false, 448, 9, 1, 6 + this.field_145850_b.field_73012_v.nextInt(5), 0, 0.3f + this.field_145850_b.field_73012_v.nextFloat() * 0.3f, 0.0f, 0);
            }
        }
        if (complete) {
            this.vis = 0.0f;
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    private FocusCore genCore() {
        if (this.data != null) {
            FocusCore core = new FocusCore();
            ArrayList<FocusCore.FocusEffect> effects = new ArrayList<FocusCore.FocusEffect>();
            for (String hs : this.data.hexes.keySet()) {
                HexUtils.Hex h = HexUtils.Hex.fromString(hs);
                String mainKey = this.data.hexes.get(hs);
                IFocusPart mainPart = FocusHelper.getFocusPart(mainKey);
                if (mainPart == null) continue;
                ArrayList<IFocusPartModifier> mods = new ArrayList<IFocusPartModifier>();
                for (int a = 0; a < 6; ++a) {
                    IFocusPart part;
                    HexUtils.Hex target = h.getNeighbour(a);
                    String key = this.data.hexes.get(target.toString());
                    if (key == null || key.isEmpty() || !FocusHelper.canPartsConnect(part = FocusHelper.getFocusPart(key), mainPart) || !(part instanceof IFocusPartModifier)) continue;
                    mods.add((IFocusPartModifier)part);
                }
                if (mainPart.getType() == IFocusPart.EnumFocusPartType.MEDIUM) {
                    core.medium = (IFocusPartMedium)mainPart;
                    core.mediumModifiers = mods.toArray(new IFocusPartModifier[mods.size()]);
                }
                if (mainPart.getType() != IFocusPart.EnumFocusPartType.EFFECT) continue;
                FocusCore.FocusEffect fe = new FocusCore.FocusEffect();
                fe.effect = (IFocusPartEffect)mainPart;
                fe.modifiers = mods.toArray(new IFocusPartModifier[mods.size()]);
                effects.add(fe);
            }
            core.effects = effects.toArray(new FocusCore.FocusEffect[effects.size()]);
            core.generate();
            return core;
        }
        return null;
    }

    public void endCraft() {
        FocusCore core;
        this.vis = 0.0f;
        if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == ItemsTC.focusBlank && (core = this.genCore()) != null) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 1.0f, 1.0f);
            ItemStack focus = new ItemStack(ItemsTC.focus);
            ItemFocus.setCore(focus, core);
            this.func_70299_a(0, focus);
            this.generateHexes(true);
            this.crystalsSync = new AspectList();
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public boolean startCraft(int id, EntityPlayer p) {
        if (this.data == null || this.vis > 0.0f || this.func_70301_a(0) == null || this.func_70301_a(0).func_77973_b() != ItemsTC.focusBlank) {
            return false;
        }
        for (String hs : this.data.hexes.keySet()) {
            String mainKey = this.data.hexes.get(hs);
            Aspect[] part = FocusHelper.getFocusPart(mainKey);
            if (part == null || ThaumcraftCapabilities.knowsResearchStrict(p, part.getResearch())) continue;
            return false;
        }
        FocusCore core = this.calcCosts();
        if (this.crystals.getAspects().length > 0) {
            ItemStack[] components = new ItemStack[this.crystals.getAspects().length];
            int r = 0;
            for (Aspect as : this.crystals.getAspects()) {
                components[r] = ThaumcraftApiHelper.makeCrystal(as, this.crystals.getAmount(as));
                ++r;
            }
            if (components.length >= 0) {
                int a;
                for (a = 0; a < components.length; ++a) {
                    if (InventoryUtils.isPlayerCarryingAmount(p, components[a], false)) continue;
                    return false;
                }
                for (a = 0; a < components.length; ++a) {
                    InventoryUtils.consumeInventoryItem(p, components[a], true, false);
                }
                this.crystalsSync = this.crystals.copy();
            }
        } else {
            return false;
        }
        if (!p.field_71075_bZ.field_75098_d && p.field_71068_ca < this.xpCost) {
            return false;
        }
        if (!p.field_71075_bZ.field_75098_d) {
            p.func_71013_b(this.xpCost);
        }
        this.vis = this.visCost;
        this.func_70296_d();
        this.syncTile(false);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.craftstart, SoundCategory.BLOCKS, 1.0f, 1.0f);
        ItemStack focus = new ItemStack(ItemsTC.focus);
        ItemFocus.setCore(focus, core);
        FMLCommonHandler.instance().firePlayerCraftingEvent(p, focus, (IInventory)this);
        return true;
    }

    public FocusCore calcCosts() {
        this.crystals = new AspectList();
        this.visCost = 0.0f;
        this.xpCost = 0;
        this.castCost = 0.0f;
        FocusCore core = this.genCore();
        if (core == null) {
            return null;
        }
        this.xpCost = core.partsRaw.size() * 3;
        if (core.partsRaw.size() > 0) {
            this.visCost = 100.0f;
        }
        for (int a = 1; a < core.partsRaw.size(); ++a) {
            this.visCost = (float)((double)this.visCost * 1.5);
        }
        this.castCost = core.cost;
        for (IFocusPart p : core.partsRaw.values()) {
            this.crystals.add(p.getAspect(), 1);
        }
        return core;
    }

    @Override
    public boolean func_94041_b(int par1, ItemStack stack) {
        return stack != null && stack.func_77973_b() == ItemsTC.focusBlank;
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.generateHexes(false);
            this.doGuiReset = true;
        }
        if (i == 5) {
            if (this.field_145850_b.field_72995_K) {
                FXDispatcher.INSTANCE.visSparkle(this.field_174879_c.func_177958_n() + this.func_145831_w().field_73012_v.nextInt(3) - this.func_145831_w().field_73012_v.nextInt(3), this.field_174879_c.func_177956_o() + this.func_145831_w().field_73012_v.nextInt(3), this.field_174879_c.func_177952_p() + this.func_145831_w().field_73012_v.nextInt(3) - this.func_145831_w().field_73012_v.nextInt(3), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), j);
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }
}

