/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research.theorycraft;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftCard;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.utils.InventoryUtils;

public class CardMindOverMatter
extends TheorycraftCard {
    ItemStack stack;
    static ItemStack[] options = new ItemStack[]{new ItemStack(ItemsTC.ingots, 1, 2), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151042_j), new ItemStack(ItemsTC.gear), new ItemStack(ItemsTC.plate), new ItemStack(ItemsTC.plate, 1, 1), new ItemStack(ItemsTC.mirroredGlass), new ItemStack(ItemsTC.baubles), new ItemStack(ItemsTC.baubles, 1, 1), new ItemStack(ItemsTC.baubles, 1, 2), new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_185161_cS), new ItemStack(Items.field_151059_bz), new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151064_bs), new ItemStack(Items.field_179563_cD), new ItemStack(Items.field_179562_cC), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_179556_br), new ItemStack(Items.field_151070_bp)};

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound nbt = super.serialize();
        nbt.func_74782_a("stack", (NBTBase)this.stack.serializeNBT());
        return nbt;
    }

    @Override
    public void deserialize(NBTTagCompound nbt) {
        super.deserialize(nbt);
        this.stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
    }

    @Override
    public boolean initialize(EntityPlayer player, ResearchTableData data) {
        Random r = new Random(this.getSeed());
        this.stack = options[r.nextInt(options.length)].func_77946_l();
        return this.stack != null;
    }

    @Override
    public int getInspirationCost() {
        return 1;
    }

    @Override
    public String getResearchCategory() {
        return "ARTIFICE";
    }

    @Override
    public String getLocalizedName() {
        return new TextComponentTranslation("card.mindmatter.name", new Object[0]).func_150254_d();
    }

    @Override
    public String getLocalizedText() {
        return new TextComponentTranslation("card.mindmatter.text", new Object[]{this.getVal()}).func_150254_d();
    }

    private int getVal() {
        int q = 5;
        try {
            q = (int)((double)q + Math.sqrt(ThaumcraftCraftingManager.getObjectTags(this.stack).visSize()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return q;
    }

    @Override
    public ItemStack[] getRequiredItems() {
        return new ItemStack[]{this.stack};
    }

    @Override
    public boolean activate(EntityPlayer player, ResearchTableData data) {
        if (InventoryUtils.consumeInventoryItem(player, this.stack, false, true)) {
            data.addTotal(this.getResearchCategory(), this.getVal());
            return true;
        }
        return false;
    }
}

