/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research.theorycraft;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftCard;
import thaumcraft.common.items.curios.ItemCurio;
import thaumcraft.common.lib.utils.InventoryUtils;

public class CardCurio
extends TheorycraftCard {
    ItemStack curio = null;

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound nbt = super.serialize();
        nbt.func_74782_a("stack", (NBTBase)this.curio.serializeNBT());
        return nbt;
    }

    @Override
    public void deserialize(NBTTagCompound nbt) {
        super.deserialize(nbt);
        this.curio = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
    }

    @Override
    public int getInspirationCost() {
        return 1;
    }

    @Override
    public String getLocalizedName() {
        return new TextComponentTranslation("card.curio.name", new Object[0]).func_150254_d();
    }

    @Override
    public String getLocalizedText() {
        return new TextComponentTranslation("card.curio.text", new Object[0]).func_150254_d();
    }

    @Override
    public ItemStack[] getRequiredItems() {
        return new ItemStack[]{this.curio};
    }

    @Override
    public boolean initialize(EntityPlayer player, ResearchTableData data) {
        Random r = new Random(this.getSeed());
        ArrayList<ItemStack> curios = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemCurio)) continue;
            ItemStack c = stack.func_77946_l();
            c.field_77994_a = 1;
            curios.add(c);
        }
        if (!curios.isEmpty()) {
            this.curio = (ItemStack)curios.get(r.nextInt(curios.size()));
        }
        return this.curio != null;
    }

    @Override
    public boolean activate(EntityPlayer player, ResearchTableData data) {
        if (InventoryUtils.consumeInventoryItem(player, this.getRequiredItems()[0], false, false)) {
            String type;
            data.addTotal("BASICS", 5);
            String[] s = ResearchCategories.researchCategories.keySet().toArray(new String[0]);
            data.addTotal(s[player.func_70681_au().nextInt(s.length)], 5);
            switch (type = ((ItemCurio)this.getRequiredItems()[0].func_77973_b()).getVariantNames()[this.getRequiredItems()[0].func_77952_i()]) {
                case "arcane": {
                    data.addTotal("AUROMANCY", 20);
                    break;
                }
                case "preserved": {
                    data.addTotal("ALCHEMY", 20);
                    break;
                }
                case "ancient": {
                    data.addTotal("GOLEMANCY", 20);
                    break;
                }
                case "eldritch": {
                    data.addTotal("ELDRITCH", 20);
                    break;
                }
                case "knowledge": {
                    data.addTotal("INFUSION", 20);
                    break;
                }
                case "twisted": {
                    data.addTotal("ARTIFICE", 20);
                    break;
                }
                case "rites": {
                    data.addTotal("ELDRITCH", MathHelper.func_76136_a((Random)player.func_70681_au(), (int)10, (int)15));
                    data.addTotal("AUROMANCY", MathHelper.func_76136_a((Random)player.func_70681_au(), (int)5, (int)15));
                    break;
                }
                default: {
                    data.addTotal("BASICS", 25);
                }
            }
            if (player.func_70681_au().nextBoolean()) {
                ++data.bonusDraws;
            }
            if (player.func_70681_au().nextBoolean()) {
                ++data.bonusDraws;
            }
            return true;
        }
        return false;
    }
}

