/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research.theorycraft;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftCard;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.lib.utils.InventoryUtils;

public class CardChannel
extends TheorycraftCard {
    Aspect aspect;

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound nbt = super.serialize();
        nbt.func_74778_a("aspect", this.aspect.getTag());
        return nbt;
    }

    @Override
    public void deserialize(NBTTagCompound nbt) {
        super.deserialize(nbt);
        this.aspect = Aspect.getAspect(nbt.func_74779_i("aspect"));
    }

    @Override
    public boolean initialize(EntityPlayer player, ResearchTableData data) {
        Random r = new Random(this.getSeed());
        int num = r.nextInt(Aspect.getCompoundAspects().size());
        this.aspect = Aspect.getCompoundAspects().get(num);
        return true;
    }

    @Override
    public int getInspirationCost() {
        return 1;
    }

    @Override
    public String getResearchCategory() {
        return "INFUSION";
    }

    @Override
    public String getLocalizedName() {
        return new TextComponentTranslation("card.channel.name", new Object[]{TextFormatting.DARK_BLUE + this.aspect.getName() + TextFormatting.RESET + "" + TextFormatting.BOLD}).func_150254_d();
    }

    @Override
    public String getLocalizedText() {
        return new TextComponentTranslation("card.channel.text", new Object[]{TextFormatting.BOLD + this.aspect.getName() + TextFormatting.RESET}).func_150254_d();
    }

    @Override
    public ItemStack[] getRequiredItems() {
        return new ItemStack[]{ItemPhial.makeFilledPhial(this.aspect)};
    }

    @Override
    public boolean activate(EntityPlayer player, ResearchTableData data) {
        if (InventoryUtils.consumeInventoryItem(player, this.getRequiredItems()[0], false, false)) {
            data.addTotal(this.getResearchCategory(), 15);
            return true;
        }
        return false;
    }
}

