/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.world.aura.AuraHandler;

public class WorldEvents {
    public static WorldEvents INSTANCE = new WorldEvents();

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            AuraHandler.addAuraWorld(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        SealHandler.sealEntities.remove(event.getWorld().field_73011_w.getDimension());
        AuraHandler.removeAuraWorld(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public void placeBlockEvent(BlockEvent.PlaceEvent event) {
        if (this.isNearActiveBoss(event.getWorld(), event.getPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void placeBlockEvent(BlockEvent.MultiPlaceEvent event) {
        if (this.isNearActiveBoss(event.getWorld(), event.getPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) {
            event.setCanceled(true);
        }
    }

    private boolean isNearActiveBoss(World world, EntityPlayer player, int x, int y, int z) {
        return false;
    }

    @SubscribeEvent
    public void noteEvent(NoteBlockEvent.Play event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!TileArcaneEar.noteBlockEvents.containsKey(event.getWorld().field_73011_w.getDimension())) {
            TileArcaneEar.noteBlockEvents.put(event.getWorld().field_73011_w.getDimension(), new ArrayList());
        }
        ArrayList<Integer[]> list = TileArcaneEar.noteBlockEvents.get(event.getWorld().field_73011_w.getDimension());
        list.add(new Integer[]{event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), event.getInstrument().ordinal(), event.getVanillaNoteId()});
        TileArcaneEar.noteBlockEvents.put(event.getWorld().field_73011_w.getDimension(), list);
    }

    @SubscribeEvent
    public void explosionEventDetonate(ExplosionEvent.Detonate event) {
        if (event.getAffectedEntities() != null && !event.getWorld().field_72995_K) {
            for (Entity e : event.getAffectedEntities()) {
                if (e == null || !(e instanceof EntityItem) || ((EntityItem)e).func_92059_d() == null || ((EntityItem)e).func_92059_d().func_77973_b() != ItemsTC.primordialPearl || ((EntityItem)e).func_92059_d().func_77952_i() != 2) continue;
                int qq = 0;
                for (int q = 0; q < ((EntityItem)e).func_92059_d().field_77994_a; ++q) {
                    int num = 2 + event.getWorld().field_73012_v.nextInt(2);
                    for (int a = 0; a < num; ++a) {
                        EntityItem entityitem = new EntityItem(event.getWorld(), e.field_70165_t, e.field_70163_u, e.field_70161_v, new ItemStack(ItemsTC.primordialPearl));
                        entityitem.func_174869_p();
                        entityitem.field_70159_w *= 3.0;
                        entityitem.field_70181_x *= 3.0;
                        entityitem.field_70179_y *= 3.0;
                        if (e.captureDrops) {
                            e.capturedDrops.add(entityitem);
                        } else {
                            e.field_70170_p.func_72838_d((Entity)entityitem);
                        }
                        BlockPos p = new BlockPos(event.getExplosion().getPosition());
                        int xx = MathHelper.func_76136_a((Random)event.getWorld().field_73012_v, (int)-4, (int)4);
                        int yy = MathHelper.func_76136_a((Random)event.getWorld().field_73012_v, (int)0, (int)4);
                        int zz = MathHelper.func_76136_a((Random)event.getWorld().field_73012_v, (int)-4, (int)4);
                        p = p.func_177982_a(xx, yy, zz);
                        AuraHelper.polluteAura(event.getWorld(), p, 5 + event.getWorld().field_73012_v.nextInt(10), event.getWorld().func_175623_d(p) && qq++ < 8);
                    }
                }
            }
        }
    }
}

